/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs;

import com.sun.org.apache.xerces.internal.impl.xs.SchemaGrammar;
import com.sun.org.apache.xerces.internal.impl.xs.SchemaSymbols;
import com.sun.org.apache.xerces.internal.impl.xs.SubstitutionGroupHandler;
import com.sun.org.apache.xerces.internal.impl.xs.XSAnnotationImpl;
import com.sun.org.apache.xerces.internal.impl.xs.XSElementDecl;
import com.sun.org.apache.xerces.internal.impl.xs.util.NSItemListImpl;
import com.sun.org.apache.xerces.internal.impl.xs.util.StringListImpl;
import com.sun.org.apache.xerces.internal.impl.xs.util.XSNamedMap4Types;
import com.sun.org.apache.xerces.internal.impl.xs.util.XSNamedMapImpl;
import com.sun.org.apache.xerces.internal.impl.xs.util.XSObjectListImpl;
import com.sun.org.apache.xerces.internal.util.SymbolHash;
import com.sun.org.apache.xerces.internal.util.XMLSymbols;
import com.sun.org.apache.xerces.internal.xs.StringList;
import com.sun.org.apache.xerces.internal.xs.XSAttributeDeclaration;
import com.sun.org.apache.xerces.internal.xs.XSAttributeGroupDefinition;
import com.sun.org.apache.xerces.internal.xs.XSElementDeclaration;
import com.sun.org.apache.xerces.internal.xs.XSModel;
import com.sun.org.apache.xerces.internal.xs.XSModelGroupDefinition;
import com.sun.org.apache.xerces.internal.xs.XSNamedMap;
import com.sun.org.apache.xerces.internal.xs.XSNamespaceItemList;
import com.sun.org.apache.xerces.internal.xs.XSNotationDeclaration;
import com.sun.org.apache.xerces.internal.xs.XSObject;
import com.sun.org.apache.xerces.internal.xs.XSObjectList;
import com.sun.org.apache.xerces.internal.xs.XSTypeDefinition;
import java.util.Vector;

public class XSModelImpl
implements XSModel {
    private static final short MAX_COMP_IDX = 16;
    private static final boolean[] GLOBAL_COMP = new boolean[]{false, true, true, true, false, true, true, false, false, false, false, true, false, false, false, true, true};
    private int fGrammarCount;
    private String[] fNamespaces;
    private SchemaGrammar[] fGrammarList;
    private SymbolHash fGrammarMap;
    private SymbolHash fSubGroupMap;
    private XSNamedMap[] fGlobalComponents;
    private XSNamedMap[][] fNSComponents;
    private XSObjectListImpl fAnnotations = null;
    private boolean fHasIDC = false;

    private void buildSubGroups() {
        SubstitutionGroupHandler substitutionGroupHandler = new SubstitutionGroupHandler(null);
        int n = 0;
        while (n < this.fGrammarCount) {
            substitutionGroupHandler.addSubstitutionGroup(this.fGrammarList[n].getSubstitutionGroups());
            ++n;
        }
        XSNamedMap xSNamedMap = this.getComponents((short)2);
        int n2 = xSNamedMap.getLength();
        this.fSubGroupMap = new SymbolHash(n2 * 2);
        int n3 = 0;
        while (n3 < n2) {
            XSElementDecl xSElementDecl = (XSElementDecl)xSNamedMap.item(n3);
            XSObject[] xSObjectArray = substitutionGroupHandler.getSubstitutionGroup(xSElementDecl);
            this.fSubGroupMap.put(xSElementDecl, new XSObjectListImpl(xSObjectArray, xSObjectArray.length));
            ++n3;
        }
    }

    public boolean hasIDConstraints() {
        return this.fHasIDC;
    }

    public XSModelImpl(SchemaGrammar[] schemaGrammarArray) {
        int n = schemaGrammarArray.length;
        this.fNamespaces = new String[Math.max(n + 1, 5)];
        this.fGrammarList = new SchemaGrammar[Math.max(n + 1, 5)];
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            this.fNamespaces[n2] = schemaGrammarArray[n2].getTargetNamespace();
            this.fGrammarList[n2] = schemaGrammarArray[n2];
            if (this.fNamespaces[n2] == SchemaSymbols.URI_SCHEMAFORSCHEMA) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            this.fNamespaces[n] = SchemaSymbols.URI_SCHEMAFORSCHEMA;
            this.fGrammarList[n++] = SchemaGrammar.SG_SchemaNS;
        }
        int n3 = 0;
        while (n3 < n) {
            SchemaGrammar schemaGrammar = this.fGrammarList[n3];
            Vector vector = schemaGrammar.getImportedGrammars();
            int n4 = vector == null ? -1 : vector.size() - 1;
            while (n4 >= 0) {
                SchemaGrammar schemaGrammar2 = (SchemaGrammar)vector.elementAt(n4);
                int n5 = 0;
                while (n5 < n) {
                    if (schemaGrammar2 == this.fGrammarList[n5]) break;
                    ++n5;
                }
                if (n5 == n) {
                    if (n == this.fGrammarList.length) {
                        String[] stringArray = new String[n * 2];
                        System.arraycopy(this.fNamespaces, 0, stringArray, 0, n);
                        this.fNamespaces = stringArray;
                        SchemaGrammar[] schemaGrammarArray2 = new SchemaGrammar[n * 2];
                        System.arraycopy(this.fGrammarList, 0, schemaGrammarArray2, 0, n);
                        this.fGrammarList = schemaGrammarArray2;
                    }
                    this.fNamespaces[n] = schemaGrammar2.getTargetNamespace();
                    this.fGrammarList[n] = schemaGrammar2;
                    ++n;
                }
                --n4;
            }
            ++n3;
        }
        this.fGrammarMap = new SymbolHash(n * 2);
        n3 = 0;
        while (n3 < n) {
            this.fGrammarMap.put(XSModelImpl.null2EmptyString(this.fNamespaces[n3]), this.fGrammarList[n3]);
            if (this.fGrammarList[n3].hasIDConstraints()) {
                this.fHasIDC = true;
            }
            ++n3;
        }
        this.fGrammarCount = n;
        this.fGlobalComponents = new XSNamedMap[17];
        this.fNSComponents = new XSNamedMap[n][17];
        this.buildSubGroups();
    }

    public StringList getNamespaces() {
        return new StringListImpl(this.fNamespaces, this.fGrammarCount);
    }

    public synchronized XSNamedMap getComponents(short s) {
        if (s <= 0 || s > 16 || !GLOBAL_COMP[s]) {
            return null;
        }
        SymbolHash[] symbolHashArray = new SymbolHash[this.fGrammarCount];
        if (this.fGlobalComponents[s] == null) {
            int n = 0;
            while (n < this.fGrammarCount) {
                switch (s) {
                    case 3: 
                    case 15: 
                    case 16: {
                        symbolHashArray[n] = this.fGrammarList[n].fGlobalTypeDecls;
                        break;
                    }
                    case 1: {
                        symbolHashArray[n] = this.fGrammarList[n].fGlobalAttrDecls;
                        break;
                    }
                    case 2: {
                        symbolHashArray[n] = this.fGrammarList[n].fGlobalElemDecls;
                        break;
                    }
                    case 5: {
                        symbolHashArray[n] = this.fGrammarList[n].fGlobalAttrGrpDecls;
                        break;
                    }
                    case 6: {
                        symbolHashArray[n] = this.fGrammarList[n].fGlobalGroupDecls;
                        break;
                    }
                    case 11: {
                        symbolHashArray[n] = this.fGrammarList[n].fGlobalNotationDecls;
                    }
                }
                ++n;
            }
            this.fGlobalComponents[s] = s == 15 || s == 16 ? new XSNamedMap4Types(this.fNamespaces, symbolHashArray, this.fGrammarCount, s) : new XSNamedMapImpl(this.fNamespaces, symbolHashArray, this.fGrammarCount);
        }
        return this.fGlobalComponents[s];
    }

    public XSNamespaceItemList getNamespaceItems() {
        return new NSItemListImpl(this.fGrammarList, this.fGrammarCount);
    }

    public synchronized XSObjectList getAnnotations() {
        if (this.fAnnotations != null) {
            return this.fAnnotations;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.fGrammarCount) {
            n += this.fGrammarList[n2].fNumAnnotations;
            ++n2;
        }
        XSObject[] xSObjectArray = new XSAnnotationImpl[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.fGrammarCount) {
            SchemaGrammar schemaGrammar = this.fGrammarList[n4];
            System.arraycopy(schemaGrammar.fAnnotations, 0, xSObjectArray, n3, schemaGrammar.fNumAnnotations);
            n3 += schemaGrammar.fNumAnnotations;
            ++n4;
        }
        this.fAnnotations = new XSObjectListImpl(xSObjectArray, xSObjectArray.length);
        return this.fAnnotations;
    }

    public synchronized XSNamedMap getComponentsByNamespace(short s, String string) {
        if (s <= 0 || s > 16 || !GLOBAL_COMP[s]) {
            return null;
        }
        int n = 0;
        while (n < this.fGrammarCount) {
            if (this.fNamespaces[n] == string) break;
            ++n;
        }
        if (n == this.fGrammarCount) {
            return null;
        }
        if (this.fNSComponents[n][s] == null) {
            SymbolHash symbolHash = null;
            switch (s) {
                case 3: 
                case 15: 
                case 16: {
                    symbolHash = this.fGrammarList[n].fGlobalTypeDecls;
                    break;
                }
                case 1: {
                    symbolHash = this.fGrammarList[n].fGlobalAttrDecls;
                    break;
                }
                case 2: {
                    symbolHash = this.fGrammarList[n].fGlobalElemDecls;
                    break;
                }
                case 5: {
                    symbolHash = this.fGrammarList[n].fGlobalAttrGrpDecls;
                    break;
                }
                case 6: {
                    symbolHash = this.fGrammarList[n].fGlobalGroupDecls;
                    break;
                }
                case 11: {
                    symbolHash = this.fGrammarList[n].fGlobalNotationDecls;
                }
            }
            this.fNSComponents[n][s] = s == 15 || s == 16 ? new XSNamedMap4Types(string, symbolHash, s) : new XSNamedMapImpl(string, symbolHash);
        }
        return this.fNSComponents[n][s];
    }

    public XSObjectList getSubstitutionGroup(XSElementDeclaration xSElementDeclaration) {
        return (XSObjectList)this.fSubGroupMap.get(xSElementDeclaration);
    }

    private static final String null2EmptyString(String string) {
        return string == null ? XMLSymbols.EMPTY_STRING : string;
    }

    public XSAttributeDeclaration getAttributeDeclaration(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSAttributeDeclaration)schemaGrammar.fGlobalAttrDecls.get(string);
    }

    public XSAttributeGroupDefinition getAttributeGroup(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSAttributeGroupDefinition)schemaGrammar.fGlobalAttrGrpDecls.get(string);
    }

    public XSElementDeclaration getElementDeclaration(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSElementDeclaration)schemaGrammar.fGlobalElemDecls.get(string);
    }

    public XSModelGroupDefinition getModelGroupDefinition(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSModelGroupDefinition)schemaGrammar.fGlobalGroupDecls.get(string);
    }

    public XSNotationDeclaration getNotationDeclaration(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSNotationDeclaration)schemaGrammar.fGlobalNotationDecls.get(string);
    }

    public XSTypeDefinition getTypeDefinition(String string, String string2) {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(string2));
        if (schemaGrammar == null) {
            return null;
        }
        return (XSTypeDefinition)schemaGrammar.fGlobalTypeDecls.get(string);
    }
}

