/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.opti;

import com.sun.org.apache.xerces.internal.impl.xs.opti.AttrImpl;
import com.sun.org.apache.xerces.internal.impl.xs.opti.DefaultDocument;
import com.sun.org.apache.xerces.internal.impl.xs.opti.ElementImpl;
import com.sun.org.apache.xerces.internal.impl.xs.opti.NodeImpl;
import com.sun.org.apache.xerces.internal.impl.xs.opti.TextImpl;
import com.sun.org.apache.xerces.internal.util.XMLSymbols;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchemaDOM
extends DefaultDocument {
    static final int relationsRowResizeFactor = 15;
    static final int relationsColResizeFactor = 10;
    NodeImpl[][] relations;
    ElementImpl parent;
    int currLoc;
    int nextFreeLoc;
    boolean hidden;
    StringBuffer fAnnotationBuffer = null;

    public SchemaDOM() {
        this.reset();
    }

    void endAnnotationCDATA() {
        this.fAnnotationBuffer.append("]]>");
    }

    public void endElement() {
        this.currLoc = this.parent.row;
        this.parent = (ElementImpl)this.relations[this.currLoc][0];
    }

    public void printDOM() {
    }

    public void reset() {
        if (this.relations != null) {
            int n = 0;
            while (n < this.relations.length) {
                int n2 = 0;
                while (n2 < this.relations[n].length) {
                    this.relations[n][n2] = null;
                    ++n2;
                }
                ++n;
            }
        }
        this.relations = new NodeImpl[15][];
        this.parent = new ElementImpl(0, 0);
        this.parent.rawname = "DOCUMENT_NODE";
        this.currLoc = 0;
        this.nextFreeLoc = 1;
        int n = 0;
        while (n < 15) {
            this.relations[n] = new NodeImpl[10];
            ++n;
        }
        this.relations[this.currLoc][0] = this.parent;
    }

    private void resizeRelations() {
        NodeImpl[][] nodeImplArrayArray = new NodeImpl[this.relations.length + 15][];
        System.arraycopy(this.relations, 0, nodeImplArrayArray, 0, this.relations.length);
        int n = this.relations.length;
        while (n < nodeImplArrayArray.length) {
            nodeImplArrayArray[n] = new NodeImpl[10];
            ++n;
        }
        this.relations = nodeImplArrayArray;
    }

    void startAnnotationCDATA() {
        this.fAnnotationBuffer.append("<![CDATA[");
    }

    public static void indent(int n) {
        int n2 = 0;
        while (n2 < n) {
            System.out.print(' ');
            ++n2;
        }
    }

    private void resizeRelations(int n) {
        NodeImpl[] nodeImplArray = new NodeImpl[this.relations[n].length + 10];
        System.arraycopy(this.relations[n], 0, nodeImplArray, 0, this.relations[n].length);
        this.relations[n] = nodeImplArray;
    }

    void endAnnotationElement(QName qName, boolean bl) {
        if (bl) {
            this.fAnnotationBuffer.append("\n</").append(qName.rawname).append(">");
            ElementImpl elementImpl = (ElementImpl)this.relations[this.currLoc][1];
            if (this.nextFreeLoc == this.relations.length) {
                this.resizeRelations();
            }
            elementImpl.parentRow = this.nextFreeLoc++;
            int n = elementImpl.parentRow;
            boolean bl2 = false;
            int n2 = 1;
            while (n2 < this.relations[n].length) {
                if (this.relations[n][n2] == null) {
                    bl2 = true;
                    break;
                }
                ++n2;
            }
            if (!bl2) {
                this.resizeRelations(n);
            }
            this.relations[n][n2] = new TextImpl(this.fAnnotationBuffer, this, n, n2);
            this.fAnnotationBuffer = null;
        } else {
            this.fAnnotationBuffer.append("</").append(qName.rawname).append(">");
        }
    }

    void characters(XMLString xMLString) {
        int n = xMLString.offset;
        while (n < xMLString.offset + xMLString.length) {
            if (xMLString.ch[n] == '&') {
                this.fAnnotationBuffer.append("&amp;");
            } else if (xMLString.ch[n] == '<') {
                this.fAnnotationBuffer.append("&lt;");
            } else {
                this.fAnnotationBuffer.append(xMLString.ch[n]);
            }
            ++n;
        }
    }

    void comment(XMLString xMLString) {
        this.fAnnotationBuffer.append("<!--").append(xMLString.toString()).append("-->");
    }

    public Element getDocumentElement() {
        return (ElementImpl)this.relations[0][1];
    }

    public static void traverse(Node node, int n) {
        Object object;
        SchemaDOM.indent(n);
        System.out.print("<" + node.getNodeName());
        if (node.hasAttributes()) {
            object = node.getAttributes();
            int n2 = 0;
            while (n2 < object.getLength()) {
                System.out.print("  " + ((Attr)object.item(n2)).getName() + "=\"" + ((Attr)object.item(n2)).getValue() + "\"");
                ++n2;
            }
        }
        if (node.hasChildNodes()) {
            System.out.println(">");
            n += 4;
            object = node.getFirstChild();
            while (object != null) {
                SchemaDOM.traverse((Node)object, n);
                object = object.getNextSibling();
            }
            SchemaDOM.indent(n -= 4);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    void startAnnotationElement(QName qName, XMLAttributes xMLAttributes) {
        this.fAnnotationBuffer.append("<").append(qName.rawname).append(" ");
        int n = 0;
        while (n < xMLAttributes.getLength()) {
            String string = xMLAttributes.getValue(n);
            this.fAnnotationBuffer.append(" ").append(xMLAttributes.getQName(n)).append("=\"").append(SchemaDOM.processAttValue(string)).append("\" ");
            ++n;
        }
        this.fAnnotationBuffer.append(">");
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, int n, int n2) {
        ElementImpl elementImpl = new ElementImpl(n, n2);
        this.processElement(qName, xMLAttributes, elementImpl);
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, int n, int n2) {
        ElementImpl elementImpl = new ElementImpl(n, n2);
        this.processElement(qName, xMLAttributes, elementImpl);
        this.parent = elementImpl;
    }

    private static String processAttValue(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    void processingInstruction(String string, String string2) {
        this.fAnnotationBuffer.append("<?").append(string).append(" ").append(string2).append("?>");
    }

    private void processElement(QName qName, XMLAttributes xMLAttributes, ElementImpl elementImpl) {
        elementImpl.prefix = qName.prefix;
        elementImpl.localpart = qName.localpart;
        elementImpl.rawname = qName.rawname;
        elementImpl.uri = qName.uri;
        elementImpl.schemaDOM = this;
        Attr[] attrArray = new Attr[xMLAttributes.getLength()];
        int n = 0;
        while (n < xMLAttributes.getLength()) {
            attrArray[n] = new AttrImpl(null, xMLAttributes.getPrefix(n), xMLAttributes.getLocalName(n), xMLAttributes.getQName(n), xMLAttributes.getURI(n), xMLAttributes.getValue(n));
            ++n;
        }
        elementImpl.attrs = attrArray;
        if (this.nextFreeLoc == this.relations.length) {
            this.resizeRelations();
        }
        if (this.relations[this.currLoc][0] != this.parent) {
            this.relations[this.nextFreeLoc][0] = this.parent;
            this.currLoc = this.nextFreeLoc++;
        }
        boolean bl = false;
        int n2 = 1;
        n2 = 1;
        while (n2 < this.relations[this.currLoc].length) {
            if (this.relations[this.currLoc][n2] == null) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            this.resizeRelations(this.currLoc);
        }
        this.relations[this.currLoc][n2] = elementImpl;
        this.parent.parentRow = this.currLoc;
        elementImpl.row = this.currLoc;
        elementImpl.col = n2;
    }

    void startAnnotation(QName qName, XMLAttributes xMLAttributes, NamespaceContext namespaceContext) {
        String string;
        Object object;
        if (this.fAnnotationBuffer == null) {
            this.fAnnotationBuffer = new StringBuffer(256);
        }
        this.fAnnotationBuffer.append("<").append(qName.rawname).append(" ");
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < xMLAttributes.getLength()) {
            object = xMLAttributes.getValue(n);
            string = xMLAttributes.getPrefix(n);
            vector.addElement(object);
            this.fAnnotationBuffer.append(xMLAttributes.getQName(n)).append("=\"").append((String)object).append("\" ");
            ++n;
        }
        object = namespaceContext.getAllPrefixes();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            String string2 = namespaceContext.getURI(string);
            if (vector.contains(string2)) continue;
            if (string == XMLSymbols.EMPTY_STRING) {
                this.fAnnotationBuffer.append("xmlns").append("=\"").append(string2).append("\" ");
                continue;
            }
            this.fAnnotationBuffer.append("xmlns:").append(string).append("=\"").append(string2).append("\" ");
        }
        this.fAnnotationBuffer.append(">\n");
    }
}

