/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp;

import com.sun.org.apache.xerces.internal.dom.DOMImplementationImpl;
import com.sun.org.apache.xerces.internal.dom.DOMMessageFormatter;
import com.sun.org.apache.xerces.internal.dom.DocumentImpl;
import com.sun.org.apache.xerces.internal.jaxp.DefaultValidationErrorHandler;
import com.sun.org.apache.xerces.internal.jaxp.JAXPConstants;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import com.sun.org.apache.xerces.internal.parsers.JAXPConfiguration;
import com.sun.org.apache.xerces.internal.util.SecurityManager;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentBuilderImpl
extends DocumentBuilder
implements JAXPConstants {
    private EntityResolver er = null;
    private ErrorHandler eh = null;
    private final DOMParser domParser;
    private boolean enableSP = true;
    private final Schema grammar;
    private final SecurityManager secureProcessing;
    private final boolean xincludeAware;

    public void reset() {
        block2: {
            if (this.domParser == null) break block2;
            try {
                this.domParser.reset();
            }
            catch (XNIException xNIException) {}
        }
    }

    public boolean isNamespaceAware() {
        try {
            return this.domParser.getFeature("http://xml.org/sax/features/namespaces");
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException.getMessage());
        }
    }

    public boolean isValidating() {
        try {
            return this.domParser.getFeature("http://xml.org/sax/features/validation");
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException.getMessage());
        }
    }

    public boolean isXIncludeAware() {
        return this.xincludeAware;
    }

    final DOMParser getDOMParser() {
        return this.domParser;
    }

    private void setDocumentBuilderFactoryAttributes(Hashtable hashtable) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            if (v instanceof Boolean) {
                if ("http://javax.xml.XMLConstants/feature/secure-processing".equals(string)) {
                    this.enableSP = (Boolean)v;
                    continue;
                }
                this.domParser.setFeature(string, (Boolean)v);
                continue;
            }
            if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(string)) {
                if (!"http://www.w3.org/2001/XMLSchema".equals(v) || !this.isValidating()) continue;
                this.domParser.setFeature("http://apache.org/xml/features/validation/schema", true);
                this.domParser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                this.domParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                continue;
            }
            if ("http://java.sun.com/xml/jaxp/properties/schemaSource".equals(string)) {
                if (!this.isValidating()) continue;
                String string2 = (String)hashtable.get("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
                if (string2 != null && "http://www.w3.org/2001/XMLSchema".equals(string2)) {
                    this.domParser.setProperty(string, v);
                    continue;
                }
                throw new IllegalArgumentException(DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "jaxp-order-not-supported", new Object[]{"http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://java.sun.com/xml/jaxp/properties/schemaSource"}));
            }
            this.domParser.setProperty(string, v);
        }
    }

    public Schema getSchema() {
        return this.grammar;
    }

    public DOMImplementation getDOMImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public Document newDocument() {
        return new DocumentImpl();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.er = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.eh = errorHandler == null ? new DefaultHandler() : errorHandler;
    }

    protected DocumentBuilderImpl(DocumentBuilderFactory documentBuilderFactory, Hashtable hashtable) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.grammar = documentBuilderFactory.getSchema();
        this.secureProcessing = new SecurityManager();
        this.domParser = new DOMParser(new JAXPConfiguration(this.grammar));
        this.xincludeAware = documentBuilderFactory.isXIncludeAware();
        this.domParser.setFeature("http://apache.org/xml/features/xinclude-aware", this.xincludeAware);
        if (documentBuilderFactory.isValidating()) {
            this.setErrorHandler(new DefaultValidationErrorHandler());
        }
        this.domParser.setFeature("http://xml.org/sax/features/validation", documentBuilderFactory.isValidating());
        this.domParser.setFeature("http://xml.org/sax/features/namespaces", documentBuilderFactory.isNamespaceAware());
        this.domParser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", !documentBuilderFactory.isIgnoringElementContentWhitespace());
        this.domParser.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", !documentBuilderFactory.isExpandEntityReferences());
        this.domParser.setFeature("http://apache.org/xml/features/include-comments", !documentBuilderFactory.isIgnoringComments());
        this.domParser.setFeature("http://apache.org/xml/features/create-cdata-nodes", !documentBuilderFactory.isCoalescing());
        this.setDocumentBuilderFactoryAttributes(hashtable);
        if (this.enableSP) {
            this.domParser.setProperty("http://apache.org/xml/properties/security-manager", this.secureProcessing);
        }
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        if (inputSource == null) {
            throw new IllegalArgumentException(DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "jaxp-null-input-source", null));
        }
        if (this.er != null) {
            this.domParser.setEntityResolver(this.er);
        }
        if (this.eh != null) {
            this.domParser.setErrorHandler(this.eh);
        }
        this.domParser.parse(inputSource);
        return this.domParser.getDocument();
    }
}

