/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp.validation;

import com.sun.org.apache.xerces.internal.jaxp.validation.ValidatorHandlerImpl;
import java.io.IOException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

class ValidatorImpl
extends Validator {
    private final ValidatorHandlerImpl handler;
    private Transformer identityTransformer1 = null;
    private TransformerHandler identityTransformer2 = null;
    private final ErrorHandler errorForwarder = new ErrorHandler(){

        public void error(SAXParseException sAXParseException) throws SAXException {
            ErrorHandler errorHandler = ValidatorImpl.this.handler.getErrorHandler();
            if (errorHandler == null) {
                throw sAXParseException;
            }
            errorHandler.error(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            ErrorHandler errorHandler = ValidatorImpl.this.handler.getErrorHandler();
            if (errorHandler == null) {
                throw sAXParseException;
            }
            errorHandler.fatalError(sAXParseException);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            ErrorHandler errorHandler = ValidatorImpl.this.handler.getErrorHandler();
            if (errorHandler != null) {
                errorHandler.warning(sAXParseException);
            }
        }
    };
    private final EntityResolver resolutionForwarder = new EntityResolver(){

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            LSResourceResolver lSResourceResolver = ValidatorImpl.this.handler.getResourceResolver();
            if (lSResourceResolver == null) {
                return null;
            }
            LSInput lSInput = lSResourceResolver.resolveResource(null, null, string, string2, null);
            if (lSInput == null) {
                return null;
            }
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(lSInput.getByteStream());
            inputSource.setCharacterStream(lSInput.getCharacterStream());
            inputSource.setEncoding(lSInput.getEncoding());
            inputSource.setPublicId(lSInput.getPublicId());
            inputSource.setSystemId(lSInput.getSystemId());
            return inputSource;
        }
    };

    public void reset() {
        this.handler.reset();
        if (this.identityTransformer1 != null) {
            this.identityTransformer1.reset();
        }
    }

    ValidatorImpl(ValidatorHandlerImpl validatorHandlerImpl) {
        this.handler = validatorHandlerImpl;
    }

    public LSResourceResolver getResourceResolver() {
        return this.handler.getResourceResolver();
    }

    public void setResourceResolver(LSResourceResolver lSResourceResolver) {
        this.handler.setResourceResolver(lSResourceResolver);
    }

    public ErrorHandler getErrorHandler() {
        return this.handler.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.handler.setErrorHandler(errorHandler);
    }

    public void validate(Source source, Result result) throws SAXException, IOException {
        if (source instanceof DOMSource) {
            if (result != null && !(result instanceof DOMResult)) {
                throw new IllegalArgumentException(result.getClass().getName());
            }
            this.process((DOMSource)source, (DOMResult)result);
            return;
        }
        if (source instanceof SAXSource) {
            if (result != null && !(result instanceof SAXResult)) {
                throw new IllegalArgumentException(result.getClass().getName());
            }
            this.process((SAXSource)source, (SAXResult)result);
            return;
        }
        if (source instanceof StreamSource) {
            if (result != null) {
                throw new IllegalArgumentException(result.getClass().getName());
            }
            StreamSource streamSource = (StreamSource)source;
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(streamSource.getInputStream());
            inputSource.setCharacterStream(streamSource.getReader());
            inputSource.setPublicId(streamSource.getPublicId());
            inputSource.setSystemId(streamSource.getSystemId());
            this.process(new SAXSource(inputSource), null);
            return;
        }
        throw new IllegalArgumentException(source.getClass().getName());
    }

    private void process(DOMSource dOMSource, DOMResult dOMResult) throws SAXException {
        if (this.identityTransformer1 == null) {
            try {
                SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                this.identityTransformer1 = sAXTransformerFactory.newTransformer();
                this.identityTransformer2 = sAXTransformerFactory.newTransformerHandler();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new TransformerFactoryConfigurationError(transformerConfigurationException);
            }
        }
        if (dOMResult != null) {
            this.handler.setContentHandler(this.identityTransformer2);
            this.identityTransformer2.setResult(dOMResult);
        }
        try {
            try {
                this.identityTransformer1.transform(dOMSource, new SAXResult(this.handler));
            }
            catch (TransformerException transformerException) {
                if (transformerException.getException() instanceof SAXException) {
                    throw (SAXException)transformerException.getException();
                }
                throw new SAXException(transformerException);
            }
            Object var5_6 = null;
            this.handler.setContentHandler(null);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.handler.setContentHandler(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(SAXSource sAXSource, SAXResult sAXResult) throws IOException, SAXException {
        if (sAXResult != null) {
            this.handler.setContentHandler(sAXResult.getHandler());
        }
        try {
            Object object;
            XMLReader xMLReader = sAXSource.getXMLReader();
            if (xMLReader == null) {
                object = SAXParserFactory.newInstance();
                ((SAXParserFactory)object).setNamespaceAware(true);
                try {
                    xMLReader = ((SAXParserFactory)object).newSAXParser().getXMLReader();
                }
                catch (Exception exception) {
                    throw new FactoryConfigurationError(exception);
                }
            }
            xMLReader.setErrorHandler(this.errorForwarder);
            xMLReader.setEntityResolver(this.resolutionForwarder);
            xMLReader.setContentHandler(this.handler);
            object = sAXSource.getInputSource();
            xMLReader.parse((InputSource)object);
            Object var7_6 = null;
            this.handler.setContentHandler(null);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.handler.setContentHandler(null);
            throw throwable;
        }
    }
}

