/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig.spec;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;

public final class XPathFilterParameterSpec
implements TransformParameterSpec {
    private String xPath;
    private Map nsMap;

    public String getXPath() {
        return this.xPath;
    }

    public XPathFilterParameterSpec(String xPath) {
        if (xPath == null) {
            throw new NullPointerException();
        }
        this.xPath = xPath;
        this.nsMap = Collections.EMPTY_MAP;
    }

    public Map getNamespaceMap() {
        return this.nsMap;
    }

    public XPathFilterParameterSpec(String xPath, Map namespaceMap) {
        if (xPath == null || namespaceMap == null) {
            throw new NullPointerException();
        }
        this.xPath = xPath;
        this.nsMap = new HashMap(namespaceMap);
        Iterator entries = this.nsMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry me = entries.next();
            if (me.getKey() instanceof String && me.getValue() instanceof String) continue;
            throw new ClassCastException("not a String");
        }
        this.nsMap = Collections.unmodifiableMap(this.nsMap);
    }
}

