/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HmacSHA1 {
    static Logger log = Logger.getLogger((class$org$jcp$xml$dsig$internal$HmacSHA1 == null ? (class$org$jcp$xml$dsig$internal$HmacSHA1 = HmacSHA1.class$("org.jcp.xml.dsig.internal.HmacSHA1")) : class$org$jcp$xml$dsig$internal$HmacSHA1).getName());
    private static final int SHA1_BLOCK = 64;
    private byte[] key_opad;
    private boolean initialized = false;
    private Key key;
    private MessageDigest digest;
    private int byte_length;
    static /* synthetic */ Class class$org$jcp$xml$dsig$internal$HmacSHA1;

    public byte[] sign() throws SignatureException {
        if (this.byte_length == 0) {
            throw new SignatureException("length should be -1 or greater than zero, but is " + this.byte_length);
        }
        byte[] value = this.digest.digest();
        this.digest.reset();
        this.digest.update(this.key_opad);
        this.digest.update(value);
        byte[] result = this.digest.digest();
        if (this.byte_length > 0 && result.length > this.byte_length) {
            byte[] truncated = new byte[this.byte_length];
            System.arraycopy(result, 0, truncated, 0, this.byte_length);
            result = truncated;
        }
        return result;
    }

    public void update(byte[] data) {
        this.digest.update(data);
    }

    public boolean verify(byte[] signature) throws SignatureException {
        return MessageDigest.isEqual(signature, this.sign());
    }

    private void initialize(Key key) {
        byte[] rawKey = key.getEncoded();
        byte[] normalizedKey = new byte[64];
        if (rawKey.length > 64) {
            this.digest.reset();
            rawKey = this.digest.digest(rawKey);
        }
        System.arraycopy(rawKey, 0, normalizedKey, 0, rawKey.length);
        int i = rawKey.length;
        while (i < 64) {
            normalizedKey[i] = 0;
            ++i;
        }
        byte[] key_ipad = new byte[64];
        this.key_opad = new byte[64];
        int i2 = 0;
        while (i2 < 64) {
            key_ipad[i2] = (byte)(normalizedKey[i2] ^ 0x36);
            this.key_opad[i2] = (byte)(normalizedKey[i2] ^ 0x5C);
            ++i2;
        }
        this.digest.reset();
        this.digest.update(key_ipad);
    }

    public void init(Key key, int length) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("The key should not be null");
        }
        try {
            this.digest = MessageDigest.getInstance("SHA1");
            this.initialize(key);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InvalidKeyException("SHA1 not supported");
        }
        this.byte_length = length > 0 ? length / 8 : -1;
        log.log(Level.FINE, "byte_length: " + this.byte_length);
        this.initialized = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

