/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.math.BigInteger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class DOMCryptoBinary
extends DOMStructure {
    private final BigInteger bigNum;
    private final String value;

    public BigInteger getBigNum() {
        return this.bigNum;
    }

    public DOMCryptoBinary(BigInteger bigNum) {
        if (bigNum == null) {
            throw new NullPointerException("bigNum is null");
        }
        this.bigNum = bigNum;
        byte[] bigNumAsBytes = bigNum.toByteArray();
        this.value = Base64.encode(bigNum);
    }

    public DOMCryptoBinary(Node cbNode) throws MarshalException {
        this.value = cbNode.getNodeValue();
        try {
            this.bigNum = Base64.decodeBigIntegerFromText((Text)cbNode);
        }
        catch (Exception ex) {
            throw new MarshalException(ex);
        }
    }

    public void marshal(Node parent, String prefix, DOMCryptoContext context) throws MarshalException {
        parent.appendChild(DOMUtils.getOwnerDocument(parent).createTextNode(this.value));
    }
}

