/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.jcp.xml.dsig.internal.dom.DOMSignatureMethod;
import org.w3c.dom.Element;

public final class DOMDSASignatureMethod
extends DOMSignatureMethod {
    static Logger log = Logger.getLogger((class$org$jcp$xml$dsig$internal$dom$DOMDSASignatureMethod == null ? (class$org$jcp$xml$dsig$internal$dom$DOMDSASignatureMethod = DOMDSASignatureMethod.class$("org.jcp.xml.dsig.internal.dom.DOMDSASignatureMethod")) : class$org$jcp$xml$dsig$internal$dom$DOMDSASignatureMethod).getName());
    private Signature signature;
    static /* synthetic */ Class class$org$jcp$xml$dsig$internal$dom$DOMDSASignatureMethod;

    private static byte[] convertASN1toXMLDSIG(byte[] asn1Bytes) throws IOException {
        int sLength;
        int rLength;
        int i = rLength = asn1Bytes[3];
        while (i > 0 && asn1Bytes[4 + rLength - i] == 0) {
            --i;
        }
        int j = sLength = asn1Bytes[5 + rLength];
        while (j > 0 && asn1Bytes[6 + rLength + sLength - j] == 0) {
            --j;
        }
        if (asn1Bytes[0] != 48 || asn1Bytes[1] != asn1Bytes.length - 2 || asn1Bytes[2] != 2 || i > 20 || asn1Bytes[4 + rLength] != 2 || j > 20) {
            throw new IOException("Invalid ASN.1 format of DSA signature");
        }
        byte[] xmldsigBytes = new byte[40];
        System.arraycopy(asn1Bytes, 4 + rLength - i, xmldsigBytes, 20 - i, i);
        System.arraycopy(asn1Bytes, 6 + rLength + sLength - j, xmldsigBytes, 40 - j, j);
        return xmldsigBytes;
    }

    private static byte[] convertXMLDSIGtoASN1(byte[] xmldsigBytes) throws IOException {
        if (xmldsigBytes.length != 40) {
            throw new IOException("Invalid XMLDSIG format of DSA signature");
        }
        int i = 20;
        while (i > 0 && xmldsigBytes[20 - i] == 0) {
            --i;
        }
        int j = i;
        if (xmldsigBytes[20 - i] < 0) {
            ++j;
        }
        int k = 20;
        while (k > 0 && xmldsigBytes[40 - k] == 0) {
            --k;
        }
        int l = k;
        if (xmldsigBytes[40 - k] < 0) {
            ++l;
        }
        byte[] asn1Bytes = new byte[6 + j + l];
        asn1Bytes[0] = 48;
        asn1Bytes[1] = (byte)(4 + j + l);
        asn1Bytes[2] = 2;
        asn1Bytes[3] = (byte)j;
        System.arraycopy(xmldsigBytes, 20 - i, asn1Bytes, 4 + j - i, i);
        asn1Bytes[4 + j] = 2;
        asn1Bytes[5 + j] = (byte)l;
        System.arraycopy(xmldsigBytes, 40 - k, asn1Bytes, 6 + j + l - k, k);
        return asn1Bytes;
    }

    public byte[] sign(Key key, byte[] data) throws InvalidKeyException {
        if (key == null || data == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("key must be PrivateKey");
        }
        if (this.signature == null) {
            try {
                this.signature = Signature.getInstance("SHA1withDSA");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new InvalidKeyException("SHA1withDSA Signature not found");
            }
        }
        log.log(Level.FINE, "Signing data: " + Base64.encode(data));
        log.log(Level.FINE, "Signing with key: " + key);
        this.signature.initSign((PrivateKey)key);
        try {
            this.signature.update(data);
            return DOMDSASignatureMethod.convertASN1toXMLDSIG(this.signature.sign());
        }
        catch (SignatureException se) {
            throw new RuntimeException(se.getMessage());
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex.getMessage());
        }
    }

    public boolean verify(Key key, byte[] data, byte[] sig) throws InvalidKeyException, SignatureException {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        if (sig == null) {
            throw new NullPointerException("signature cannot be null");
        }
        if (this.signature == null) {
            try {
                this.signature = Signature.getInstance("SHA1withDSA");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new SignatureException("SHA1withDSA Signature not found");
            }
        }
        try {
            if (!(key instanceof PublicKey)) {
                throw new InvalidKeyException("key must be PublicKey");
            }
            this.signature.initVerify((PublicKey)key);
            this.signature.update(data);
            log.log(Level.FINE, "verifying data: " + Base64.encode(data));
            log.log(Level.FINE, "verifying with key: " + key);
            return this.signature.verify(DOMDSASignatureMethod.convertXMLDSIGtoASN1(sig));
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex.getMessage());
        }
    }

    public DOMDSASignatureMethod(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        super("http://www.w3.org/2000/09/xmldsig#dsa-sha1", params);
    }

    protected boolean paramsEqual(AlgorithmParameterSpec spec) {
        return this.getParameterSpec() == spec;
    }

    protected void checkParams(SignatureMethodParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("no parameters should be specified for DSA signature algorithm");
        }
    }

    public DOMDSASignatureMethod(Element smElem) throws MarshalException {
        super(smElem);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected void marshalParams(Element parent, String prefix) throws MarshalException {
        throw new MarshalException("no parameters should be specified for DSA signature algorithm");
    }

    protected SignatureMethodParameterSpec unmarshalParams(Element paramsElem) throws MarshalException {
        throw new MarshalException("no parameters should be specified for DSA signature algorithm");
    }
}

