/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.io.IOException;
import java.io.InputStream;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.spec.DigestMethodParameterSpec;
import org.jcp.xml.dsig.internal.dom.DOMSHA1DigestMethod;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DOMDigestMethod
extends DOMStructure
implements DigestMethod {
    private String algorithm;
    private DigestMethodParameterSpec params;

    public abstract byte[] digest(InputStream var1) throws IOException, DigestException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DigestMethod)) {
            return false;
        }
        DigestMethod odm = (DigestMethod)o;
        boolean paramsEqual = this.params == null ? odm.getParameterSpec() == null : this.params.equals(odm.getParameterSpec());
        return this.algorithm.equals(odm.getAlgorithm()) && paramsEqual;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    protected abstract void checkParams(DigestMethodParameterSpec var1) throws InvalidAlgorithmParameterException;

    protected DOMDigestMethod(Element dmElem) throws MarshalException {
        this.algorithm = DOMUtils.getAttributeValue(dmElem, "Algorithm");
        Element paramsElem = DOMUtils.getFirstChildElement(dmElem);
        if (paramsElem != null) {
            this.params = this.unmarshalParams(paramsElem);
        }
        try {
            this.checkParams(this.params);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new MarshalException(iape);
        }
    }

    protected abstract void marshalParams(Element var1, String var2) throws MarshalException;

    protected DOMDigestMethod(String algorithm, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm cannot be null");
        }
        if (params != null && !(params instanceof DigestMethodParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params must be of type DigestMethodParameterSpec");
        }
        this.checkParams((DigestMethodParameterSpec)params);
        this.algorithm = algorithm;
        this.params = (DigestMethodParameterSpec)params;
    }

    static DigestMethod unmarshal(Element dmElem) throws MarshalException {
        String alg = DOMUtils.getAttributeValue(dmElem, "Algorithm");
        if (alg.equals("http://www.w3.org/2000/09/xmldsig#sha1")) {
            return new DOMSHA1DigestMethod(dmElem);
        }
        throw new MarshalException("unsupported digest algorithm: " + alg);
    }

    protected abstract DigestMethodParameterSpec unmarshalParams(Element var1) throws MarshalException;

    public void marshal(Node parent, String prefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element dmElem = DOMUtils.createElement(ownerDoc, "DigestMethod", "http://www.w3.org/2000/09/xmldsig#", prefix);
        DOMUtils.setAttribute(dmElem, "Algorithm", this.algorithm);
        if (this.params != null) {
            this.marshalParams(dmElem, prefix);
        }
        parent.appendChild(dmElem);
    }
}

