/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.spec.HMACParameterSpec;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.jcp.xml.dsig.internal.HmacSHA1;
import org.jcp.xml.dsig.internal.dom.DOMSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class DOMHMACSignatureMethod
extends DOMSignatureMethod {
    static Logger log = Logger.getLogger((class$org$jcp$xml$dsig$internal$dom$DOMHMACSignatureMethod == null ? (class$org$jcp$xml$dsig$internal$dom$DOMHMACSignatureMethod = DOMHMACSignatureMethod.class$("org.jcp.xml.dsig.internal.dom.DOMHMACSignatureMethod")) : class$org$jcp$xml$dsig$internal$dom$DOMHMACSignatureMethod).getName());
    private HmacSHA1 hmac = new HmacSHA1();
    private int outputLength;
    static /* synthetic */ Class class$org$jcp$xml$dsig$internal$dom$DOMHMACSignatureMethod;

    public byte[] sign(Key key, byte[] data) throws InvalidKeyException {
        if (key == null || data == null) {
            throw new NullPointerException();
        }
        this.hmac.init(key, this.outputLength);
        this.hmac.update(data);
        try {
            return this.hmac.sign();
        }
        catch (SignatureException se) {
            throw new RuntimeException(se.getMessage());
        }
    }

    public boolean verify(Key key, byte[] data, byte[] sig) throws InvalidKeyException, SignatureException {
        if (key == null || sig == null) {
            throw new NullPointerException("key or signature data can't be null");
        }
        log.log(Level.FINE, "outputLength = " + this.outputLength);
        this.hmac.init(key, this.outputLength);
        this.hmac.update(data);
        return this.hmac.verify(sig);
    }

    public DOMHMACSignatureMethod(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        super("http://www.w3.org/2000/09/xmldsig#hmac-sha1", params);
    }

    public boolean paramsEqual(AlgorithmParameterSpec spec) {
        if (this.getParameterSpec() == spec) {
            return true;
        }
        if (!(spec instanceof HMACParameterSpec)) {
            return false;
        }
        HMACParameterSpec ospec = (HMACParameterSpec)spec;
        return this.outputLength == ospec.getOutputLength();
    }

    protected void checkParams(SignatureMethodParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null) {
            if (!(params instanceof HMACParameterSpec)) {
                throw new InvalidAlgorithmParameterException("params must be of type HMACParameterSpec");
            }
            this.outputLength = ((HMACParameterSpec)params).getOutputLength();
            log.log(Level.FINE, "Setting outputLength from HMACParameterSpec to: " + this.outputLength);
        } else {
            this.outputLength = -1;
        }
    }

    public DOMHMACSignatureMethod(Element smElem) throws MarshalException {
        super(smElem);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected void marshalParams(Element parent, String prefix) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element hmacElem = DOMUtils.createElement(ownerDoc, "HMACOutputLength", "http://www.w3.org/2000/09/xmldsig#", prefix);
        hmacElem.appendChild(ownerDoc.createTextNode(String.valueOf(this.outputLength)));
        parent.appendChild(hmacElem);
    }

    protected SignatureMethodParameterSpec unmarshalParams(Element paramsElem) throws MarshalException {
        this.outputLength = new Integer(paramsElem.getFirstChild().getNodeValue());
        log.log(Level.FINE, "unmarshalled outputLength: " + this.outputLength);
        return new HMACParameterSpec(this.outputLength);
    }
}

