/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.jcp.xml.dsig.internal.dom.DOMKeyName;
import org.jcp.xml.dsig.internal.dom.DOMKeyValue;
import org.jcp.xml.dsig.internal.dom.DOMRetrievalMethod;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.DOMX509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMKeyInfo
extends DOMStructure
implements KeyInfo {
    private final String id;
    private final List keyInfoTypes;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyInfo)) {
            return false;
        }
        KeyInfo oki = (KeyInfo)o;
        boolean idsEqual = this.id == null ? oki.getId() == null : this.id.equals(oki.getId());
        return this.keyInfoTypes.equals(oki.getContent()) && idsEqual;
    }

    public String getId() {
        return this.id;
    }

    public List getContent() {
        return this.keyInfoTypes;
    }

    public DOMKeyInfo(List content, String id) {
        if (content == null) {
            throw new NullPointerException("content cannot be null");
        }
        ArrayList typesCopy = new ArrayList(content);
        if (typesCopy.isEmpty()) {
            throw new IllegalArgumentException("content cannot be empty");
        }
        int i = 0;
        while (i < typesCopy.size()) {
            if (!(typesCopy.get(i) instanceof XMLStructure)) {
                throw new ClassCastException("content[" + i + "] is not a valid KeyInfo type");
            }
            ++i;
        }
        this.keyInfoTypes = Collections.unmodifiableList(typesCopy);
        this.id = id;
    }

    public void marshal(XMLStructure parent, XMLCryptoContext context) throws MarshalException {
        if (parent == null) {
            throw new NullPointerException("parent is null");
        }
        DOMStructure dp = (DOMStructure)parent;
        this.marshal(((javax.xml.crypto.dom.DOMStructure)parent).getNode(), DOMUtils.getSignaturePrefix(context), (DOMCryptoContext)context);
    }

    public DOMKeyInfo(Element kiElem, XMLCryptoContext context) throws MarshalException {
        this.id = DOMUtils.getAttributeValue(kiElem, "Id");
        NodeList nl = kiElem.getChildNodes();
        if (nl.getLength() < 1) {
            throw new MarshalException("KeyInfo must contain at least one type");
        }
        ArrayList<XMLStructure> content = new ArrayList<XMLStructure>(nl.getLength());
        int i = 0;
        while (i < nl.getLength()) {
            Node child = nl.item(i);
            if (child.getNodeType() == 1) {
                Element childElem = (Element)child;
                if (childElem.getLocalName().equals("KeyName")) {
                    content.add(new DOMKeyName(childElem));
                } else if (childElem.getLocalName().equals("KeyValue")) {
                    content.add(new DOMKeyValue(childElem));
                } else if (childElem.getLocalName().equals("RetrievalMethod")) {
                    content.add(new DOMRetrievalMethod(childElem, context));
                } else if (childElem.getLocalName().equals("X509Data")) {
                    content.add(new DOMX509Data(childElem));
                } else {
                    content.add(new javax.xml.crypto.dom.DOMStructure(childElem));
                }
            }
            ++i;
        }
        this.keyInfoTypes = Collections.unmodifiableList(content);
    }

    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        this.marshal(parent, null, dsPrefix, context);
    }

    public void marshal(Node parent, Node nextSibling, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element kiElem = DOMUtils.createElement(ownerDoc, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        Iterator i = this.keyInfoTypes.iterator();
        while (i.hasNext()) {
            XMLStructure kiType = (XMLStructure)i.next();
            if (kiType instanceof DOMStructure) {
                ((DOMStructure)kiType).marshal(kiElem, dsPrefix, context);
                continue;
            }
            DOMUtils.appendChild(kiElem, ((javax.xml.crypto.dom.DOMStructure)kiType).getNode());
        }
        DOMUtils.setAttributeID(kiElem, "Id", this.id);
        parent.insertBefore(kiElem, nextSibling);
    }
}

