/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import org.jcp.xml.dsig.internal.dom.DOMReference;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMManifest
extends DOMStructure
implements Manifest {
    private final List references;
    private final String id;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Manifest)) {
            return false;
        }
        Manifest oman = (Manifest)o;
        boolean idsEqual = this.id == null ? oman.getId() == null : this.id.equals(oman.getId());
        return idsEqual && this.references.equals(oman.getReferences());
    }

    public String getId() {
        return this.id;
    }

    public List getReferences() {
        return this.references;
    }

    public DOMManifest(List references, String id) {
        if (references == null) {
            throw new NullPointerException("references cannot be null");
        }
        ArrayList refCopy = new ArrayList(references);
        if (refCopy.isEmpty()) {
            throw new IllegalArgumentException("list of references must contain at least one entry");
        }
        int i = 0;
        while (i < refCopy.size()) {
            if (!(refCopy.get(i) instanceof Reference)) {
                throw new ClassCastException("references[" + i + "] is not a valid type");
            }
            ++i;
        }
        this.references = Collections.unmodifiableList(refCopy);
        this.id = id;
    }

    public DOMManifest(Element manElem, XMLCryptoContext context) throws MarshalException {
        this.id = DOMUtils.getAttributeValue(manElem, "Id");
        Element refElem = DOMUtils.getFirstChildElement(manElem);
        ArrayList<DOMReference> refs = new ArrayList<DOMReference>();
        while (refElem != null) {
            refs.add(new DOMReference(refElem, context));
            refElem = DOMUtils.getNextSiblingElement(refElem);
        }
        this.references = Collections.unmodifiableList(refs);
    }

    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element manElem = DOMUtils.createElement(ownerDoc, "Manifest", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        DOMUtils.setAttributeID(manElem, "Id", this.id);
        Iterator i = this.references.iterator();
        while (i.hasNext()) {
            DOMReference ref = (DOMReference)i.next();
            ref.marshal(manElem, dsPrefix, context);
        }
        parent.appendChild(manElem);
    }
}

