/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.jcp.xml.dsig.internal.dom.DOMSignatureMethod;
import org.w3c.dom.Element;

public final class DOMRSASignatureMethod
extends DOMSignatureMethod {
    static Logger log = Logger.getLogger((class$org$jcp$xml$dsig$internal$dom$DOMRSASignatureMethod == null ? (class$org$jcp$xml$dsig$internal$dom$DOMRSASignatureMethod = DOMRSASignatureMethod.class$("org.jcp.xml.dsig.internal.dom.DOMRSASignatureMethod")) : class$org$jcp$xml$dsig$internal$dom$DOMRSASignatureMethod).getName());
    private Signature signature;
    static /* synthetic */ Class class$org$jcp$xml$dsig$internal$dom$DOMRSASignatureMethod;

    public byte[] sign(Key key, byte[] data) throws InvalidKeyException {
        if (key == null || data == null) {
            throw new NullPointerException();
        }
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("key must be PrivateKey");
        }
        log.log(Level.FINE, "Signing data: " + Base64.encode(data));
        log.log(Level.FINE, "Signing with key: " + key);
        if (this.signature == null) {
            try {
                this.signature = Signature.getInstance("SHA1withRSA");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new InvalidKeyException("SHA1withRSA Signature not found");
            }
        }
        this.signature.initSign((PrivateKey)key);
        try {
            this.signature.update(data);
            return this.signature.sign();
        }
        catch (SignatureException se) {
            throw new RuntimeException(se.getMessage());
        }
    }

    public boolean verify(Key key, byte[] data, byte[] sig) throws InvalidKeyException, SignatureException {
        if (key == null || sig == null) {
            throw new NullPointerException("key or signature cannot be null");
        }
        if (!(key instanceof PublicKey)) {
            throw new InvalidKeyException("key must be PublicKey");
        }
        if (this.signature == null) {
            try {
                this.signature = Signature.getInstance("SHA1withRSA");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new SignatureException("SHA1withRSA Signature not found");
            }
        }
        this.signature.initVerify((PublicKey)key);
        this.signature.update(data);
        log.log(Level.FINE, "verifying data: " + Base64.encode(data));
        log.log(Level.FINE, "verifying with key: " + key);
        return this.signature.verify(sig);
    }

    public DOMRSASignatureMethod(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        super("http://www.w3.org/2000/09/xmldsig#rsa-sha1", params);
    }

    protected boolean paramsEqual(AlgorithmParameterSpec spec) {
        return this.getParameterSpec() == spec;
    }

    protected void checkParams(SignatureMethodParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("no parameters should be specified for RSA signature algorithm");
        }
    }

    public DOMRSASignatureMethod(Element smElem) throws MarshalException {
        super(smElem);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected void marshalParams(Element parent, String dsPrefix) throws MarshalException {
        throw new MarshalException("no parameters should be specified for RSA signature algorithm");
    }

    protected SignatureMethodParameterSpec unmarshalParams(Element paramsElem) throws MarshalException {
        throw new MarshalException("no parameters should be specified for RSA signature algorithm");
    }
}

