/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import org.jcp.xml.dsig.internal.dom.ApacheData;
import org.jcp.xml.dsig.internal.dom.DOMDigestMethod;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMTransform;
import org.jcp.xml.dsig.internal.dom.DOMURIDereferencer;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMReference
extends DOMStructure
implements Reference,
DOMURIReference {
    static Logger log = Logger.getLogger((class$org$jcp$xml$dsig$internal$dom$DOMReference == null ? (class$org$jcp$xml$dsig$internal$dom$DOMReference = DOMReference.class$("org.jcp.xml.dsig.internal.dom.DOMReference")) : class$org$jcp$xml$dsig$internal$dom$DOMReference).getName());
    private final DigestMethod digestMethod;
    private final String id;
    private final List appliedTransforms;
    private final List transforms;
    private final List allTransforms;
    private final Data appliedTransformData;
    private Attr here;
    private final String uri;
    private final String type;
    private byte[] digestValue;
    private byte[] calcDigestValue;
    private Element refElem;
    private boolean digested = false;
    private boolean validated = false;
    private boolean validationStatus;
    private Data derefData;
    private InputStream dis;
    static /* synthetic */ Class class$org$jcp$xml$dsig$internal$dom$DOMReference;

    boolean isDigested() {
        return this.digested;
    }

    public byte[] getCalculatedDigestValue() {
        return this.calcDigestValue == null ? null : (byte[])this.calcDigestValue.clone();
    }

    public byte[] getDigestValue() {
        return this.digestValue == null ? null : (byte[])this.digestValue.clone();
    }

    public InputStream getDigestInputStream() {
        return this.dis;
    }

    public boolean equals(Object o) {
        boolean urisEqual;
        boolean idsEqual;
        if (this == o) {
            return true;
        }
        if (!(o instanceof Reference)) {
            return false;
        }
        Reference oref = (Reference)o;
        boolean bl = this.id == null ? oref.getId() == null : (idsEqual = this.id.equals(oref.getId()));
        boolean bl2 = this.uri == null ? oref.getURI() == null : (urisEqual = this.uri.equals(oref.getURI()));
        boolean typesEqual = this.type == null ? oref.getType() == null : this.type.equals(oref.getType());
        boolean digestValuesEqual = Arrays.equals(this.digestValue, oref.getDigestValue());
        return this.digestMethod.equals(oref.getDigestMethod()) && idsEqual && urisEqual && typesEqual && this.transforms.equals(oref.getTransforms());
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getURI() {
        return this.uri;
    }

    public List getTransforms() {
        return this.allTransforms;
    }

    public Data getDereferencedData() {
        return this.derefData;
    }

    public DigestMethod getDigestMethod() {
        return this.digestMethod;
    }

    public void digest(XMLSignContext signContext) throws XMLSignatureException {
        Data data = null;
        data = this.appliedTransformData == null ? this.dereference(signContext) : this.appliedTransformData;
        byte[] digestInput = this.transform(data, signContext);
        this.digestValue = digestInput;
        String encodedDV = Base64.encode(this.digestValue);
        log.log(Level.FINE, "Reference object uri = " + this.uri);
        Element digestElem = DOMUtils.getLastChildElement(this.refElem);
        if (digestElem == null) {
            throw new XMLSignatureException("DigestValue element expected");
        }
        DOMUtils.removeAllChildren(digestElem);
        digestElem.appendChild(this.refElem.getOwnerDocument().createTextNode(encodedDV));
        Boolean cache = (Boolean)signContext.getProperty("javax.xml.dsig.cacheReference");
        if (cache != null && cache.booleanValue()) {
            this.dis = new ByteArrayInputStream(digestInput);
            this.derefData = data;
        }
        this.digested = true;
        log.log(Level.FINE, "Reference digesting completed");
    }

    public boolean validate(XMLValidateContext validateContext) throws XMLSignatureException {
        if (validateContext == null) {
            throw new NullPointerException("validateContext cannot be null");
        }
        if (this.validated) {
            return this.validationStatus;
        }
        Data data = this.dereference(validateContext);
        byte[] digestInput = this.transform(data, validateContext);
        this.calcDigestValue = digestInput;
        log.log(Level.FINE, "Expected digest: " + Base64.encode(this.digestValue));
        log.log(Level.FINE, "Actual digest: " + Base64.encode(this.calcDigestValue));
        this.validationStatus = Arrays.equals(this.digestValue, this.calcDigestValue);
        Boolean cache = (Boolean)validateContext.getProperty("javax.xml.dsig.cacheReference");
        if (cache != null && cache.booleanValue()) {
            this.dis = new ByteArrayInputStream(digestInput);
            this.derefData = data;
        }
        this.validated = true;
        return this.validationStatus;
    }

    public Node getHere() {
        return this.here;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private Data dereference(XMLCryptoContext context) throws XMLSignatureException {
        Data data = null;
        URIDereferencer deref = context.getURIDereferencer();
        if (deref == null) {
            deref = DOMURIDereferencer.INSTANCE;
        }
        try {
            data = deref.dereference(this, context);
        }
        catch (URIReferenceException ure) {
            throw new XMLSignatureException(ure);
        }
        return data;
    }

    private byte[] transform(Data dereferencedData, XMLCryptoContext context) throws XMLSignatureException {
        MessageDigest md;
        Data data = dereferencedData;
        BufferedOutputStream os = new BufferedOutputStream(new ByteArrayOutputStream());
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new XMLSignatureException(nsae);
        }
        DigestOutputStream dos = new DigestOutputStream(os, md);
        Iterator i = this.transforms.iterator();
        while (i.hasNext()) {
            DOMTransform transform = (DOMTransform)i.next();
            try {
                if (i.hasNext()) {
                    data = transform.transform(data, context);
                    continue;
                }
                data = transform.transform(data, context, dos);
            }
            catch (TransformException te) {
                throw new XMLSignatureException(te);
            }
        }
        try {
            if (data != null) {
                XMLSignatureInput xi;
                if (data instanceof ApacheData) {
                    xi = ((ApacheData)data).getXMLSignatureInput();
                } else if (data instanceof OctetStreamData) {
                    xi = new XMLSignatureInput(((OctetStreamData)data).getOctetStream());
                } else if (data instanceof NodeSetData) {
                    TransformService spi = TransformService.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "DOM");
                    data = spi.transform(data, context);
                    xi = new XMLSignatureInput(((OctetStreamData)data).getOctetStream());
                } else {
                    throw new XMLSignatureException("unrecognized Data type");
                }
                xi.updateOutputStream(dos);
            }
            dos.close();
            return md.digest();
        }
        catch (Exception e) {
            throw new XMLSignatureException(e);
        }
    }

    public DOMReference(Element refElem, XMLCryptoContext context) throws MarshalException {
        Element nextSibling = DOMUtils.getFirstChildElement(refElem);
        ArrayList<DOMTransform> transforms = new ArrayList<DOMTransform>();
        if (nextSibling.getLocalName().equals("Transforms")) {
            Element transformElem = DOMUtils.getFirstChildElement(nextSibling);
            while (transformElem != null) {
                transforms.add(new DOMTransform(transformElem, context));
                transformElem = DOMUtils.getNextSiblingElement(transformElem);
            }
            nextSibling = DOMUtils.getNextSiblingElement(nextSibling);
        }
        Element dmElem = nextSibling;
        this.digestMethod = DOMDigestMethod.unmarshal(dmElem);
        try {
            Element dvElem = DOMUtils.getNextSiblingElement(dmElem);
            this.digestValue = Base64.decode(dvElem);
        }
        catch (Base64DecodingException bde) {
            throw new MarshalException(bde);
        }
        this.uri = DOMUtils.getAttributeValue(refElem, "URI");
        this.id = DOMUtils.getAttributeValue(refElem, "Id");
        this.type = DOMUtils.getAttributeValue(refElem, "Type");
        this.here = refElem.getAttributeNodeNS(null, "URI");
        this.refElem = refElem;
        this.transforms = transforms.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableList(transforms);
        this.appliedTransforms = Collections.EMPTY_LIST;
        this.allTransforms = transforms;
        this.appliedTransformData = null;
    }

    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        log.log(Level.FINE, "Marshalling Reference");
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        this.refElem = DOMUtils.createElement(ownerDoc, "Reference", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        DOMUtils.setAttributeID(this.refElem, "Id", this.id);
        DOMUtils.setAttribute(this.refElem, "URI", this.uri);
        DOMUtils.setAttribute(this.refElem, "Type", this.type);
        if (!this.transforms.isEmpty() || !this.appliedTransforms.isEmpty()) {
            DOMStructure transform;
            Element transformsElem = DOMUtils.createElement(ownerDoc, "Transforms", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
            this.refElem.appendChild(transformsElem);
            Iterator i = this.appliedTransforms.iterator();
            while (i.hasNext()) {
                transform = (DOMStructure)i.next();
                transform.marshal(transformsElem, dsPrefix, context);
            }
            i = this.transforms.iterator();
            while (i.hasNext()) {
                transform = (DOMStructure)i.next();
                transform.marshal(transformsElem, dsPrefix, context);
            }
        }
        ((DOMDigestMethod)this.digestMethod).marshal(this.refElem, dsPrefix, context);
        log.log(Level.FINE, "Adding digestValueElem");
        Element digestValueElem = DOMUtils.createElement(ownerDoc, "DigestValue", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        if (this.digestValue != null) {
            digestValueElem.appendChild(ownerDoc.createTextNode(Base64.encode(this.digestValue)));
        }
        this.refElem.appendChild(digestValueElem);
        parent.appendChild(this.refElem);
        this.here = this.refElem.getAttributeNodeNS(null, "URI");
    }

    public DOMReference(String uri, String type, DigestMethod dm, List transforms, String id) {
        this(uri, type, dm, null, null, transforms, id, null);
    }

    public DOMReference(String uri, String type, DigestMethod dm, List appliedTransforms, Data result, List transforms, String id) {
        this(uri, type, dm, appliedTransforms, result, transforms, id, null);
    }

    public DOMReference(String uri, String type, DigestMethod dm, List appliedTransforms, Data result, List transforms, String id, byte[] digestValue) {
        int i;
        ArrayList transformsCopy;
        if (dm == null) {
            throw new NullPointerException("DigestMethod must be non-null");
        }
        if (appliedTransforms == null || appliedTransforms.isEmpty()) {
            this.appliedTransforms = Collections.EMPTY_LIST;
        } else {
            transformsCopy = new ArrayList(appliedTransforms);
            i = 0;
            while (i < transformsCopy.size()) {
                if (!(transformsCopy.get(i) instanceof Transform)) {
                    throw new ClassCastException("appliedTransforms[" + i + "] is not a valid type");
                }
                ++i;
            }
            this.appliedTransforms = Collections.unmodifiableList(transformsCopy);
        }
        if (transforms == null || transforms.isEmpty()) {
            this.transforms = Collections.EMPTY_LIST;
        } else {
            transformsCopy = new ArrayList(transforms);
            i = 0;
            while (i < transformsCopy.size()) {
                if (!(transformsCopy.get(i) instanceof Transform)) {
                    throw new ClassCastException("transforms[" + i + "] is not a valid type");
                }
                ++i;
            }
            this.transforms = Collections.unmodifiableList(transformsCopy);
        }
        ArrayList all = new ArrayList(this.appliedTransforms);
        all.addAll(this.transforms);
        this.allTransforms = Collections.unmodifiableList(all);
        this.digestMethod = dm;
        this.uri = uri;
        if (uri != null && !uri.equals("")) {
            try {
                new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        this.type = type;
        this.id = id;
        if (digestValue != null) {
            this.digestValue = (byte[])digestValue.clone();
            this.digested = true;
        }
        this.appliedTransformData = result;
    }
}

