/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import org.jcp.xml.dsig.internal.dom.DOMSignatureProperty;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMSignatureProperties
extends DOMStructure
implements SignatureProperties {
    private final String id;
    private final List properties;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignatureProperties)) {
            return false;
        }
        SignatureProperties osp = (SignatureProperties)o;
        boolean idsEqual = this.id == null ? osp.getId() == null : this.id.equals(osp.getId());
        return this.properties.equals(osp.getProperties()) && idsEqual;
    }

    public String getId() {
        return this.id;
    }

    public List getProperties() {
        return this.properties;
    }

    public DOMSignatureProperties(Element propsElem) throws MarshalException {
        this.id = DOMUtils.getAttributeValue(propsElem, "Id");
        NodeList nodes = propsElem.getChildNodes();
        ArrayList<DOMSignatureProperty> properties = new ArrayList<DOMSignatureProperty>(nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            Node child = nodes.item(i);
            if (child.getNodeType() == 1) {
                properties.add(new DOMSignatureProperty((Element)child));
            }
            ++i;
        }
        if (properties.isEmpty()) {
            throw new MarshalException("properties cannot be empty");
        }
        this.properties = Collections.unmodifiableList(properties);
    }

    public DOMSignatureProperties(List properties, String id) {
        if (properties == null) {
            throw new NullPointerException("properties cannot be null");
        }
        if (properties.isEmpty()) {
            throw new IllegalArgumentException("properties cannot be empty");
        }
        ArrayList propsCopy = new ArrayList(properties);
        int i = 0;
        while (i < propsCopy.size()) {
            if (!(propsCopy.get(i) instanceof SignatureProperty)) {
                throw new ClassCastException("properties[" + i + "] is not a valid type");
            }
            ++i;
        }
        this.properties = Collections.unmodifiableList(propsCopy);
        this.id = id;
    }

    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element propsElem = DOMUtils.createElement(ownerDoc, "SignatureProperties", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        DOMUtils.setAttributeID(propsElem, "Id", this.id);
        Iterator i = this.properties.iterator();
        while (i.hasNext()) {
            DOMSignatureProperty property = (DOMSignatureProperty)i.next();
            property.marshal(propsElem, dsPrefix, context);
        }
        parent.appendChild(propsElem);
    }
}

