/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.jcp.xml.dsig.internal.dom.DOMCanonicalizationMethod;
import org.jcp.xml.dsig.internal.dom.DOMReference;
import org.jcp.xml.dsig.internal.dom.DOMSignatureMethod;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.SubDocumentData;
import org.jcp.xml.dsig.internal.dom.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMSignedInfo
extends DOMStructure
implements SignedInfo {
    static Logger log = Logger.getLogger((class$org$jcp$xml$dsig$internal$dom$DOMSignedInfo == null ? (class$org$jcp$xml$dsig$internal$dom$DOMSignedInfo = DOMSignedInfo.class$("org.jcp.xml.dsig.internal.dom.DOMSignedInfo")) : class$org$jcp$xml$dsig$internal$dom$DOMSignedInfo).getName());
    private List references;
    private CanonicalizationMethod canonicalizationMethod;
    private SignatureMethod signatureMethod;
    private String id;
    private Document ownerDoc;
    private Element localSiElem;
    private InputStream canonData;
    private XMLSignature signature;
    static /* synthetic */ Class class$org$jcp$xml$dsig$internal$dom$DOMSignedInfo;

    public InputStream getCanonicalizedData() {
        return this.canonData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignedInfo)) {
            return false;
        }
        SignedInfo osi = (SignedInfo)o;
        boolean idEqual = this.id == null ? osi.getId() == null : this.id.equals(osi.getId());
        return this.canonicalizationMethod.equals(osi.getCanonicalizationMethod()) && this.signatureMethod.equals(osi.getSignatureMethod()) && this.references.equals(osi.getReferences()) && idEqual;
    }

    public String getId() {
        return this.id;
    }

    public List getReferences() {
        return this.references;
    }

    public byte[] canonicalize(XMLCryptoContext context) throws XMLSignatureException {
        byte[] signedInfoBytes;
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        XMLUtils.circumventBug2650(this.ownerDoc);
        SubDocumentData sdd = new SubDocumentData(this.localSiElem, true, null);
        OctetStreamData data = null;
        try {
            data = (OctetStreamData)((DOMCanonicalizationMethod)this.canonicalizationMethod).canonicalize(sdd, context);
        }
        catch (TransformException te) {
            throw new XMLSignatureException(te);
        }
        try {
            signedInfoBytes = Utils.readBytesFromStream(data.getOctetStream());
        }
        catch (IOException ioe) {
            throw new XMLSignatureException(ioe);
        }
        if (log.isLoggable(Level.FINE)) {
            InputStreamReader isr = new InputStreamReader(new ByteArrayInputStream(signedInfoBytes));
            char[] siBytes = new char[signedInfoBytes.length];
            try {
                isr.read(siBytes);
            }
            catch (IOException ioex) {
                // empty catch block
            }
            log.log(Level.FINE, "Canonicalized SignedInfo:\n" + new String(siBytes));
        }
        this.canonData = new ByteArrayInputStream(signedInfoBytes);
        return signedInfoBytes;
    }

    public CanonicalizationMethod getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public SignatureMethod getSignatureMethod() {
        return this.signatureMethod;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public DOMSignedInfo(CanonicalizationMethod cm, SignatureMethod sm, List references) {
        if (cm == null || sm == null || references == null) {
            throw new NullPointerException();
        }
        this.canonicalizationMethod = cm;
        this.signatureMethod = sm;
        this.references = Collections.unmodifiableList(new ArrayList(references));
        if (this.references.isEmpty()) {
            throw new IllegalArgumentException("list of references must contain at least one entry");
        }
        Iterator i = this.references.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof Reference) continue;
            throw new ClassCastException("list of references contains an illegal type");
        }
    }

    public DOMSignedInfo(Element siElem, XMLSignature signature, XMLCryptoContext context) throws MarshalException {
        this.localSiElem = siElem;
        this.signature = signature;
        this.ownerDoc = siElem.getOwnerDocument();
        this.id = DOMUtils.getAttributeValue(siElem, "Id");
        Element cmElem = DOMUtils.getFirstChildElement(siElem);
        this.canonicalizationMethod = new DOMCanonicalizationMethod(cmElem, context);
        Element smElem = DOMUtils.getNextSiblingElement(cmElem);
        this.signatureMethod = DOMSignatureMethod.unmarshal(smElem);
        ArrayList<DOMReference> refList = new ArrayList<DOMReference>();
        Element refElem = DOMUtils.getNextSiblingElement(smElem);
        while (refElem != null) {
            refList.add(new DOMReference(refElem, context));
            refElem = DOMUtils.getNextSiblingElement(refElem);
        }
        this.references = Collections.unmodifiableList(refList);
    }

    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        this.marshal(parent, dsPrefix, context, null);
    }

    public DOMSignedInfo(CanonicalizationMethod cm, SignatureMethod sm, List references, String id) {
        this(cm, sm, references);
        this.id = id;
    }

    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context, XMLSignature signature) throws MarshalException {
        this.signature = signature;
        this.ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element siElem = DOMUtils.createElement(this.ownerDoc, "SignedInfo", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        DOMCanonicalizationMethod dcm = (DOMCanonicalizationMethod)this.canonicalizationMethod;
        dcm.marshal(siElem, dsPrefix, context);
        ((DOMSignatureMethod)this.signatureMethod).marshal(siElem, dsPrefix, context);
        Iterator i = this.references.iterator();
        while (i.hasNext()) {
            DOMReference reference = (DOMReference)i.next();
            reference.marshal(siElem, dsPrefix, context);
        }
        DOMUtils.setAttributeID(siElem, "Id", this.id);
        parent.appendChild(siElem);
        this.localSiElem = siElem;
    }
}

