/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import com.sun.org.apache.xml.internal.security.Init;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.IdResolver;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import javax.xml.crypto.Data;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.crypto.dsig.XMLSignContext;
import org.jcp.xml.dsig.internal.dom.ApacheNodeSetData;
import org.jcp.xml.dsig.internal.dom.ApacheOctetStreamData;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class DOMURIDereferencer
implements URIDereferencer {
    static final URIDereferencer INSTANCE = new DOMURIDereferencer();

    private DOMURIDereferencer() {
        Init.init();
    }

    public Data dereference(URIReference uriRef, XMLCryptoContext context) throws URIReferenceException {
        if (uriRef == null) {
            throw new NullPointerException("uriRef cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        DOMURIReference domRef = (DOMURIReference)uriRef;
        Attr uriAttr = (Attr)domRef.getHere();
        String uri = uriRef.getURI();
        DOMCryptoContext dcc = (DOMCryptoContext)context;
        if (uri != null && uri.startsWith("#")) {
            Element referencedElem;
            String id = uri.substring(1);
            if (id.startsWith("xpointer(id(")) {
                int i1 = id.indexOf(39);
                int i2 = id.indexOf(39, i1 + 1);
                id = id.substring(i1 + 1, i2);
            }
            if (context instanceof XMLSignContext && (referencedElem = dcc.getElementById(id)) != null) {
                IdResolver.registerElementById((Element)referencedElem, (String)id);
            }
        }
        try {
            ResourceResolver apacheResolver = ResourceResolver.getInstance((Attr)uriAttr, (String)context.getBaseURI());
            XMLSignatureInput in = apacheResolver.resolve(uriAttr, context.getBaseURI());
            if (in.isOctetStream()) {
                return new ApacheOctetStreamData(in);
            }
            return new ApacheNodeSetData(in);
        }
        catch (Exception e) {
            throw new URIReferenceException(e);
        }
    }
}

