/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.XMLObject;
import org.jcp.xml.dsig.internal.dom.DOMManifest;
import org.jcp.xml.dsig.internal.dom.DOMSignatureProperties;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.DOMX509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMXMLObject
extends DOMStructure
implements XMLObject {
    private final String id;
    private final String mimeType;
    private final String encoding;
    private final List content;

    public boolean equals(Object o) {
        boolean encodingsEqual;
        boolean idsEqual;
        if (this == o) {
            return true;
        }
        if (!(o instanceof XMLObject)) {
            return false;
        }
        XMLObject oxo = (XMLObject)o;
        boolean bl = this.id == null ? oxo.getId() == null : (idsEqual = this.id.equals(oxo.getId()));
        boolean bl2 = this.encoding == null ? oxo.getEncoding() == null : (encodingsEqual = this.encoding.equals(oxo.getEncoding()));
        boolean mimeTypesEqual = this.mimeType == null ? oxo.getMimeType() == null : this.mimeType.equals(oxo.getMimeType());
        return idsEqual && encodingsEqual && mimeTypesEqual && this.equalsContent(oxo.getContent());
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getId() {
        return this.id;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public List getContent() {
        return this.content;
    }

    private boolean equalsContent(List otherContent) {
        if (this.content.size() != otherContent.size()) {
            return false;
        }
        int i = 0;
        while (i < otherContent.size()) {
            XMLStructure oxs = (XMLStructure)otherContent.get(i);
            XMLStructure xs = (XMLStructure)this.content.get(i);
            if (oxs instanceof javax.xml.crypto.dom.DOMStructure) {
                if (!(xs instanceof javax.xml.crypto.dom.DOMStructure)) {
                    return false;
                }
                Node onode = ((javax.xml.crypto.dom.DOMStructure)oxs).getNode();
                Node node = ((javax.xml.crypto.dom.DOMStructure)xs).getNode();
                if (!DOMUtils.nodesEqual(node, onode)) {
                    return false;
                }
            } else if (!xs.equals(oxs)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public DOMXMLObject(Element objElem, XMLCryptoContext context) throws MarshalException {
        super();
        this.encoding = DOMUtils.getAttributeValue(objElem, "Encoding");
        this.id = DOMUtils.getAttributeValue(objElem, "Id");
        this.mimeType = DOMUtils.getAttributeValue(objElem, "MimeType");
        nodes = objElem.getChildNodes();
        content = new ArrayList<XMLStructure>(nodes.getLength());
        i = 0;
        while (i < nodes.getLength()) {
            child = nodes.item(i);
            if (child.getNodeType() != 1) ** GOTO lbl-1000
            tag = ((Element)child).getLocalName();
            if (tag.equals("Manifest")) {
                content.add(new DOMManifest((Element)child, context));
            } else if (tag.equals("SignatureProperties")) {
                content.add(new DOMSignatureProperties((Element)child));
            } else if (tag.equals("X509Data")) {
                content.add(new DOMX509Data((Element)child));
            } else lbl-1000:
            // 2 sources

            {
                content.add(new javax.xml.crypto.dom.DOMStructure(nodes.item(i)));
            }
            ++i;
        }
        this.content = content.isEmpty() != false ? Collections.EMPTY_LIST : Collections.unmodifiableList(content);
    }

    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element objElem = DOMUtils.createElement(ownerDoc, "Object", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        DOMUtils.setAttributeID(objElem, "Id", this.id);
        DOMUtils.setAttribute(objElem, "MimeType", this.mimeType);
        DOMUtils.setAttribute(objElem, "Encoding", this.encoding);
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            XMLStructure object = (XMLStructure)i.next();
            if (object instanceof DOMStructure) {
                ((DOMStructure)object).marshal(objElem, dsPrefix, context);
                continue;
            }
            javax.xml.crypto.dom.DOMStructure domObject = (javax.xml.crypto.dom.DOMStructure)object;
            DOMUtils.appendChild(objElem, domObject.getNode());
        }
        parent.appendChild(objElem);
    }

    public DOMXMLObject(List content, String id, String mimeType, String encoding) {
        if (content == null || content.isEmpty()) {
            this.content = Collections.EMPTY_LIST;
        } else {
            ArrayList contentCopy = new ArrayList(content);
            int i = 0;
            while (i < contentCopy.size()) {
                if (!(contentCopy.get(i) instanceof XMLStructure)) {
                    throw new ClassCastException("content[" + i + "] is not a valid type");
                }
                ++i;
            }
            this.content = Collections.unmodifiableList(contentCopy);
        }
        this.id = id;
        this.mimeType = mimeType;
        this.encoding = encoding;
    }
}

