/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.xml.crypto.NodeSetData;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class SubDocumentData
implements NodeSetData {
    public static final int SHOW_ALL_EXCEPT_COMMENTS = 3967;
    private boolean withComments;
    private NodeIterator ni;

    public boolean withComments() {
        return this.withComments;
    }

    public Iterator iterator() {
        return new Iterator(){

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                if (SubDocumentData.this.ni.nextNode() == null) {
                    return false;
                }
                SubDocumentData.this.ni.previousNode();
                return true;
            }

            public Object next() {
                Node node = SubDocumentData.this.ni.nextNode();
                if (node == null) {
                    throw new NoSuchElementException();
                }
                return node;
            }
        };
    }

    public NodeIterator nodeIterator() {
        return this.ni;
    }

    public SubDocumentData(Node root, boolean withComments, NodeFilter twFilter) {
        this.ni = new DelayedNodeIterator(root, withComments);
        this.withComments = withComments;
    }

    static class DelayedNodeIterator
    implements NodeIterator {
        private Node root;
        private List nodeSet;
        private ListIterator li;
        private boolean detached = false;
        private boolean withComments;

        public int getWhatToShow() {
            if (this.withComments) {
                return -1;
            }
            return 3967;
        }

        public void detach() {
            this.detached = true;
        }

        public boolean getExpandEntityReferences() {
            return true;
        }

        public Node getRoot() {
            return this.root;
        }

        public Node nextNode() throws DOMException {
            if (this.detached) {
                throw new DOMException(11, "");
            }
            if (this.nodeSet == null) {
                this.nodeSet = this.dereferenceSameDocumentURI(this.root);
                this.li = this.nodeSet.listIterator();
            }
            if (this.li.hasNext()) {
                return (Node)this.li.next();
            }
            return null;
        }

        public Node previousNode() throws DOMException {
            if (this.detached) {
                throw new DOMException(11, "");
            }
            if (this.nodeSet == null) {
                this.nodeSet = this.dereferenceSameDocumentURI(this.root);
                this.li = this.nodeSet.listIterator();
            }
            if (this.li.hasPrevious()) {
                return (Node)this.li.previous();
            }
            return null;
        }

        DelayedNodeIterator(Node root, boolean withComments) {
            this.root = root;
            this.withComments = withComments;
        }

        public NodeFilter getFilter() {
            return null;
        }

        private List dereferenceSameDocumentURI(Node node) {
            ArrayList nodeSet = new ArrayList();
            if (node != null) {
                this.nodeSetMinusCommentNodes(node, nodeSet, null);
            }
            return nodeSet;
        }

        private void nodeSetMinusCommentNodes(Node node, List nodeSet, Node prevSibling) {
            switch (node.getNodeType()) {
                case 1: {
                    NamedNodeMap attrs = node.getAttributes();
                    if (attrs != null) {
                        int i = 0;
                        while (i < attrs.getLength()) {
                            nodeSet.add(attrs.item(i));
                            ++i;
                        }
                    }
                    nodeSet.add(node);
                    Node pSibling = null;
                    Node child = node.getFirstChild();
                    while (child != null) {
                        this.nodeSetMinusCommentNodes(child, nodeSet, pSibling);
                        pSibling = child;
                        child = child.getNextSibling();
                    }
                    break;
                }
                case 3: 
                case 4: {
                    if (prevSibling != null && (prevSibling.getNodeType() == 3 || prevSibling.getNodeType() == 4)) {
                        return;
                    }
                }
                case 7: {
                    nodeSet.add(node);
                    break;
                }
                case 8: {
                    if (!this.withComments) break;
                    nodeSet.add(node);
                }
            }
        }
    }
}

