/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms;

import com.sun.org.apache.xml.internal.security.algorithms.Algorithm;
import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithmSpi;
import com.sun.org.apache.xml.internal.security.exceptions.AlgorithmAlreadyRegisteredException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureAlgorithm
extends Algorithm {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$algorithms$SignatureAlgorithm == null ? (class$com$sun$org$apache$xml$internal$security$algorithms$SignatureAlgorithm = SignatureAlgorithm.class$("com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm")) : class$com$sun$org$apache$xml$internal$security$algorithms$SignatureAlgorithm).getName());
    static boolean _alreadyInitialized = false;
    static HashMap _algorithmHash = null;
    protected SignatureAlgorithmSpi _signatureAlgorithm = null;
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$algorithms$SignatureAlgorithm;

    public static void providerInit() {
        if (log == null) {
            log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$algorithms$SignatureAlgorithm == null ? (class$com$sun$org$apache$xml$internal$security$algorithms$SignatureAlgorithm = SignatureAlgorithm.class$("com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm")) : class$com$sun$org$apache$xml$internal$security$algorithms$SignatureAlgorithm).getName());
        }
        log.log(Level.FINE, "Init() called");
        if (!_alreadyInitialized) {
            _algorithmHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    public byte[] sign() throws XMLSignatureException {
        return this._signatureAlgorithm.engineSign();
    }

    public void update(byte by) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(by);
    }

    public void update(byte[] byArray) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(byArray);
    }

    public boolean verify(byte[] byArray) throws XMLSignatureException {
        return this._signatureAlgorithm.engineVerify(byArray);
    }

    public void update(byte[] byArray, int n, int n2) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(byArray, n, n2);
    }

    public String getBaseLocalName() {
        return "SignatureMethod";
    }

    public String getBaseNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    public String getJCEAlgorithmString() {
        return this._signatureAlgorithm.engineGetJCEAlgorithmString();
    }

    public String getJCEProviderName() {
        return this._signatureAlgorithm.engineGetJCEProviderName();
    }

    public final String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public void initSign(Key key) throws XMLSignatureException {
        this._signatureAlgorithm.engineInitSign(key);
    }

    public void initVerify(Key key) throws XMLSignatureException {
        this._signatureAlgorithm.engineInitVerify(key);
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        this._signatureAlgorithm.engineSetParameter(algorithmParameterSpec);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static String getImplementingClass(String string) {
        if (_algorithmHash == null) {
            return null;
        }
        return (String)_algorithmHash.get(string);
    }

    public static void register(String string, String string2) throws AlgorithmAlreadyRegisteredException {
        log.log(Level.FINE, "Try to register " + string + " " + string2);
        String string3 = SignatureAlgorithm.getImplementingClass(string);
        if (string3 != null && string3.length() != 0) {
            Object[] objectArray = new Object[]{string, string3};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        _algorithmHash.put(string, string2);
    }

    public SignatureAlgorithm(Document document, String string) throws XMLSecurityException {
        super(document, string);
        try {
            String string2 = SignatureAlgorithm.getImplementingClass(string);
            log.log(Level.FINE, "Create URI \"" + string + "\" class \"" + string2 + "\"");
            this._signatureAlgorithm = (SignatureAlgorithmSpi)Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{string, classNotFoundException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string, illegalAccessException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string, instantiationException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, instantiationException);
        }
        catch (NullPointerException nullPointerException) {
            Object[] objectArray = new Object[]{string, nullPointerException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, nullPointerException);
        }
    }

    public SignatureAlgorithm(Document document, String string, int n) throws XMLSecurityException {
        this(document, string);
        this._signatureAlgorithm.engineSetHMACOutputLength(n);
        this._signatureAlgorithm.engineAddContextToElement(this._constructionElement);
    }

    public SignatureAlgorithm(Element element, String string) throws XMLSecurityException {
        super(element, string);
        String string2 = this.getURI();
        try {
            String string3 = SignatureAlgorithm.getImplementingClass(string2);
            log.log(Level.FINE, "Create URI \"" + string2 + "\" class \"" + string3 + "\"");
            this._signatureAlgorithm = (SignatureAlgorithmSpi)Class.forName(string3).newInstance();
            this._signatureAlgorithm.engineGetContextFromElement(this._constructionElement);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{string2, classNotFoundException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string2, illegalAccessException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string2, instantiationException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, instantiationException);
        }
        catch (NullPointerException nullPointerException) {
            Object[] objectArray = new Object[]{string2, nullPointerException.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray, nullPointerException);
        }
    }

    public void initSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        this._signatureAlgorithm.engineInitSign(key, secureRandom);
    }

    public void initSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        this._signatureAlgorithm.engineInitSign(key, algorithmParameterSpec);
    }
}

