/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms.implementations;

import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithmSpi;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SignatureDSA
extends SignatureAlgorithmSpi {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$algorithms$implementations$SignatureDSA == null ? (class$com$sun$org$apache$xml$internal$security$algorithms$implementations$SignatureDSA = SignatureDSA.class$("com.sun.org.apache.xml.internal.security.algorithms.implementations.SignatureDSA")) : class$com$sun$org$apache$xml$internal$security$algorithms$implementations$SignatureDSA).getName());
    public static final String _URI = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private Signature _signatureAlgorithm = null;
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$algorithms$implementations$SignatureDSA;
    static /* synthetic */ Class class$java$security$PublicKey;
    static /* synthetic */ Class class$java$security$PrivateKey;

    public SignatureDSA() throws XMLSignatureException {
        String string = JCEMapper.translateURItoJCEID(_URI);
        log.log(Level.FINE, "Created SignatureDSA using " + string);
        try {
            this._signatureAlgorithm = Signature.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[]{string, noSuchAlgorithmException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
    }

    protected byte[] engineSign() throws XMLSignatureException {
        try {
            byte[] byArray = this._signatureAlgorithm.sign();
            return SignatureDSA.convertASN1toXMLDSIG(byArray);
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected void engineUpdate(byte by) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.update(by);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected void engineSetHMACOutputLength(int n) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.HMACOutputLengthOnlyForHMAC");
    }

    protected void engineUpdate(byte[] byArray) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.update(byArray);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected boolean engineVerify(byte[] byArray) throws XMLSignatureException {
        try {
            log.log(Level.FINE, "Called DSA.verify() on " + Base64.encode(byArray));
            byte[] byArray2 = SignatureDSA.convertXMLDSIGtoASN1(byArray);
            return this._signatureAlgorithm.verify(byArray2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
    }

    private static byte[] convertASN1toXMLDSIG(byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3 = n2 = byArray[3];
        while (n3 > 0 && byArray[4 + n2 - n3] == 0) {
            --n3;
        }
        int n4 = n = byArray[5 + n2];
        while (n4 > 0 && byArray[6 + n2 + n - n4] == 0) {
            --n4;
        }
        if (byArray[0] != 48 || byArray[1] != byArray.length - 2 || byArray[2] != 2 || n3 > 20 || byArray[4 + n2] != 2 || n4 > 20) {
            throw new IOException("Invalid ASN.1 format of DSA signature");
        }
        byte[] byArray2 = new byte[40];
        System.arraycopy(byArray, 4 + n2 - n3, byArray2, 20 - n3, n3);
        System.arraycopy(byArray, 6 + n2 + n - n4, byArray2, 40 - n4, n4);
        return byArray2;
    }

    private static byte[] convertXMLDSIGtoASN1(byte[] byArray) throws IOException {
        if (byArray.length != 40) {
            throw new IOException("Invalid XMLDSIG format of DSA signature");
        }
        int n = 20;
        while (n > 0 && byArray[20 - n] == 0) {
            --n;
        }
        int n2 = n;
        if (byArray[20 - n] < 0) {
            ++n2;
        }
        int n3 = 20;
        while (n3 > 0 && byArray[40 - n3] == 0) {
            --n3;
        }
        int n4 = n3;
        if (byArray[40 - n3] < 0) {
            ++n4;
        }
        byte[] byArray2 = new byte[6 + n2 + n4];
        byArray2[0] = 48;
        byArray2[1] = (byte)(4 + n2 + n4);
        byArray2[2] = 2;
        byArray2[3] = (byte)n2;
        System.arraycopy(byArray, 20 - n, byArray2, 4 + n2 - n, n);
        byArray2[4 + n2] = 2;
        byArray2[5 + n2] = (byte)n4;
        System.arraycopy(byArray, 40 - n3, byArray2, 6 + n2 + n4 - n3, n3);
        return byArray2;
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.update(byArray, n, n2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException("empty", signatureException);
        }
    }

    protected String engineGetJCEAlgorithmString() {
        return this._signatureAlgorithm.getAlgorithm();
    }

    protected String engineGetJCEProviderName() {
        return this._signatureAlgorithm.getProvider().getName();
    }

    protected String engineGetURI() {
        return _URI;
    }

    protected void engineInitSign(Key key) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            String string = key.getClass().getName();
            String string2 = (class$java$security$PrivateKey == null ? (class$java$security$PrivateKey = SignatureDSA.class$("java.security.PrivateKey")) : class$java$security$PrivateKey).getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this._signatureAlgorithm.initSign((PrivateKey)key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected void engineInitVerify(Key key) throws XMLSignatureException {
        if (!(key instanceof PublicKey)) {
            String string = key.getClass().getName();
            String string2 = (class$java$security$PublicKey == null ? (class$java$security$PublicKey = SignatureDSA.class$("java.security.PublicKey")) : class$java$security$PublicKey).getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this._signatureAlgorithm.initVerify((PublicKey)key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        try {
            this._signatureAlgorithm.setParameter(algorithmParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSignatureException("empty", invalidAlgorithmParameterException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void engineInitSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            String string = key.getClass().getName();
            String string2 = (class$java$security$PrivateKey == null ? (class$java$security$PrivateKey = SignatureDSA.class$("java.security.PrivateKey")) : class$java$security$PrivateKey).getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this._signatureAlgorithm.initSign((PrivateKey)key, secureRandom);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("empty", invalidKeyException);
        }
    }

    protected void engineInitSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseAlgorithmParameterSpecOnDSA");
    }
}

