/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.c14n.helper;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class C14nHelper {
    private C14nHelper() {
    }

    public static boolean namespaceIsAbsolute(String string) {
        if (string.length() == 0) {
            return true;
        }
        return string.indexOf(58) > 0;
    }

    public static boolean namespaceIsRelative(String string) {
        return !C14nHelper.namespaceIsAbsolute(string);
    }

    public static void assertNotRelativeNS(Attr attr) throws CanonicalizationException {
        if (attr == null) {
            return;
        }
        String string = attr.getNodeName();
        boolean bl = string.equals("xmlns");
        boolean bl2 = string.startsWith("xmlns:");
        if ((bl || bl2) && C14nHelper.namespaceIsRelative(attr)) {
            String string2 = attr.getOwnerElement().getTagName();
            String string3 = attr.getValue();
            Object[] objectArray = new Object[]{string2, string, string3};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
        }
    }

    public static boolean namespaceIsAbsolute(Attr attr) {
        return C14nHelper.namespaceIsAbsolute(attr.getValue());
    }

    public static boolean namespaceIsRelative(Attr attr) {
        return !C14nHelper.namespaceIsAbsolute(attr);
    }

    public static void checkTraversability(Document document) throws CanonicalizationException {
        if (!document.isSupported("Traversal", "2.0")) {
            Object[] objectArray = new Object[]{document.getImplementation().getClass().getName()};
            throw new CanonicalizationException("c14n.Canonicalizer.TraversalNotSupported", objectArray);
        }
    }

    public static void checkForRelativeNamespace(Element element) throws CanonicalizationException {
        if (element != null) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                C14nHelper.assertNotRelativeNS((Attr)namedNodeMap.item(n));
                ++n;
            }
        } else {
            throw new CanonicalizationException("Called checkForRelativeNamespace() on null");
        }
    }
}

