/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys;

import com.sun.org.apache.xml.internal.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.internal.security.encryption.XMLCipher;
import com.sun.org.apache.xml.internal.security.encryption.XMLEncryptionException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.KeyName;
import com.sun.org.apache.xml.internal.security.keys.content.KeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.MgmtData;
import com.sun.org.apache.xml.internal.security.keys.content.PGPData;
import com.sun.org.apache.xml.internal.security.keys.content.RetrievalMethod;
import com.sun.org.apache.xml.internal.security.keys.content.SPKIData;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.DSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.RSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolver;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.IdResolver;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyInfo
extends SignatureElementProxy {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$keys$KeyInfo == null ? (class$com$sun$org$apache$xml$internal$security$keys$KeyInfo = KeyInfo.class$("com.sun.org.apache.xml.internal.security.keys.KeyInfo")) : class$com$sun$org$apache$xml$internal$security$keys$KeyInfo).getName());
    List _internalKeyResolvers = new ArrayList();
    List _storageResolvers = new ArrayList();
    static boolean _alreadyInitialized = false;
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$keys$KeyInfo;

    int lengthInternalKeyResolver() {
        return this._internalKeyResolvers.size();
    }

    public int lengthKeyName() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyName");
    }

    public int lengthKeyValue() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
    }

    public int lengthMgmtData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "MgmtData");
    }

    public int lengthPGPData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "PGPData");
    }

    public int lengthRetrievalMethod() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "RetrievalMethod");
    }

    public int lengthSPKIData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "SPKIData");
    }

    public int lengthUnknownElement() {
        int n = 0;
        NodeList nodeList = this._constructionElement.getChildNodes();
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int lengthX509Data() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509Data");
    }

    public static void init() {
        if (!_alreadyInitialized) {
            if (log == null) {
                log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$keys$KeyInfo == null ? (class$com$sun$org$apache$xml$internal$security$keys$KeyInfo = KeyInfo.class$("com.sun.org.apache.xml.internal.security.keys.KeyInfo")) : class$com$sun$org$apache$xml$internal$security$keys$KeyInfo).getName());
                log.log(Level.SEVERE, "Had to assign log in the init() function");
            }
            _alreadyInitialized = true;
        }
    }

    public boolean containsKeyName() {
        return this.lengthKeyName() > 0;
    }

    public boolean containsKeyValue() {
        return this.lengthKeyValue() > 0;
    }

    public boolean containsMgmtData() {
        return this.lengthMgmtData() > 0;
    }

    public boolean containsPGPData() {
        return this.lengthPGPData() > 0;
    }

    public boolean containsRetrievalMethod() {
        return this.lengthRetrievalMethod() > 0;
    }

    public boolean containsSPKIData() {
        return this.lengthSPKIData() > 0;
    }

    public boolean containsUnknownElement() {
        return this.lengthUnknownElement() > 0;
    }

    public boolean containsX509Data() {
        return this.lengthX509Data() > 0;
    }

    public boolean isEmpty() {
        return this._constructionElement.getFirstChild() == null;
    }

    public EncryptedKey itemEncryptedKey(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectXencNode(this._constructionElement.getFirstChild(), "EncryptedKey", n);
        if (element != null) {
            XMLCipher xMLCipher = XMLCipher.getInstance();
            xMLCipher.init(4, null);
            return xMLCipher.loadEncryptedKey(element);
        }
        return null;
    }

    public void add(EncryptedKey encryptedKey) throws XMLEncryptionException {
        if (this._state == 0) {
            XMLCipher xMLCipher = XMLCipher.getInstance();
            this._constructionElement.appendChild(xMLCipher.martial(encryptedKey));
        }
    }

    public KeyName itemKeyName(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "KeyName", n);
        if (element != null) {
            return new KeyName(element, this._baseURI);
        }
        return null;
    }

    public void add(KeyName keyName) {
        if (this._state == 0) {
            this._constructionElement.appendChild(keyName.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public KeyValue itemKeyValue(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "KeyValue", n);
        if (element != null) {
            return new KeyValue(element, this._baseURI);
        }
        return null;
    }

    public void add(KeyValue keyValue) {
        if (this._state == 0) {
            this._constructionElement.appendChild(keyValue.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public MgmtData itemMgmtData(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "MgmtData", n);
        if (element != null) {
            return new MgmtData(element, this._baseURI);
        }
        return null;
    }

    public void add(MgmtData mgmtData) {
        if (this._state == 0) {
            this._constructionElement.appendChild(mgmtData.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public PGPData itemPGPData(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "PGPData", n);
        if (element != null) {
            return new PGPData(element, this._baseURI);
        }
        return null;
    }

    public void add(PGPData pGPData) {
        if (this._state == 0) {
            this._constructionElement.appendChild(pGPData.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public RetrievalMethod itemRetrievalMethod(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "RetrievalMethod", n);
        if (element != null) {
            return new RetrievalMethod(element, this._baseURI);
        }
        return null;
    }

    public void add(RetrievalMethod retrievalMethod) {
        if (this._state == 0) {
            this._constructionElement.appendChild(retrievalMethod.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public SPKIData itemSPKIData(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "SPKIData", n);
        if (element != null) {
            return new SPKIData(element, this._baseURI);
        }
        return null;
    }

    public void add(SPKIData sPKIData) {
        if (this._state == 0) {
            this._constructionElement.appendChild(sPKIData.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public X509Data itemX509Data(int n) throws XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "X509Data", n);
        if (element != null) {
            return new X509Data(element, this._baseURI);
        }
        return null;
    }

    public void add(X509Data x509Data) {
        if (this._state == 0) {
            this._constructionElement.appendChild(x509Data.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public void add(DSAKeyValue dSAKeyValue) {
        this.add(new KeyValue(this._doc, dSAKeyValue));
    }

    public void add(RSAKeyValue rSAKeyValue) {
        this.add(new KeyValue(this._doc, rSAKeyValue));
    }

    KeyResolverSpi itemInternalKeyResolver(int n) {
        return (KeyResolverSpi)this._internalKeyResolvers.get(n);
    }

    public void registerInternalKeyResolver(KeyResolverSpi keyResolverSpi) {
        this._internalKeyResolvers.add(keyResolverSpi);
    }

    public void addStorageResolver(StorageResolver storageResolver) {
        if (storageResolver != null) {
            this._storageResolvers.add(storageResolver);
        }
    }

    public String getBaseLocalName() {
        return "KeyInfo";
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public void addKeyName(String string) {
        this.add(new KeyName(this._doc, string));
    }

    public void addMgmtData(String string) {
        this.add(new MgmtData(this._doc, string));
    }

    public void setId(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "Id", string);
            IdResolver.registerElementById(this._constructionElement, string);
        }
    }

    public PublicKey getPublicKey() throws KeyResolverException {
        PublicKey publicKey = this.getPublicKeyFromInternalResolvers();
        if (publicKey != null) {
            log.log(Level.FINE, "I could find a key using the per-KeyInfo key resolvers");
            return publicKey;
        }
        log.log(Level.FINE, "I couldn't find a key using the per-KeyInfo key resolvers");
        publicKey = this.getPublicKeyFromStaticResolvers();
        if (publicKey != null) {
            log.log(Level.FINE, "I could find a key using the system-wide key resolvers");
            return publicKey;
        }
        log.log(Level.FINE, "I couldn't find a key using the system-wide key resolvers");
        return null;
    }

    PublicKey getPublicKeyFromInternalResolvers() throws KeyResolverException {
        int n = 0;
        while (n < this.lengthInternalKeyResolver()) {
            KeyResolverSpi keyResolverSpi = this.itemInternalKeyResolver(n);
            log.log(Level.FINE, "Try " + keyResolverSpi.getClass().getName());
            Node node = this._constructionElement.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    Object object;
                    if (this._storageResolvers.size() == 0) {
                        StorageResolver storageResolver = null;
                        if (keyResolverSpi.engineCanResolve((Element)node, this.getBaseURI(), storageResolver) && (object = keyResolverSpi.engineResolvePublicKey((Element)node, this.getBaseURI(), storageResolver)) != null) {
                            return object;
                        }
                    } else {
                        int n2 = 0;
                        while (n2 < this._storageResolvers.size()) {
                            PublicKey publicKey;
                            object = (StorageResolver)this._storageResolvers.get(n2);
                            if (keyResolverSpi.engineCanResolve((Element)node, this.getBaseURI(), (StorageResolver)object) && (publicKey = keyResolverSpi.engineResolvePublicKey((Element)node, this.getBaseURI(), (StorageResolver)object)) != null) {
                                return publicKey;
                            }
                            ++n2;
                        }
                    }
                }
                node = node.getNextSibling();
            }
            ++n;
        }
        return null;
    }

    PublicKey getPublicKeyFromStaticResolvers() throws KeyResolverException {
        int n = 0;
        while (n < KeyResolver.length()) {
            KeyResolver keyResolver = KeyResolver.item(n);
            Node node = this._constructionElement.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    Object object;
                    if (this._storageResolvers.size() == 0) {
                        StorageResolver storageResolver = null;
                        if (keyResolver.canResolve((Element)node, this.getBaseURI(), storageResolver) && (object = keyResolver.resolvePublicKey((Element)node, this.getBaseURI(), storageResolver)) != null) {
                            return object;
                        }
                    } else {
                        int n2 = 0;
                        while (n2 < this._storageResolvers.size()) {
                            PublicKey publicKey;
                            object = (StorageResolver)this._storageResolvers.get(n2);
                            if (keyResolver.canResolve((Element)node, this.getBaseURI(), (StorageResolver)object) && (publicKey = keyResolver.resolvePublicKey((Element)node, this.getBaseURI(), (StorageResolver)object)) != null) {
                                return publicKey;
                            }
                            ++n2;
                        }
                    }
                }
                node = node.getNextSibling();
            }
            ++n;
        }
        return null;
    }

    public void add(PublicKey publicKey) {
        this.add(new KeyValue(this._doc, publicKey));
    }

    public void addKeyValue(PublicKey publicKey) {
        this.add(new KeyValue(this._doc, publicKey));
    }

    public X509Certificate getX509Certificate() throws KeyResolverException {
        X509Certificate x509Certificate = this.getX509CertificateFromInternalResolvers();
        if (x509Certificate != null) {
            log.log(Level.FINE, "I could find a X509Certificate using the per-KeyInfo key resolvers");
            return x509Certificate;
        }
        log.log(Level.FINE, "I couldn't find a X509Certificate using the per-KeyInfo key resolvers");
        x509Certificate = this.getX509CertificateFromStaticResolvers();
        if (x509Certificate != null) {
            log.log(Level.FINE, "I could find a X509Certificate using the system-wide key resolvers");
            return x509Certificate;
        }
        log.log(Level.FINE, "I couldn't find a X509Certificate using the system-wide key resolvers");
        return null;
    }

    X509Certificate getX509CertificateFromInternalResolvers() throws KeyResolverException {
        log.log(Level.FINE, "Start getX509CertificateFromInternalResolvers() with " + this.lengthInternalKeyResolver() + " resolvers");
        int n = 0;
        while (n < this.lengthInternalKeyResolver()) {
            KeyResolverSpi keyResolverSpi = this.itemInternalKeyResolver(n);
            log.log(Level.FINE, "Try " + keyResolverSpi.getClass().getName());
            Node node = this._constructionElement.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    Object object;
                    if (this._storageResolvers.size() == 0) {
                        StorageResolver storageResolver = null;
                        if (keyResolverSpi.engineCanResolve((Element)node, this.getBaseURI(), storageResolver) && (object = keyResolverSpi.engineResolveX509Certificate((Element)node, this.getBaseURI(), storageResolver)) != null) {
                            return object;
                        }
                    } else {
                        int n2 = 0;
                        while (n2 < this._storageResolvers.size()) {
                            X509Certificate x509Certificate;
                            object = (StorageResolver)this._storageResolvers.get(n2);
                            if (keyResolverSpi.engineCanResolve((Element)node, this.getBaseURI(), (StorageResolver)object) && (x509Certificate = keyResolverSpi.engineResolveX509Certificate((Element)node, this.getBaseURI(), (StorageResolver)object)) != null) {
                                return x509Certificate;
                            }
                            ++n2;
                        }
                    }
                }
                node = node.getNextSibling();
            }
            ++n;
        }
        return null;
    }

    X509Certificate getX509CertificateFromStaticResolvers() throws KeyResolverException {
        log.log(Level.FINE, "Start getX509CertificateFromStaticResolvers() with " + KeyResolver.length() + " resolvers");
        int n = 0;
        while (n < KeyResolver.length()) {
            KeyResolver keyResolver = KeyResolver.item(n);
            Node node = this._constructionElement.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    Object object;
                    if (this._storageResolvers.size() == 0) {
                        StorageResolver storageResolver = null;
                        if (keyResolver.canResolve((Element)node, this.getBaseURI(), storageResolver) && (object = keyResolver.resolveX509Certificate((Element)node, this.getBaseURI(), storageResolver)) != null) {
                            return object;
                        }
                    } else {
                        int n2 = 0;
                        while (n2 < this._storageResolvers.size()) {
                            X509Certificate x509Certificate;
                            object = (StorageResolver)this._storageResolvers.get(n2);
                            if (keyResolver.canResolve((Element)node, this.getBaseURI(), (StorageResolver)object) && (x509Certificate = keyResolver.resolveX509Certificate((Element)node, this.getBaseURI(), (StorageResolver)object)) != null) {
                                return x509Certificate;
                            }
                            ++n2;
                        }
                    }
                }
                node = node.getNextSibling();
            }
            ++n;
        }
        return null;
    }

    List getStorageResolvers() {
        return this._storageResolvers;
    }

    public SecretKey getSecretKey() throws KeyResolverException {
        SecretKey secretKey = this.getSecretKeyFromInternalResolvers();
        if (secretKey != null) {
            log.log(Level.FINE, "I could find a secret key using the per-KeyInfo key resolvers");
            return secretKey;
        }
        log.log(Level.FINE, "I couldn't find a secret key using the per-KeyInfo key resolvers");
        secretKey = this.getSecretKeyFromStaticResolvers();
        if (secretKey != null) {
            log.log(Level.FINE, "I could find a secret key using the system-wide key resolvers");
            return secretKey;
        }
        log.log(Level.FINE, "I couldn't find a secret key using the system-wide key resolvers");
        return null;
    }

    SecretKey getSecretKeyFromInternalResolvers() throws KeyResolverException {
        int n = 0;
        while (n < this.lengthInternalKeyResolver()) {
            KeyResolverSpi keyResolverSpi = this.itemInternalKeyResolver(n);
            log.log(Level.FINE, "Try " + keyResolverSpi.getClass().getName());
            Node node = this._constructionElement.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    Object object;
                    if (this._storageResolvers.size() == 0) {
                        StorageResolver storageResolver = null;
                        if (keyResolverSpi.engineCanResolve((Element)node, this.getBaseURI(), storageResolver) && (object = keyResolverSpi.engineResolveSecretKey((Element)node, this.getBaseURI(), storageResolver)) != null) {
                            return object;
                        }
                    } else {
                        int n2 = 0;
                        while (n2 < this._storageResolvers.size()) {
                            SecretKey secretKey;
                            object = (StorageResolver)this._storageResolvers.get(n2);
                            if (keyResolverSpi.engineCanResolve((Element)node, this.getBaseURI(), (StorageResolver)object) && (secretKey = keyResolverSpi.engineResolveSecretKey((Element)node, this.getBaseURI(), (StorageResolver)object)) != null) {
                                return secretKey;
                            }
                            ++n2;
                        }
                    }
                }
                node = node.getNextSibling();
            }
            ++n;
        }
        return null;
    }

    SecretKey getSecretKeyFromStaticResolvers() throws KeyResolverException {
        int n = 0;
        while (n < KeyResolver.length()) {
            KeyResolver keyResolver = KeyResolver.item(n);
            Node node = this._constructionElement.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    Object object;
                    if (this._storageResolvers.size() == 0) {
                        StorageResolver storageResolver = null;
                        if (keyResolver.canResolve((Element)node, this.getBaseURI(), storageResolver) && (object = keyResolver.resolveSecretKey((Element)node, this.getBaseURI(), storageResolver)) != null) {
                            return object;
                        }
                    } else {
                        int n2 = 0;
                        while (n2 < this._storageResolvers.size()) {
                            SecretKey secretKey;
                            object = (StorageResolver)this._storageResolvers.get(n2);
                            if (keyResolver.canResolve((Element)node, this.getBaseURI(), (StorageResolver)object) && (secretKey = keyResolver.resolveSecretKey((Element)node, this.getBaseURI(), (StorageResolver)object)) != null) {
                                return secretKey;
                            }
                            ++n2;
                        }
                    }
                }
                node = node.getNextSibling();
            }
            ++n;
        }
        return null;
    }

    public KeyInfo(Document document) {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public Element itemUnknownElement(int n) {
        NodeList nodeList = this._constructionElement.getChildNodes();
        int n2 = 0;
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            Node node = nodeList.item(n3);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && ++n2 == n) {
                return (Element)node;
            }
            ++n3;
        }
        return null;
    }

    public void addKeyValue(Element element) {
        this.add(new KeyValue(this._doc, element));
    }

    public void addUnknownElement(Element element) {
        if (this._state == 0) {
            this._constructionElement.appendChild(element);
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public KeyInfo(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public void addRetrievalMethod(String string, Transforms transforms, String string2) {
        this.add(new RetrievalMethod(this._doc, string, transforms, string2));
    }
}

