/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.RSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class RSAKeyValueResolver
extends KeyResolverSpi {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$keys$keyresolver$implementations$RSAKeyValueResolver == null ? (class$com$sun$org$apache$xml$internal$security$keys$keyresolver$implementations$RSAKeyValueResolver = RSAKeyValueResolver.class$("com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.RSAKeyValueResolver")) : class$com$sun$org$apache$xml$internal$security$keys$keyresolver$implementations$RSAKeyValueResolver).getName());
    private Element _rsaKeyElement = null;
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$keys$keyresolver$implementations$RSAKeyValueResolver;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        log.log(Level.FINE, "Can I resolve " + element.getTagName());
        if (element == null) {
            return false;
        }
        boolean bl = XMLUtils.elementIsInSignatureSpace(element, "KeyValue");
        boolean bl2 = XMLUtils.elementIsInSignatureSpace(element, "RSAKeyValue");
        if (bl) {
            this._rsaKeyElement = XMLUtils.selectDsNode(element.getFirstChild(), "RSAKeyValue", 0);
            if (this._rsaKeyElement != null) {
                return true;
            }
        } else if (bl2) {
            this._rsaKeyElement = element;
            return true;
        }
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver) {
        boolean bl;
        if (!(this._rsaKeyElement != null || (bl = this.engineCanResolve(element, string, storageResolver)) && this._rsaKeyElement != null)) {
            return null;
        }
        try {
            RSAKeyValue rSAKeyValue = new RSAKeyValue(this._rsaKeyElement, string);
            return rSAKeyValue.getPublicKey();
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
            return null;
        }
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }
}

