/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509SubjectName;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class X509SubjectNameResolver
extends KeyResolverSpi {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$keys$keyresolver$implementations$X509SubjectNameResolver == null ? (class$com$sun$org$apache$xml$internal$security$keys$keyresolver$implementations$X509SubjectNameResolver = X509SubjectNameResolver.class$("com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.X509SubjectNameResolver")) : class$com$sun$org$apache$xml$internal$security$keys$keyresolver$implementations$X509SubjectNameResolver).getName());
    private Element[] _x509childNodes = null;
    private XMLX509SubjectName[] _x509childObject = null;
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$keys$keyresolver$implementations$X509SubjectNameResolver;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        log.log(Level.FINE, "Can I resolve " + element.getTagName() + "?");
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            log.log(Level.FINE, "I can't");
            return false;
        }
        this._x509childNodes = XMLUtils.selectDsNodes(element, "X509SubjectName");
        if (this._x509childNodes != null && this._x509childNodes.length > 0) {
            log.log(Level.FINE, "Yes Sir, I can");
            return true;
        }
        log.log(Level.FINE, "I can't");
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineResolveX509Certificate(element, string, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        try {
            int n;
            if (this._x509childNodes == null && ((n = this.engineCanResolve(element, string, storageResolver)) == 0 || this._x509childNodes == null)) {
                return null;
            }
            if (storageResolver == null) {
                Object[] objectArray = new Object[]{"X509SubjectName"};
                KeyResolverException keyResolverException = new KeyResolverException("KeyResolver.needStorageResolver", objectArray);
                log.log(Level.INFO, "", keyResolverException);
                throw keyResolverException;
            }
            this._x509childObject = new XMLX509SubjectName[this._x509childNodes.length];
            n = 0;
            while (n < this._x509childNodes.length) {
                this._x509childObject[n] = new XMLX509SubjectName(this._x509childNodes[n], string);
                ++n;
            }
            while (storageResolver.hasNext()) {
                X509Certificate x509Certificate = storageResolver.next();
                XMLX509SubjectName xMLX509SubjectName = new XMLX509SubjectName(element.getOwnerDocument(), x509Certificate);
                log.log(Level.FINE, "Found Certificate SN: " + xMLX509SubjectName.getSubjectName());
                int n2 = 0;
                while (n2 < this._x509childObject.length) {
                    log.log(Level.FINE, "Found Element SN:     " + this._x509childObject[n2].getSubjectName());
                    if (xMLX509SubjectName.equals(this._x509childObject[n2])) {
                        log.log(Level.FINE, "match !!! ");
                        return x509Certificate;
                    }
                    log.log(Level.FINE, "no match...");
                    ++n2;
                }
            }
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
            throw new KeyResolverException("generic.EmptyMessage", xMLSecurityException);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }
}

