/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.signature;

import com.sun.org.apache.xml.internal.security.algorithms.MessageDigestAlgorithm;
import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.Manifest;
import com.sun.org.apache.xml.internal.security.signature.ReferenceNotInitializedException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.InvalidTransformException;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.transforms.params.InclusiveNamespaces;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.DigesterOutputStream;
import com.sun.org.apache.xml.internal.security.utils.ElementProxy;
import com.sun.org.apache.xml.internal.security.utils.IdResolver;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Reference
extends SignatureElementProxy {
    public static boolean CacheSignedNodes = false;
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$signature$Reference == null ? (class$com$sun$org$apache$xml$internal$security$signature$Reference = Reference.class$("com.sun.org.apache.xml.internal.security.signature.Reference")) : class$com$sun$org$apache$xml$internal$security$signature$Reference).getName());
    public static final String OBJECT_URI = "http://www.w3.org/2000/09/xmldsig#Object";
    public static final String MANIFEST_URI = "http://www.w3.org/2000/09/xmldsig#Manifest";
    Manifest _manifest = null;
    XMLSignatureInput _transformsOutput;
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$signature$Reference;

    public void generateDigestValue() throws XMLSignatureException, ReferenceNotInitializedException {
        if (this._state == 0) {
            this.setDigestValueElement(this.calculateDigest());
        }
    }

    public boolean typeIsReferenceToManifest() {
        return this.getType() != null && this.getType().equals(MANIFEST_URI);
    }

    public boolean typeIsReferenceToObject() {
        return this.getType() != null && this.getType().equals(OBJECT_URI);
    }

    public boolean verify() throws ReferenceNotInitializedException, XMLSecurityException {
        byte[] byArray;
        byte[] byArray2 = this.getDigestValue();
        boolean bl = MessageDigestAlgorithm.isEqual(byArray2, byArray = this.calculateDigest());
        if (!bl) {
            log.log(Level.WARNING, "Verification failed for URI \"" + this.getURI() + "\"");
        } else {
            log.log(Level.INFO, "Verification successful for URI \"" + this.getURI() + "\"");
        }
        return bl;
    }

    private byte[] calculateDigest() throws ReferenceNotInitializedException, XMLSignatureException {
        try {
            MessageDigestAlgorithm messageDigestAlgorithm = this.getMessageDigestAlgorithm();
            messageDigestAlgorithm.reset();
            DigesterOutputStream digesterOutputStream = new DigesterOutputStream(messageDigestAlgorithm);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(digesterOutputStream);
            XMLSignatureInput xMLSignatureInput = this.dereferenceURIandPerformTransforms(bufferedOutputStream);
            xMLSignatureInput.updateOutputStream(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).flush();
            return digesterOutputStream.getDigestValue();
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new ReferenceNotInitializedException("empty", xMLSecurityException);
        }
        catch (IOException iOException) {
            throw new ReferenceNotInitializedException("empty", iOException);
        }
    }

    public byte[] getDigestValue() throws Base64DecodingException, XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "DigestValue", 0);
        if (element == null) {
            Object[] objectArray = new Object[]{"DigestValue", "http://www.w3.org/2000/09/xmldsig#"};
            throw new XMLSecurityException("signature.Verification.NoSignatureElement", objectArray);
        }
        byte[] byArray = Base64.decode(element);
        return byArray;
    }

    public byte[] getReferencedBytes() throws ReferenceNotInitializedException, XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput = this.dereferenceURIandPerformTransforms(null);
            byte[] byArray = xMLSignatureInput.getBytes();
            return byArray;
        }
        catch (IOException iOException) {
            throw new ReferenceNotInitializedException("empty", iOException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new ReferenceNotInitializedException("empty", canonicalizationException);
        }
    }

    private void setDigestValueElement(byte[] byArray) {
        if (this._state == 0) {
            Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "DigestValue", 0);
            Node node = element.getFirstChild();
            while (node != null) {
                element.removeChild(node);
                node = node.getNextSibling();
            }
            String string = Base64.encode(byArray);
            Text text = this._doc.createTextNode(string);
            element.appendChild(text);
        }
    }

    public MessageDigestAlgorithm getMessageDigestAlgorithm() throws XMLSignatureException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "DigestMethod", 0);
        if (element == null) {
            return null;
        }
        String string = element.getAttributeNS(null, "Algorithm");
        if (string == null) {
            return null;
        }
        return MessageDigestAlgorithm.getInstance(this._doc, string);
    }

    public XMLSignatureInput getContentsAfterTransformation() throws XMLSignatureException {
        XMLSignatureInput xMLSignatureInput = this.getContentsBeforeTransformation();
        return this.getContentsAfterTransformation(xMLSignatureInput, null);
    }

    public XMLSignatureInput getContentsBeforeTransformation() throws ReferenceNotInitializedException {
        try {
            Attr attr = this._constructionElement.getAttributeNodeNS(null, "URI");
            String string = attr == null ? null : attr.getNodeValue();
            ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, this._baseURI, this._manifest._perManifestResolvers);
            if (resourceResolver == null) {
                Object[] objectArray = new Object[]{string};
                throw new ReferenceNotInitializedException("signature.Verification.Reference.NoInput", objectArray);
            }
            resourceResolver.addProperties(this._manifest._resolverProperties);
            XMLSignatureInput xMLSignatureInput = resourceResolver.resolve(attr, this._baseURI);
            return xMLSignatureInput;
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new ReferenceNotInitializedException("empty", resourceResolverException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new ReferenceNotInitializedException("empty", xMLSecurityException);
        }
    }

    public XMLSignatureInput getNodesetBeforeFirstCanonicalization() throws XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput;
            XMLSignatureInput xMLSignatureInput2 = xMLSignatureInput = this.getContentsBeforeTransformation();
            Transforms transforms = this.getTransforms();
            if (transforms != null) {
                int n = 0;
                while (n < transforms.getLength()) {
                    Transform transform = transforms.item(n);
                    String string = transform.getURI();
                    if (string.equals("http://www.w3.org/2001/10/xml-exc-c14n#") || string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments") || string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments")) break;
                    xMLSignatureInput2 = transform.performTransform(xMLSignatureInput2, null);
                    ++n;
                }
                xMLSignatureInput2.setSourceURI(xMLSignatureInput.getSourceURI());
            }
            return xMLSignatureInput2;
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new XMLSignatureException("empty", resourceResolverException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new XMLSignatureException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLSignatureException("empty", invalidCanonicalizerException);
        }
        catch (TransformationException transformationException) {
            throw new XMLSignatureException("empty", transformationException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public XMLSignatureInput getTransformsInput() throws ReferenceNotInitializedException {
        XMLSignatureInput xMLSignatureInput;
        XMLSignatureInput xMLSignatureInput2 = this.getContentsBeforeTransformation();
        try {
            xMLSignatureInput = new XMLSignatureInput(xMLSignatureInput2.getBytes());
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new ReferenceNotInitializedException("empty", canonicalizationException);
        }
        catch (IOException iOException) {
            throw new ReferenceNotInitializedException("empty", iOException);
        }
        xMLSignatureInput.setSourceURI(xMLSignatureInput2.getSourceURI());
        return xMLSignatureInput;
    }

    public XMLSignatureInput getTransformsOutput() {
        return this._transformsOutput;
    }

    public Transforms getTransforms() throws XMLSignatureException, InvalidTransformException, TransformationException, XMLSecurityException {
        Element element = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "Transforms", 0);
        if (element != null) {
            Transforms transforms = new Transforms(element, this._baseURI);
            return transforms;
        }
        return null;
    }

    public String getBaseLocalName() {
        return "Reference";
    }

    public String getHTMLRepresentation() throws XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput = this.getNodesetBeforeFirstCanonicalization();
            Set set = new HashSet();
            Transforms transforms = this.getTransforms();
            ElementProxy elementProxy = null;
            if (transforms != null) {
                int n = 0;
                while (n < transforms.getLength()) {
                    Transform transform = transforms.item(n);
                    String string = transform.getURI();
                    if (string.equals("http://www.w3.org/2001/10/xml-exc-c14n#") || string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) {
                        elementProxy = transform;
                        break;
                    }
                    ++n;
                }
            }
            if (elementProxy != null && elementProxy.length("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces") == 1) {
                InclusiveNamespaces inclusiveNamespaces = new InclusiveNamespaces(XMLUtils.selectNode(elementProxy.getElement().getFirstChild(), "http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces", 0), this.getBaseURI());
                set = InclusiveNamespaces.prefixStr2Set(inclusiveNamespaces.getInclusiveNamespaces());
            }
            return xMLSignatureInput.getHTMLRepresentation(set);
        }
        catch (TransformationException transformationException) {
            throw new XMLSignatureException("empty", transformationException);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new XMLSignatureException("empty", invalidTransformException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public String getType() {
        return this._constructionElement.getAttributeNS(null, "Type");
    }

    public String getURI() {
        return this._constructionElement.getAttributeNS(null, "URI");
    }

    public void setId(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "Id", string);
            IdResolver.registerElementById(this._constructionElement, string);
        }
    }

    public void setType(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "Type", string);
        }
    }

    public void setURI(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "URI", string);
        }
    }

    protected XMLSignatureInput dereferenceURIandPerformTransforms(OutputStream outputStream) throws XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput = this.getContentsBeforeTransformation();
            XMLSignatureInput xMLSignatureInput2 = this.getContentsAfterTransformation(xMLSignatureInput, outputStream);
            if (!CacheSignedNodes) {
                this._transformsOutput = xMLSignatureInput2;
            }
            return xMLSignatureInput2;
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new ReferenceNotInitializedException("empty", xMLSecurityException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Reference(Element element, String string, Manifest manifest) throws XMLSecurityException {
        super(element, string);
        this._manifest = manifest;
    }

    private XMLSignatureInput getContentsAfterTransformation(XMLSignatureInput xMLSignatureInput, OutputStream outputStream) throws XMLSignatureException {
        try {
            Transforms transforms = this.getTransforms();
            XMLSignatureInput xMLSignatureInput2 = null;
            if (transforms != null) {
                this._transformsOutput = xMLSignatureInput2 = transforms.performTransforms(xMLSignatureInput, outputStream);
            } else {
                xMLSignatureInput2 = xMLSignatureInput;
            }
            return xMLSignatureInput2;
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new XMLSignatureException("empty", resourceResolverException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new XMLSignatureException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLSignatureException("empty", invalidCanonicalizerException);
        }
        catch (TransformationException transformationException) {
            throw new XMLSignatureException("empty", transformationException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    protected Reference(Document document, String string, String string2, Manifest manifest, Transforms transforms, String string3) throws XMLSignatureException {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._baseURI = string;
        this._manifest = manifest;
        this.setURI(string2);
        if (transforms != null) {
            this._constructionElement.appendChild(transforms.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        Object object = MessageDigestAlgorithm.getInstance(this._doc, string3);
        this._constructionElement.appendChild(((ElementProxy)object).getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        object = XMLUtils.createElementInSignatureSpace(this._doc, "DigestValue");
        this._constructionElement.appendChild((Node)object);
        XMLUtils.addReturnToElement(this._constructionElement);
    }
}

