/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.InvalidTransformException;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Transforms
extends SignatureElementProxy {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$transforms$Transforms == null ? (class$com$sun$org$apache$xml$internal$security$transforms$Transforms = Transforms.class$("com.sun.org.apache.xml.internal.security.transforms.Transforms")) : class$com$sun$org$apache$xml$internal$security$transforms$Transforms).getName());
    public static final String TRANSFORM_C14N_OMIT_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String TRANSFORM_C14N_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String TRANSFORM_C14N_EXCL_OMIT_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String TRANSFORM_C14N_EXCL_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String TRANSFORM_XSLT = "http://www.w3.org/TR/1999/REC-xslt-19991116";
    public static final String TRANSFORM_BASE64_DECODE = "http://www.w3.org/2000/09/xmldsig#base64";
    public static final String TRANSFORM_XPATH = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    public static final String TRANSFORM_ENVELOPED_SIGNATURE = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    public static final String TRANSFORM_XPOINTER = "http://www.w3.org/TR/2001/WD-xptr-20010108";
    public static final String TRANSFORM_XPATH2FILTER04 = "http://www.w3.org/2002/04/xmldsig-filter2";
    public static final String TRANSFORM_XPATH2FILTER = "http://www.w3.org/2002/06/xmldsig-filter2";
    public static final String TRANSFORM_XPATHFILTERCHGP = "http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/#xpathFilter";
    Element[] transforms;
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$transforms$Transforms;

    public int getLength() {
        if (this.transforms == null) {
            this.transforms = XMLUtils.selectDsNodes(this._constructionElement.getFirstChild(), "Transform");
        }
        return this.transforms.length;
    }

    public Transform item(int n) throws TransformationException {
        try {
            if (this.transforms == null) {
                this.transforms = XMLUtils.selectDsNodes(this._constructionElement.getFirstChild(), "Transform");
            }
            return new Transform(this.transforms[n], this._baseURI);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new TransformationException("empty", xMLSecurityException);
        }
    }

    private void addTransform(Transform transform) {
        log.log(Level.FINE, "Transforms.addTransform(" + transform.getURI() + ")");
        Element element = transform.getElement();
        this._constructionElement.appendChild(element);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public String getBaseLocalName() {
        return "Transforms";
    }

    public void addTransform(String string) throws TransformationException {
        try {
            log.log(Level.FINE, "Transforms.addTransform(" + string + ")");
            Transform transform = Transform.getInstance(this._doc, string);
            this.addTransform(transform);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new TransformationException("empty", invalidTransformException);
        }
    }

    public Transforms(Document document) {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public XMLSignatureInput performTransforms(XMLSignatureInput xMLSignatureInput) throws TransformationException {
        return this.performTransforms(xMLSignatureInput, null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Transforms(Element element, String string) throws DOMException, XMLSignatureException, InvalidTransformException, TransformationException, XMLSecurityException {
        super(element, string);
        int n = this.getLength();
        if (n == 0) {
            Object[] objectArray = new Object[]{"Transform", "Transforms"};
            throw new TransformationException("xml.WrongContent", objectArray);
        }
    }

    public void addTransform(String string, Element element) throws TransformationException {
        try {
            log.log(Level.FINE, "Transforms.addTransform(" + string + ")");
            Transform transform = Transform.getInstance(this._doc, string, element);
            this.addTransform(transform);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new TransformationException("empty", invalidTransformException);
        }
    }

    public void addTransform(String string, NodeList nodeList) throws TransformationException {
        try {
            Transform transform = Transform.getInstance(this._doc, string, nodeList);
            this.addTransform(transform);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new TransformationException("empty", invalidTransformException);
        }
    }

    public XMLSignatureInput performTransforms(XMLSignatureInput xMLSignatureInput, OutputStream outputStream) throws TransformationException {
        try {
            int n = this.getLength();
            int n2 = n - 1;
            int n3 = 0;
            while (n3 < n) {
                Transform transform = this.item(n3);
                log.log(Level.FINE, "Preform the (" + n3 + ")th " + transform.getURI() + " transform");
                xMLSignatureInput = n3 == n2 ? transform.performTransform(xMLSignatureInput, outputStream) : transform.performTransform(xMLSignatureInput);
                ++n3;
            }
            return xMLSignatureInput;
        }
        catch (IOException iOException) {
            throw new TransformationException("empty", iOException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new TransformationException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new TransformationException("empty", invalidCanonicalizerException);
        }
    }
}

