/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.I18n;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class Base64 {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$utils$Base64 == null ? (class$com$sun$org$apache$xml$internal$security$utils$Base64 = Base64.class$("com.sun.org.apache.xml.internal.security.utils.Base64")) : class$com$sun$org$apache$xml$internal$security$utils$Base64).getName());
    public static final int BASE64DEFAULTLENGTH = 76;
    static int _base64length = 76;
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int FOURBYTE = 4;
    private static final int SIGN = -128;
    private static final char PAD = '=';
    private static final boolean fDebug = false;
    private static final byte[] base64Alphabet = new byte[255];
    private static final char[] lookUpBase64Alphabet = new char[64];
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$utils$Base64;

    static {
        int n = 0;
        while (n < 255) {
            Base64.base64Alphabet[n] = -1;
            ++n;
        }
        int n2 = 90;
        while (n2 >= 65) {
            Base64.base64Alphabet[n2] = (byte)(n2 - 65);
            --n2;
        }
        int n3 = 122;
        while (n3 >= 97) {
            Base64.base64Alphabet[n3] = (byte)(n3 - 97 + 26);
            --n3;
        }
        int n4 = 57;
        while (n4 >= 48) {
            Base64.base64Alphabet[n4] = (byte)(n4 - 48 + 52);
            --n4;
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        int n5 = 0;
        while (n5 <= 25) {
            Base64.lookUpBase64Alphabet[n5] = (char)(65 + n5);
            ++n5;
        }
        int n6 = 26;
        int n7 = 0;
        while (n6 <= 51) {
            Base64.lookUpBase64Alphabet[n6] = (char)(97 + n7);
            ++n6;
            ++n7;
        }
        int n8 = 52;
        int n9 = 0;
        while (n8 <= 61) {
            Base64.lookUpBase64Alphabet[n8] = (char)(48 + n9);
            ++n8;
            ++n9;
        }
        Base64.lookUpBase64Alphabet[62] = 43;
        Base64.lookUpBase64Alphabet[63] = 47;
    }

    private Base64() {
    }

    protected static final boolean isData(byte by) {
        return base64Alphabet[by] != -1;
    }

    protected static final boolean isPad(byte by) {
        return by == 61;
    }

    protected static final boolean isWhiteSpace(byte by) {
        return by == 32 || by == 13 || by == 10 || by == 9;
    }

    protected static int removeWhiteSpace(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = 0;
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray[n3];
            if (!Base64.isWhiteSpace(by)) {
                byArray[n++] = by;
            }
            ++n3;
        }
        return n;
    }

    public static byte[] decode(byte[] byArray) throws Base64DecodingException {
        return Base64.decodeInternal(byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static final byte[] decodeInternal(byte[] byArray) throws Base64DecodingException {
        int n = Base64.removeWhiteSpace(byArray);
        if (n % 4 != 0) {
            throw new Base64DecodingException("It should be dived by four");
        }
        int n2 = n / 4;
        if (n2 == 0) {
            return new byte[0];
        }
        byte[] byArray2 = null;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        byte by8 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n5 = (n2 - 1) * 4;
        n4 = (n2 - 1) * 3;
        if (!Base64.isData(by5 = byArray[n5++]) || !Base64.isData(by6 = byArray[n5++])) {
            throw new Base64DecodingException("decoding.general");
        }
        by = base64Alphabet[by5];
        by2 = base64Alphabet[by6];
        by7 = byArray[n5++];
        by8 = byArray[n5++];
        if (!Base64.isData(by7) || !Base64.isData(by8)) {
            if (Base64.isPad(by7) && Base64.isPad(by8)) {
                if ((by2 & 0xF) != 0) {
                    throw new Base64DecodingException("decoding.general");
                }
                byArray2 = new byte[n4 + 1];
                byArray2[n4] = (byte)(by << 2 | by2 >> 4);
            } else {
                if (Base64.isPad(by7) || !Base64.isPad(by8)) throw new Base64DecodingException("decoding.general");
                by3 = base64Alphabet[by7];
                if ((by3 & 3) != 0) {
                    throw new Base64DecodingException("decoding.general");
                }
                byArray2 = new byte[n4 + 2];
                byArray2[n4++] = (byte)(by << 2 | by2 >> 4);
                byArray2[n4] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
            }
        } else {
            byArray2 = new byte[n4 + 3];
            by3 = base64Alphabet[by7];
            by4 = base64Alphabet[by8];
            byArray2[n4++] = (byte)(by << 2 | by2 >> 4);
            byArray2[n4++] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
            byArray2[n4++] = (byte)(by3 << 6 | by4);
        }
        n4 = 0;
        n5 = 0;
        while (n3 < n2 - 1) {
            if (!(Base64.isData(by5 = byArray[n5++]) && Base64.isData(by6 = byArray[n5++]) && Base64.isData(by7 = byArray[n5++]) && Base64.isData(by8 = byArray[n5++]))) {
                throw new Base64DecodingException("decoding.general");
            }
            by = base64Alphabet[by5];
            by2 = base64Alphabet[by6];
            by3 = base64Alphabet[by7];
            by4 = base64Alphabet[by8];
            byArray2[n4++] = (byte)(by << 2 | by2 >> 4);
            byArray2[n4++] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
            byArray2[n4++] = (byte)(by3 << 6 | by4);
            ++n3;
        }
        return byArray2;
    }

    public static byte[] decode(BufferedReader bufferedReader) throws IOException, Base64DecodingException {
        String string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (null != (string = bufferedReader.readLine())) {
            byte[] byArray = Base64.decode(string);
            byteArrayOutputStream.write(byArray);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void decode(byte[] byArray, OutputStream outputStream) throws Base64DecodingException, IOException {
        int n = Base64.removeWhiteSpace(byArray);
        if (n % 4 != 0) {
            throw new Base64DecodingException("It should be dived by four");
        }
        int n2 = n / 4;
        if (n2 == 0) {
            return;
        }
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        byte by8 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2 - 1) {
            if (!(Base64.isData(by5 = byArray[n4++]) && Base64.isData(by6 = byArray[n4++]) && Base64.isData(by7 = byArray[n4++]) && Base64.isData(by8 = byArray[n4++]))) {
                throw new Base64DecodingException("decoding.general");
            }
            by = base64Alphabet[by5];
            by2 = base64Alphabet[by6];
            by3 = base64Alphabet[by7];
            by4 = base64Alphabet[by8];
            outputStream.write((byte)(by << 2 | by2 >> 4));
            outputStream.write((byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF));
            outputStream.write((byte)(by3 << 6 | by4));
            ++n3;
        }
        if (!Base64.isData(by5 = byArray[n4++]) || !Base64.isData(by6 = byArray[n4++])) {
            throw new Base64DecodingException("decoding.general");
        }
        by = base64Alphabet[by5];
        by2 = base64Alphabet[by6];
        by7 = byArray[n4++];
        by8 = byArray[n4++];
        if (!Base64.isData(by7) || !Base64.isData(by8)) {
            if (Base64.isPad(by7) && Base64.isPad(by8)) {
                if ((by2 & 0xF) != 0) {
                    throw new Base64DecodingException("decoding.general");
                }
                outputStream.write((byte)(by << 2 | by2 >> 4));
                return;
            } else {
                if (Base64.isPad(by7) || !Base64.isPad(by8)) throw new Base64DecodingException("decoding.general");
                by3 = base64Alphabet[by7];
                if ((by3 & 3) != 0) {
                    throw new Base64DecodingException("decoding.general");
                }
                outputStream.write((byte)(by << 2 | by2 >> 4));
                outputStream.write((byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF));
            }
            return;
        } else {
            by3 = base64Alphabet[by7];
            by4 = base64Alphabet[by8];
            outputStream.write((byte)(by << 2 | by2 >> 4));
            outputStream.write((byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF));
            outputStream.write((byte)(by3 << 6 | by4));
        }
    }

    public static final byte[] decode(String string) throws Base64DecodingException {
        if (string == null) {
            return null;
        }
        return Base64.decodeInternal(string.getBytes());
    }

    public static String encode(byte[] byArray) {
        return Base64.encode(byArray, 76);
    }

    public static String encode(byte[] byArray, int n) {
        byte by;
        byte by2;
        int n2;
        if (n < 4) {
            n = Integer.MAX_VALUE;
        }
        if (byArray == null) {
            return null;
        }
        int n3 = byArray.length * 8;
        if (n3 == 0) {
            return "";
        }
        int n4 = n3 % 24;
        int n5 = n3 / 24;
        int n6 = n4 != 0 ? n5 + 1 : n5;
        int n7 = n / 4;
        int n8 = (n6 - 1) / n7;
        char[] cArray = null;
        cArray = new char[n6 * 4 + n8];
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n12 < n8) {
            n2 = 0;
            while (n2 < 19) {
                by5 = byArray[n10++];
                by6 = byArray[n10++];
                by7 = byArray[n10++];
                by4 = (byte)(by6 & 0xF);
                by3 = (byte)(by5 & 3);
                by2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
                by = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
                byte by8 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 6) : (byte)(by7 >> 6 ^ 0xFC);
                cArray[n9++] = lookUpBase64Alphabet[by2];
                cArray[n9++] = lookUpBase64Alphabet[by | by3 << 4];
                cArray[n9++] = lookUpBase64Alphabet[by4 << 2 | by8];
                cArray[n9++] = lookUpBase64Alphabet[by7 & 0x3F];
                ++n11;
                ++n2;
            }
            cArray[n9++] = 10;
            ++n12;
        }
        while (n11 < n5) {
            by5 = byArray[n10++];
            by6 = byArray[n10++];
            by7 = byArray[n10++];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            n2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            by2 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            by = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 6) : (byte)(by7 >> 6 ^ 0xFC);
            cArray[n9++] = lookUpBase64Alphabet[n2];
            cArray[n9++] = lookUpBase64Alphabet[by2 | by3 << 4];
            cArray[n9++] = lookUpBase64Alphabet[by4 << 2 | by];
            cArray[n9++] = lookUpBase64Alphabet[by7 & 0x3F];
            ++n11;
        }
        if (n4 == 8) {
            by5 = byArray[n10];
            by3 = (byte)(by5 & 3);
            n2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            cArray[n9++] = lookUpBase64Alphabet[n2];
            cArray[n9++] = lookUpBase64Alphabet[by3 << 4];
            cArray[n9++] = 61;
            cArray[n9++] = 61;
        } else if (n4 == 16) {
            by5 = byArray[n10];
            by6 = byArray[n10 + 1];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            n2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            by2 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            cArray[n9++] = lookUpBase64Alphabet[n2];
            cArray[n9++] = lookUpBase64Alphabet[by2 | by3 << 4];
            cArray[n9++] = lookUpBase64Alphabet[by4 << 2];
            cArray[n9++] = 61;
        }
        return new String(cArray);
    }

    public static void main(String[] stringArray) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        String string = "<container><base64 value=\"Should be 'Hallo'\">SGFsbG8=</base64></container>";
        InputSource inputSource = new InputSource(new StringReader(string));
        Document document = documentBuilder.parse(inputSource);
        Element element = (Element)document.getDocumentElement().getChildNodes().item(0);
        System.out.println(new String(Base64.decode(element)));
    }

    public static byte[] encode(BigInteger bigInteger, int n) {
        if ((n = n + 7 >> 3 << 3) < bigInteger.bitLength()) {
            throw new IllegalArgumentException(I18n.translate("utils.Base64.IllegalBitlength"));
        }
        byte[] byArray = bigInteger.toByteArray();
        if (bigInteger.bitLength() % 8 != 0 && bigInteger.bitLength() / 8 + 1 == n / 8) {
            return byArray;
        }
        int n2 = 0;
        int n3 = byArray.length;
        if (bigInteger.bitLength() % 8 == 0) {
            n2 = 1;
            --n3;
        }
        int n4 = n / 8 - n3;
        byte[] byArray2 = new byte[n / 8];
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        return byArray2;
    }

    static byte[] getBytes(BigInteger bigInteger, int n) {
        if ((n = n + 7 >> 3 << 3) < bigInteger.bitLength()) {
            throw new IllegalArgumentException(I18n.translate("utils.Base64.IllegalBitlength"));
        }
        byte[] byArray = bigInteger.toByteArray();
        if (bigInteger.bitLength() % 8 != 0 && bigInteger.bitLength() / 8 + 1 == n / 8) {
            return byArray;
        }
        int n2 = 0;
        int n3 = byArray.length;
        if (bigInteger.bitLength() % 8 == 0) {
            n2 = 1;
            --n3;
        }
        int n4 = n / 8 - n3;
        byte[] byArray2 = new byte[n / 8];
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        return byArray2;
    }

    public static byte[] decode(Element element) throws Base64DecodingException {
        Node node = element.getFirstChild();
        StringBuffer stringBuffer = new StringBuffer();
        while (node != null) {
            if (node.getNodeType() == 3) {
                Text text = (Text)node;
                stringBuffer.append(text.getData());
            }
            node = node.getNextSibling();
        }
        return Base64.decode(stringBuffer.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void decode(InputStream inputStream, OutputStream outputStream) throws Base64DecodingException, IOException {
        byte by;
        int n;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        int n2 = 0;
        byte[] byArray = new byte[4];
        while ((n = inputStream.read()) > 0) {
            by = (byte)n;
            if (Base64.isWhiteSpace(by)) continue;
            if (Base64.isPad(by)) {
                byArray[n2++] = by;
                if (n2 != 3) break;
                byArray[n2++] = (byte)inputStream.read();
                break;
            }
            if (!Base64.isData(by)) {
                throw new Base64DecodingException("decoding.general");
            }
            byArray[n2++] = by;
            if (n2 != 4) continue;
            n2 = 0;
            by2 = base64Alphabet[byArray[0]];
            by3 = base64Alphabet[byArray[1]];
            by4 = base64Alphabet[byArray[2]];
            by5 = base64Alphabet[byArray[3]];
            outputStream.write((byte)(by2 << 2 | by3 >> 4));
            outputStream.write((byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF));
            outputStream.write((byte)(by4 << 6 | by5));
        }
        by = byArray[0];
        byte by6 = byArray[1];
        byte by7 = byArray[2];
        byte by8 = byArray[3];
        by2 = base64Alphabet[by];
        by3 = base64Alphabet[by6];
        if (!Base64.isData(by7) || !Base64.isData(by8)) {
            if (Base64.isPad(by7) && Base64.isPad(by8)) {
                if ((by3 & 0xF) != 0) {
                    throw new Base64DecodingException("decoding.general");
                }
                outputStream.write((byte)(by2 << 2 | by3 >> 4));
                return;
            } else {
                if (Base64.isPad(by7) || !Base64.isPad(by8)) throw new Base64DecodingException("decoding.general");
                by4 = base64Alphabet[by7];
                if ((by4 & 3) != 0) {
                    throw new Base64DecodingException("decoding.general");
                }
                outputStream.write((byte)(by2 << 2 | by3 >> 4));
                outputStream.write((byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF));
            }
            return;
        } else {
            by4 = base64Alphabet[by7];
            by5 = base64Alphabet[by8];
            outputStream.write((byte)(by2 << 2 | by3 >> 4));
            outputStream.write((byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF));
            outputStream.write((byte)(by4 << 6 | by5));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static String encode(BigInteger bigInteger) {
        return Base64.encode(Base64.getBytes(bigInteger, bigInteger.bitLength()));
    }

    public static BigInteger decodeBigIntegerFromElement(Element element) throws Base64DecodingException {
        return new BigInteger(1, Base64.decode(element));
    }

    public static void fillElementWithBigInteger(Element element, BigInteger bigInteger) {
        String string = Base64.encode(bigInteger);
        if (string.length() > 76) {
            string = "\n" + string + "\n";
        }
        Document document = element.getOwnerDocument();
        Text text = document.createTextNode(string);
        element.appendChild(text);
    }

    public static BigInteger decodeBigIntegerFromText(Text text) throws Base64DecodingException {
        return new BigInteger(1, Base64.decode(text.getData()));
    }

    public static Element encodeToElement(Document document, String string, byte[] byArray) {
        Element element = XMLUtils.createElementInSignatureSpace(document, string);
        Text text = document.createTextNode(Base64.encode(byArray));
        element.appendChild(text);
        return element;
    }
}

