/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver.implementations;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.CachedXPathAPIHolder;
import com.sun.org.apache.xml.internal.security.utils.IdResolver;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import com.sun.org.apache.xml.internal.utils.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResolverXPointer
extends ResourceResolverSpi {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$internal$security$utils$resolver$implementations$ResolverXPointer == null ? (class$com$sun$org$apache$xml$internal$security$utils$resolver$implementations$ResolverXPointer = ResolverXPointer.class$("com.sun.org.apache.xml.internal.security.utils.resolver.implementations.ResolverXPointer")) : class$com$sun$org$apache$xml$internal$security$utils$resolver$implementations$ResolverXPointer).getName());
    static /* synthetic */ Class class$com$sun$org$apache$xml$internal$security$utils$resolver$implementations$ResolverXPointer;

    private static boolean isXPointerId(Attr attr) {
        String string;
        String string2 = attr.getNodeValue();
        if (string2.startsWith("#xpointer(id(") && string2.endsWith("))") && ((string = string2.substring("#xpointer(id(".length(), string2.length() - "))".length())).charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"' || string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'')) {
            log.log(Level.FINE, "Id=" + string.substring(1, string.length() - 1));
            return true;
        }
        return false;
    }

    private static boolean isXPointerSlash(Attr attr) {
        return attr.getNodeValue().equals("#xpointer(/)");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static String getXPointerId(Attr attr) {
        String string;
        String string2 = attr.getNodeValue();
        if (string2.startsWith("#xpointer(id(") && string2.endsWith("))") && ((string = string2.substring("#xpointer(id(".length(), string2.length() - "))".length())).charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"' || string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'')) {
            return string.substring(1, string.length() - 1);
        }
        return null;
    }

    public boolean engineCanResolve(Attr attr, String string) {
        if (attr == null) {
            return false;
        }
        return ResolverXPointer.isXPointerSlash(attr) || ResolverXPointer.isXPointerId(attr);
    }

    public XMLSignatureInput engineResolve(Attr attr, String string) throws ResourceResolverException {
        Object object;
        Node node = null;
        Document document = attr.getOwnerElement().getOwnerDocument();
        if (ResolverXPointer.isXPointerSlash(attr)) {
            node = document;
        } else if (ResolverXPointer.isXPointerId(attr) && (node = IdResolver.getElementById(document, (String)(object = ResolverXPointer.getXPointerId(attr)))) == null) {
            Object[] objectArray = new Object[]{object};
            throw new ResourceResolverException("signature.Verification.MissingID", objectArray, attr, string);
        }
        CachedXPathAPIHolder.setDoc(document);
        object = new XMLSignatureInput(node);
        ((XMLSignatureInput)object).setMIMEType("text/xml");
        try {
            URI uRI = new URI(new URI(string), attr.getNodeValue());
            ((XMLSignatureInput)object).setSourceURI(uRI.toString());
        }
        catch (URI.MalformedURIException malformedURIException) {
            ((XMLSignatureInput)object).setSourceURI(string);
        }
        return object;
    }
}

