/*
 * Decompiled with CFR 0.152.
 */
package SecurePackaging;

import SecurePackaging.GWCRLVerificationFailException;
import SecurePackaging.GWInvalidateEnvelopedDataException;
import SecurePackaging.GWInvalidateSignatureException;
import SecurePackaging.GWInvalidateSignedDataException;
import SecurePackaging.GWSignatureSigningFailException;
import SecurePackaging.P7SecurePackager;
import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import th.co.oga.security.pki.CMS.CMSIssuerAndSerialNumber;
import th.co.oga.security.pki.CMS.CMSSignatureVerifyException;
import th.co.oga.security.pki.CMS.CMSSignedData;
import th.co.oga.security.pki.CMS.CMSSignerInfoNotValidateException;
import th.co.oga.security.pki.Certification.CertPackageException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.HouseKeeping.HouseKeeper;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.HouseKeeping.SaveHouse;
import th.co.oga.security.pki.Packaging.CMSPackager;
import th.co.oga.security.pki.Packaging.RawEnvelopedData;
import th.co.oga.security.pki.Packaging.RawSignedData;
import th.co.oga.security.pki.Packaging.RawSignerInfo;
import th.co.oga.security.pki.Packaging.SecurePackageCRLException;
import th.co.oga.security.pki.Packaging.SecurePackageInvalidDataException;
import th.co.oga.security.pki.Packaging.SecurePackageVerifyFailException;
import th.co.oga.security.pki.Packaging.SecurePackager;
import th.co.oga.security.pki.PinCode;
import th.co.oga.security.pki.SMIME.SMIMEContentType;
import th.co.oga.security.pki.SMIME.SMIMEPackager;
import th.co.oga.security.pki.Trusted.Authority;
import th.co.oga.security.pki.Utils;
import th.co.oga.security.pki.X500.DName;
import th.co.oga.security.pki.XML.XMLSecurePackager;

public class GWInterface {
    private static Room room;
    private static SecurePackager packager;
    private static XMLSecurePackager xmlPackager;
    private static CMSPackager cmsPackager;
    private static SMIMEPackager smimePackager;
    private static String encodding;
    private static boolean cRLVerification;
    private static boolean booted;
    public static String TAXID_PREFIX;
    public static String DATA_CONTENT_TYPE;
    public static Logger logger;

    static {
        encodding = "iso-8859-1";
        cRLVerification = true;
        booted = false;
        TAXID_PREFIX = "TAXID:";
        DATA_CONTENT_TYPE = "text/xml";
    }

    public static void startProcess(byte[] arg1, int[] arg2, double[] arg3, String[] args, Object[] returner) {
        try {
            GWInterface.TraceInfo("GWInterface Start");
            if (!GWInterface.verifyParam(args, 1, returner)) {
                return;
            }
            String agentId = args[0];
            String passwd = args[1];
            cRLVerification = false;
            if (args.length > 2 && args[2] != null && args[2].equalsIgnoreCase("CRLVerification")) {
                cRLVerification = true;
            }
            System.out.println("CRYPTOGA: System startup request " + Utils.getWacthTime());
            if (!booted) {
                try {
                    HouseKeeper keeper = new HouseKeeper();
                    room = keeper.reserveRoom(agentId);
                    PinCode lockPin1 = new PinCode(new String(passwd));
                    room.open(lockPin1);
                }
                catch (Exception e) {
                    returner[2] = new String[]{"505", GWInterface.getErrorString(e)};
                    return;
                }
                try {
                    packager = new P7SecurePackager(room);
                    xmlPackager = new XMLSecurePackager(room);
                    cmsPackager = new CMSPackager(room);
                    smimePackager = new SMIMEPackager(room);
                }
                catch (Exception e) {
                    returner[2] = new String[]{"506", GWInterface.getErrorString(e)};
                    return;
                }
                returner[2] = new String[]{"0", "Successfully start GWInterface module"};
                booted = true;
            } else {
                returner[2] = new String[]{"0", "Successfully start GWInterface module with warning, GWInterface existing start."};
            }
            System.out.println("CRYPTOGA: System startup response " + Utils.getWacthTime());
            GWInterface.TraceInfo("GWInterface was successfully start");
            return;
        }
        catch (Exception e) {
            GWInterface.TraceInfo("GWInterface Start Fail," + e.toString());
            return;
        }
    }

    public static void TraceInfo(String message) {
        if (logger == null) {
            String pattern = "%d\t%p\t%m\t%n";
            PatternLayout layout = new PatternLayout(pattern);
            try {
                logger = Logger.getLogger((String)"GatwayInterface");
                logger.addAppender((Appender)new FileAppender((Layout)layout, String.valueOf(SaveHouse.getSysBase()) + SaveHouse.FS + "bin" + SaveHouse.FS + "GWInterface.log", true));
            }
            catch (IOException e1) {
                logger = null;
            }
        }
        if (logger != null) {
            logger.info((Object)message);
        }
    }

    public static void stopProcess(byte[] arg1, int[] arg2, double[] arg3, String[] args, Object[] returner) {
        System.out.println("CRYPTOGA: System stop request " + Utils.getWacthTime());
        returner[2] = new String[]{"0", "Successfully stop,warnning system do not implement stop processing."};
        System.out.println("CRYPTOGA: System stop response " + Utils.getWacthTime());
    }

    public static void cryptoProcess(byte[] arg1, int[] arg2, double[] arg3, String[] args, Object[] returner) {
        GWInterface.openEnvelopeAndVerifyProcess(arg1, arg2, arg3, args, returner);
    }

    public static void openEnvelopeAndVerifyProcess(byte[] arg1, int[] arg2, double[] arg3, String[] args, Object[] returner) {
        byte[] data;
        if (!booted) {
            returner[2] = new String[]{"511", "PKI System not booted yet."};
            return;
        }
        if (!GWInterface.verifyParam(args, 1, returner)) {
            return;
        }
        try {
            data = args[0].getBytes(encodding);
            GWInterface.changeSecurePackager(args[0]);
        }
        catch (Exception e) {
            returner[2] = new String[]{"503", "Source data character encodding fail, " + e.toString()};
            return;
        }
        if (args.length == 2) {
            GWInterface.traceFile(args[1], data);
        }
        List rtns = null;
        try {
            rtns = GWInterface.openEnvelopeAndVerifyProcess(data);
        }
        catch (Exception e) {
            returner[2] = new String[]{"507", GWInterface.getErrorString(e)};
            return;
        }
        try {
            int maxLen = Math.max(8, rtns.size() + 1);
            String[] rtn = new String[maxLen];
            rtn[0] = "0";
            int i = 0;
            while (i < maxLen - 1) {
                rtn[i + 1] = i < rtns.size() ? new String((byte[])rtns.get(i), encodding) : new String("");
                ++i;
            }
            returner[2] = rtn;
        }
        catch (Exception e) {
            returner[2] = new String[]{"502", "Error while pack the return result, " + e.toString()};
        }
    }

    public static void verifyProcess(byte[] arg1, int[] arg2, double[] arg3, String[] args, Object[] returner) {
        byte[] data;
        if (!booted) {
            returner[2] = new String[]{"511", "PKI System not booted yet."};
            return;
        }
        if (!GWInterface.verifyParam(args, 1, returner)) {
            return;
        }
        try {
            data = args[0].getBytes(encodding);
            GWInterface.changeSecurePackager(args[0]);
        }
        catch (Exception e) {
            returner[2] = new String[]{"503", "Source data character encodding fail, " + e.toString()};
            return;
        }
        if (args.length == 2) {
            GWInterface.traceFile(args[1], data);
        }
        List rtns = null;
        try {
            rtns = GWInterface.verifyProcess(data);
        }
        catch (GWInvalidateSignatureException e) {
            returner[2] = new String[]{"521", GWInterface.getErrorString(e)};
            return;
        }
        catch (GWCRLVerificationFailException e) {
            returner[2] = new String[]{"522", GWInterface.getErrorString(e)};
            return;
        }
        catch (Exception e) {
            returner[2] = new String[]{"507", GWInterface.getErrorString(e)};
            return;
        }
        try {
            int maxLen = Math.max(8, rtns.size() + 1);
            String[] rtn = new String[maxLen];
            rtn[0] = "0";
            int i = 0;
            while (i < maxLen - 1) {
                rtn[i + 1] = i < rtns.size() ? new String((byte[])rtns.get(i), encodding) : new String("");
                ++i;
            }
            returner[2] = rtn;
        }
        catch (Exception e) {
            returner[2] = new String[]{"502", "Error while pack the return result, " + e.toString()};
        }
    }

    public static void openEnvelopeProcess(byte[] arg1, int[] arg2, double[] arg3, String[] args, Object[] returner) {
        byte[] data;
        if (!booted) {
            returner[2] = new String[]{"511", "PKI System not booted yet."};
            return;
        }
        if (!GWInterface.verifyParam(args, 1, returner)) {
            return;
        }
        try {
            data = args[0].getBytes(encodding);
            GWInterface.changeSecurePackager(args[0]);
        }
        catch (Exception e) {
            returner[2] = new String[]{"503", "Source data character encodding fail, " + e.toString()};
            return;
        }
        if (args.length == 2) {
            GWInterface.traceFile(args[1], data);
        }
        List rtns = null;
        try {
            rtns = GWInterface.openEnvelopeProcess(data);
        }
        catch (Exception e) {
            returner[2] = new String[]{"507", GWInterface.getErrorString(e)};
            return;
        }
        try {
            String[] rtn = new String[rtns.size() + 1];
            rtn[0] = "0";
            int i = 0;
            while (i < rtns.size()) {
                rtn[i + 1] = new String((byte[])rtns.get(i), encodding);
                ++i;
            }
            returner[2] = rtn;
        }
        catch (Exception e) {
            returner[2] = new String[]{"502", "Error while pack the return result, " + e.toString()};
        }
    }

    public static void signingProcess(byte[] arg1, int[] arg2, double[] arg3, String[] args, Object[] returner) throws GWInvalidateEnvelopedDataException, GWInvalidateSignedDataException, GWCRLVerificationFailException, GWInvalidateSignatureException {
        byte[] data;
        if (!booted) {
            returner[2] = new String[]{"511", "PKI System not booted yet."};
            return;
        }
        if (!GWInterface.verifyParam(args, 1, returner)) {
            return;
        }
        try {
            data = args[0].getBytes(encodding);
            GWInterface.changeSecurePackager(args[0]);
        }
        catch (Exception e) {
            returner[2] = new String[]{"503", "Source data character encodding fail, " + e.toString()};
            return;
        }
        if (args.length == 2) {
            GWInterface.traceFile(args[1], data);
        }
        List rtns = null;
        try {
            rtns = GWInterface.signingProcess(data);
        }
        catch (Exception e) {
            returner[2] = new String[]{"508", GWInterface.getErrorString(e)};
            return;
        }
        try {
            String[] rtn = new String[rtns.size() + 1];
            rtn[0] = "0";
            int i = 0;
            while (i < rtns.size()) {
                rtn[i + 1] = new String((byte[])rtns.get(i), encodding);
                ++i;
            }
            returner[2] = rtn;
        }
        catch (Exception e) {
            returner[2] = new String[]{"502", "Error while pack the return result, " + GWInterface.getErrorString(e)};
        }
    }

    public static void envelopeProcess(byte[] arg1, int[] arg2, double[] arg3, String[] args, Object[] returner) throws GWInvalidateEnvelopedDataException, GWInvalidateSignedDataException, GWCRLVerificationFailException, GWInvalidateSignatureException {
        GWInterface.signAndEnvelopeProcess(arg1, arg2, arg3, args, returner);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void signAndEnvelopeProcess(byte[] arg1, int[] arg2, double[] arg3, String[] args, Object[] returner) throws GWInvalidateEnvelopedDataException, GWInvalidateSignedDataException, GWCRLVerificationFailException, GWInvalidateSignatureException {
        String[] vals;
        byte[] data;
        if (!booted) {
            returner[2] = new String[]{"511", "PKI System not booted yet."};
            return;
        }
        if (!GWInterface.verifyParam(args, 2, returner)) {
            return;
        }
        try {
            data = args[0].getBytes(encodding);
            GWInterface.changeSecurePackager(args[0]);
        }
        catch (Exception e) {
            returner[2] = new String[]{"503", "Source data character encodding fail, " + e.toString()};
            return;
        }
        String certID = args[1];
        String caName = null;
        X500Principal subj = null;
        String sn = null;
        GWInterface.TraceInfo("Determind the recipient name:" + certID);
        if (certID.indexOf(" - ") > -1 && (vals = certID.split(" - ")).length > 0) {
            caName = vals[0];
            if (vals.length > 1) {
                sn = vals[1];
            }
        }
        if (caName == null || sn == null) {
            returner[2] = new String[]{"504", "Supply certificate name is not correct, Certificate name must supply as:caName - SN"};
            return;
        }
        if (caName.length() < 12) {
            GWInterface.TraceInfo("Find authority:" + caName);
            Authority a = room.getCAList().getByNicName(caName);
            if (a == null) {
                returner[2] = new String[]{"532", "Authority finding fail," + caName + " not found in CA List."};
                return;
            }
            subj = a.getSubjectName();
        } else {
            subj = new X500Principal(caName);
        }
        if (args.length == 3) {
            GWInterface.traceFile(args[2], data);
        }
        CertProfile recpCert = null;
        try {
            recpCert = room.findCertificate(subj, sn);
            if (recpCert == null) {
                returner[2] = new String[]{"509", "Recipient certificate finding fail, certificate not found in store."};
                return;
            }
        }
        catch (Exception e) {
            returner[2] = new String[]{"509", "Recipient certificate finding fail, " + e.toString()};
            return;
        }
        List rtns = null;
        try {
            rtns = GWInterface.signingAndEnvelopeProcess(data, recpCert);
        }
        catch (Exception e) {
            returner[2] = new String[]{"508", GWInterface.getErrorString(e)};
            return;
        }
        try {
            String[] rtn = new String[rtns.size() + 1];
            rtn[0] = "0";
            int i = 0;
            while (true) {
                if (i >= rtns.size()) {
                    returner[2] = rtn;
                    return;
                }
                rtn[i + 1] = new String((byte[])rtns.get(i), encodding);
                ++i;
            }
        }
        catch (Exception e) {
            returner[2] = new String[]{"502", "Error while pack the return result, " + e.toString()};
        }
    }

    public static void envelopeProcessByCANicName(byte[] arg1, int[] arg2, double[] arg3, String[] args, Object[] returner) throws GWInvalidateEnvelopedDataException, GWInvalidateSignedDataException, GWCRLVerificationFailException, GWInvalidateSignatureException {
        String[] vals;
        byte[] data;
        if (!booted) {
            returner[2] = new String[]{"511", "PKI System not booted yet."};
            return;
        }
        if (!GWInterface.verifyParam(args, 2, returner)) {
            return;
        }
        try {
            data = args[0].getBytes(encodding);
            GWInterface.changeSecurePackager(args[0]);
        }
        catch (Exception e) {
            returner[2] = new String[]{"503", "Source data character encodding fail, " + e.toString()};
            return;
        }
        String certID = args[1];
        String caName = null;
        X500Principal subj = null;
        String sn = null;
        System.out.println("The supplied certificate name:" + certID);
        if (certID.indexOf(" - ") > -1 && (vals = certID.split(" - ")).length > 0) {
            caName = vals[0];
            if (vals.length > 1) {
                sn = vals[1];
            }
        }
        if (caName == null || sn == null) {
            returner[2] = new String[]{"504", "Supply certificate name is not correct, Certificate name must supply as:caName - SN"};
            return;
        }
        if (caName.length() < 12) {
            Authority a = room.getCAList().getByNicName(caName);
            if (a == null) {
                returner[2] = new String[]{"532", "Authority finding fail," + caName + " not found in CA List."};
                return;
            }
            subj = a.getSubjectName();
        } else {
            subj = new X500Principal(caName);
        }
        if (args.length == 3) {
            GWInterface.traceFile(args[2], data);
        }
        CertProfile recpCert = null;
        try {
            recpCert = room.findCertificate(subj, sn);
            if (recpCert == null) {
                returner[2] = new String[]{"509", "Recipient certificate finding fail, certificate not found in store."};
                return;
            }
        }
        catch (Exception e) {
            returner[2] = new String[]{"509", "Recipient certificate finding fail, " + e.toString()};
            return;
        }
        List rtns = null;
        try {
            rtns = GWInterface.envelopeProcess(data, recpCert);
        }
        catch (Exception e) {
            returner[2] = new String[]{"508", GWInterface.getErrorString(e)};
            return;
        }
        try {
            String[] rtn = new String[rtns.size() + 1];
            rtn[0] = "0";
            int i = 0;
            while (i < rtns.size()) {
                rtn[i + 1] = new String((byte[])rtns.get(i), encodding);
                ++i;
            }
            returner[2] = rtn;
        }
        catch (Exception e) {
            returner[2] = new String[]{"502", "Error while pack the return result, " + e.toString()};
        }
    }

    public static void changeSecurePackager(String data) {
        packager = xmlPackager;
    }

    public static void openSmime(byte[] arg1, int[] arg2, double[] arg3, String[] args, Object[] returner) {
        byte[] data;
        block19: {
            if (!GWInterface.verifyParam(args, 1, returner)) {
                return;
            }
            data = null;
            try {
                data = args[0].getBytes(encodding);
            }
            catch (Exception e) {
                returner[2] = new String[]{"503", "Source data character encodding fail, " + e.toString()};
                return;
            }
            try {
                MimeBodyPart msgBodyPart = SMIMEPackager.loadMessage((byte[])data);
                SMIMEContentType contentType = new SMIMEContentType(msgBodyPart.getContentType());
                if (SMIMEContentType.isInLength((SMIMEContentType)contentType)) {
                    if (SMIMEContentType.isInSigningLength((SMIMEContentType)contentType)) {
                        CMSSignedData signedData = smimePackager.getSignedData(msgBodyPart, contentType);
                        try {
                            smimePackager.sMimeVerify(signedData);
                            MimeBodyPart dataPart = SMIMEPackager.getMessageContent((CMSSignedData)signedData);
                            ByteArrayOutputStream dataBuff = new ByteArrayOutputStream();
                            dataPart.writeTo((OutputStream)dataBuff);
                            ContentType dataContentType = new ContentType(dataPart.getContentType());
                            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                            if (dataContentType.getPrimaryType().equalsIgnoreCase("Multipart")) {
                                MimeMultipart mmp = (MimeMultipart)dataPart.getContent();
                                int i = 0;
                                while (i < mmp.getCount()) {
                                    BodyPart mbp = mmp.getBodyPart(i);
                                    ContentType partContentType = new ContentType(mbp.getContentType());
                                    if (partContentType.match(DATA_CONTENT_TYPE)) {
                                        BufferedInputStream in = new BufferedInputStream(mbp.getInputStream());
                                        int maxBlockSize = 64;
                                        while (((InputStream)in).available() > 0) {
                                            int blockSize = Math.min(((InputStream)in).available(), maxBlockSize);
                                            byte[] block = new byte[blockSize];
                                            ((InputStream)in).read(block, 0, blockSize);
                                            buffer.write(block);
                                        }
                                        ((InputStream)in).close();
                                        break;
                                    }
                                    ++i;
                                }
                            } else {
                                BufferedInputStream in = new BufferedInputStream(dataPart.getInputStream());
                                int maxBlockSize = 64;
                                while (((InputStream)in).available() > 0) {
                                    int blockSize = Math.min(((InputStream)in).available(), maxBlockSize);
                                    byte[] block = new byte[blockSize];
                                    ((InputStream)in).read(block, 0, blockSize);
                                    buffer.write(block);
                                }
                                ((InputStream)in).close();
                            }
                            if (buffer.size() > 0) {
                                returner[2] = new String[]{"0", new String(buffer.toByteArray(), encodding)};
                                break block19;
                            }
                            returner[2] = new String[]{"545", "XML Data Part not found in content:\n" + dataBuff.toString(encodding)};
                        }
                        catch (CMSSignatureVerifyException e) {
                            returner[2] = new String[]{"543", " Signature verification fail, " + e.toString()};
                        }
                        catch (CMSSignerInfoNotValidateException e) {
                            returner[2] = new String[]{"544", " Signature not validate, " + e.getMessage()};
                        }
                        break block19;
                    }
                    returner[2] = new String[]{"546", "Can not operate encryption message, not implement yet"};
                    break block19;
                }
                returner[2] = new String[]{"541", String.valueOf(contentType.getBaseType()) + " Content type is out of support length"};
            }
            catch (Exception e) {
                returner[2] = new String[]{"540", "S-MIME Message reading fail, " + GWInterface.getErrorString(e)};
            }
        }
        if (args.length == 2) {
            GWInterface.traceFile(args[1], data);
        }
    }

    public static void getCertInfo(byte[] arg1, int[] arg2, double[] arg3, String[] args, Object[] returner) {
        if (!GWInterface.verifyParam(args, 1, returner)) {
            return;
        }
        byte[] data = null;
        try {
            data = BASE64DecoderStream.decode((byte[])args[0].getBytes(encodding));
        }
        catch (Exception e) {
            returner[2] = new String[]{"503", "Source data character encodding fail, " + e.toString()};
            return;
        }
        try {
            SimpleDateFormat dFormat = new SimpleDateFormat("MM/dd/yyyy");
            CertProfile cert = CertProfile.getInstance((byte[])data);
            X509Certificate xCert = cert.getX509Cert();
            DName subjectName = cert.getSubjectDN();
            DName issuerName = cert.getIssuerDN();
            String[] rtn = new String[17];
            rtn[0] = "0";
            rtn[1] = new String(xCert.getSubjectX500Principal().toString().getBytes(), encodding);
            rtn[2] = new String(xCert.getIssuerX500Principal().toString().getBytes(), encodding);
            rtn[3] = new String(subjectName.getCommonName().getBytes(), encodding);
            rtn[4] = new String(subjectName.getOrganizationName().getBytes(), encodding);
            rtn[5] = new String(subjectName.getOrganizationalUnitName().getBytes(), encodding);
            rtn[6] = new String(subjectName.getStateOrProvinceName().getBytes(), encodding);
            rtn[7] = new String(subjectName.getLocalityName().getBytes(), encodding);
            rtn[8] = new String(subjectName.getStreetAddressName().getBytes(), encodding);
            rtn[9] = new String(subjectName.getCountryName().getBytes(), encodding);
            rtn[10] = new String(subjectName.getEMailAddress().getBytes(), encodding);
            rtn[11] = new String(issuerName.getCommonName().getBytes(), encodding);
            rtn[12] = new String(cert.getSerialNumber().toString().getBytes(), encodding);
            rtn[13] = new String(dFormat.format(xCert.getNotBefore()).getBytes(), encodding);
            rtn[14] = new String(dFormat.format(xCert.getNotAfter()).getBytes(), encodding);
            String ou = subjectName.getOrganizationalUnitName();
            String taxID = "";
            if (ou.indexOf(TAXID_PREFIX) > -1) {
                taxID = ou.substring(TAXID_PREFIX.length(), ou.length());
            }
            rtn[15] = new String(taxID.getBytes(), encodding);
            CMSIssuerAndSerialNumber iasn = new CMSIssuerAndSerialNumber(xCert);
            rtn[16] = new String(BASE64EncoderStream.encode((byte[])ASN1Util.encode((ASN1Value)iasn)), encodding);
            returner[2] = rtn;
        }
        catch (Exception e) {
            returner[2] = new String[]{"531", "X.509 Certificate data reading fail, " + e.toString()};
        }
        if (args.length == 2) {
            GWInterface.traceFile(args[1], data);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static List openEnvelopeAndVerifyProcess(byte[] doc) throws GWInvalidateEnvelopedDataException, GWInvalidateSignedDataException, GWCRLVerificationFailException, GWInvalidateSignatureException {
        try {
            bn = new ByteArrayInputStream(doc);
            envelopedData = GWInterface.packager.importEnvelopedData((InputStream)bn);
            bn.close();
            envContent = GWInterface.packager.openEnvelopedData(envelopedData);
            signedBytes = GWInterface.packager.getData(envContent);
        }
        catch (Exception e) {
            throw new GWInvalidateEnvelopedDataException(GWInterface.getErrorString(e));
        }
        rtns = new ArrayList<byte[]>();
        try {
            signIn = new ByteArrayInputStream(signedBytes);
            signedData = GWInterface.packager.importSignedData((InputStream)signIn);
            signIn.close();
            rtns.add(GWInterface.packager.getData(signedData));
        }
        catch (Exception e) {
            throw new GWInvalidateSignedDataException(e);
        }
        try {
            signers = signedData.getSigners();
            if (signers != null && signers.hasNext()) ** GOTO lbl38
            throw new GWInvalidateSignatureException("There are no any signature in data.");
lbl-1000:
            // 1 sources

            {
                sgn = (RawSignerInfo)signers.next();
                cert = sgn.getSignerCertificate();
                rtns.add(BASE64EncoderStream.encode((byte[])cert.getBytes()));
                rtns.add(BASE64EncoderStream.encode((byte[])sgn.getSignature()));
                rtns.add(sgn.getSigningTime().getBytes());
                try {
                    GWInterface.packager.signerVerify(signedData, cert);
                    continue;
                }
                catch (SecurePackageCRLException e) {
                    if (!GWInterface.cRLVerification) continue;
                    throw e;
                }
lbl38:
                // 3 sources

                ** while (signers.hasNext())
            }
lbl39:
            // 1 sources

        }
        catch (SecurePackageCRLException e) {
            throw new GWCRLVerificationFailException(e.getMessage());
        }
        catch (SecurePackageVerifyFailException e) {
            throw new GWInvalidateSignatureException(e.getMessage());
        }
        catch (SignatureException e) {
            throw new GWInvalidateSignatureException(e.getMessage());
        }
        catch (CertPackageException e) {
            throw new GWInvalidateSignatureException(e.getMessage());
        }
        return rtns;
    }

    protected static List openEnvelopeProcess(byte[] doc) throws GWInvalidateEnvelopedDataException {
        ArrayList<byte[]> rtns = new ArrayList<byte[]>();
        try {
            ByteArrayInputStream bn = new ByteArrayInputStream(doc);
            RawEnvelopedData envelopedData = packager.importEnvelopedData((InputStream)bn);
            bn.close();
            byte[] envContent = packager.openEnvelopedData(envelopedData);
            rtns.add(packager.getData(envContent));
            rtns.add(BASE64EncoderStream.encode((byte[])packager.getDefaultCertificate().getBytes()));
        }
        catch (Exception e) {
            throw new GWInvalidateEnvelopedDataException(e);
        }
        return rtns;
    }

    /*
     * Unable to fully structure code
     */
    protected static List verifyProcess(byte[] doc) throws GWInvalidateSignedDataException, GWCRLVerificationFailException, GWInvalidateSignatureException {
        rtns = new ArrayList<byte[]>();
        try {
            signIn = new ByteArrayInputStream(doc);
            signedData = GWInterface.packager.importSignedData((InputStream)signIn);
            signIn.close();
            rtns.add(doc);
        }
        catch (Exception e) {
            throw new GWInvalidateSignedDataException(e);
        }
        try {
            signers = signedData.getSigners();
            if (signers != null && signers.hasNext()) ** GOTO lbl29
            throw new GWInvalidateSignatureException("There are no any signature in data.");
lbl-1000:
            // 1 sources

            {
                sgn = (RawSignerInfo)signers.next();
                cert = sgn.getSignerCertificate();
                rtns.add(BASE64EncoderStream.encode((byte[])cert.getBytes()));
                rtns.add(BASE64EncoderStream.encode((byte[])sgn.getSignature()));
                rtns.add(sgn.getSigningTime().getBytes());
                try {
                    GWInterface.packager.signerVerify(signedData, cert);
                    continue;
                }
                catch (SecurePackageCRLException e) {
                    if (!GWInterface.cRLVerification) continue;
                    throw e;
                }
lbl29:
                // 3 sources

                ** while (signers.hasNext())
            }
lbl30:
            // 1 sources

        }
        catch (SecurePackageCRLException e) {
            throw new GWCRLVerificationFailException(e.getMessage());
        }
        catch (SecurePackageVerifyFailException e) {
            throw new GWInvalidateSignatureException(e.getMessage());
        }
        catch (SignatureException e) {
            throw new GWInvalidateSignatureException(e.getMessage());
        }
        catch (CertPackageException e) {
            throw new GWInvalidateSignatureException(e.getMessage());
        }
        return rtns;
    }

    protected static List signingProcess(byte[] doc) throws GWInvalidateEnvelopedDataException, GWSignatureSigningFailException, GWCRLVerificationFailException, GWInvalidateSignatureException {
        ArrayList<byte[]> rtns = new ArrayList<byte[]>();
        try {
            RawSignedData signedData;
            try {
                signedData = packager.signData(doc);
            }
            catch (Exception e) {
                throw new GWSignatureSigningFailException(e.getMessage());
            }
            rtns.add(packager.exportSignedData(signedData));
            Iterator signers = signedData.getSigners();
            while (signers.hasNext()) {
                RawSignerInfo sgn = (RawSignerInfo)signers.next();
                CertProfile cert = sgn.getSignerCertificate();
                rtns.add(BASE64EncoderStream.encode((byte[])cert.getBytes()));
                rtns.add(BASE64EncoderStream.encode((byte[])sgn.getSignature()));
                rtns.add(sgn.getAlgorithm().getAlgorithmName().getBytes());
            }
        }
        catch (CertPackageException e) {
            throw new GWInvalidateSignatureException(e.getMessage());
        }
        catch (SecurePackageInvalidDataException e) {
            throw new GWInvalidateSignatureException(e.getMessage());
        }
        return rtns;
    }

    protected static List envelopeProcess(byte[] doc, CertProfile recpCert) throws GWInvalidateEnvelopedDataException, GWSignatureSigningFailException, GWCRLVerificationFailException, GWInvalidateSignatureException {
        ArrayList<byte[]> rtns = new ArrayList<byte[]>();
        try {
            RawEnvelopedData envelopedData;
            try {
                envelopedData = packager.envelopeData(doc, recpCert);
            }
            catch (Exception e) {
                throw new GWSignatureSigningFailException(e.getMessage());
            }
            rtns.add(packager.exportEnvelopedData(envelopedData));
        }
        catch (SecurePackageInvalidDataException e) {
            throw new GWInvalidateSignatureException(e.getMessage());
        }
        return rtns;
    }

    protected static List signingAndEnvelopeProcess(byte[] doc, CertProfile recp) throws GWInvalidateEnvelopedDataException, GWSignatureSigningFailException, GWCRLVerificationFailException, GWInvalidateSignatureException {
        ArrayList<byte[]> rtns = new ArrayList<byte[]>();
        try {
            RawEnvelopedData envelopedData;
            RawSignedData signedData;
            try {
                signedData = packager.signData(doc);
            }
            catch (Exception e) {
                throw new GWSignatureSigningFailException(e.getMessage());
            }
            try {
                envelopedData = packager.envelopeData(packager.exportSignedData(signedData), recp);
            }
            catch (Exception e) {
                throw new GWSignatureSigningFailException(e.getMessage());
            }
            rtns.add(packager.exportEnvelopedData(envelopedData));
            rtns.add(BASE64EncoderStream.encode((byte[])recp.getBytes()));
        }
        catch (CertPackageException e) {
            throw new GWInvalidateSignatureException(e.getMessage());
        }
        catch (SecurePackageInvalidDataException e) {
            throw new GWInvalidateSignatureException(e.getMessage());
        }
        return rtns;
    }

    protected static String getErrorString(Exception e) {
        String error = String.valueOf(e.toString()) + "\n\r";
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(buff);
        e.printStackTrace(writer);
        error = String.valueOf(error) + buff.toString();
        StackTraceElement[] staks = e.getStackTrace();
        int i = 0;
        while (i < staks.length) {
            error = String.valueOf(error) + staks[i].toString() + "\n\r";
            ++i;
        }
        return error;
    }

    protected static void traceFile(String filename, byte[] data) {
        if (filename != null && filename.length() > 7) {
            try {
                File traceFile = new File(filename);
                FileWriter out = new FileWriter(traceFile);
                out.write(new String(data, encodding));
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static boolean verifyParam(String[] args, int requiredParams, Object[] returner) {
        if (args == null) {
            returner[2] = new String[]{"501", "No any required parameters supplied."};
            return false;
        }
        int fgr = -1;
        int i = 0;
        while (i < args.length) {
            if (args[i] == null) {
                fgr = i;
                break;
            }
            ++i;
        }
        if (fgr > -1) {
            returner[2] = new String[]{"501", "Argument #" + fgr + " was null"};
            return false;
        }
        if (args.length < requiredParams) {
            returner[2] = new String[]{"501", "There are any required parameters was not supplied"};
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            GWInterface.usages();
            System.exit(1);
        }
        try {
            String[] params;
            String cmd = args[0];
            String user = args[1];
            String password = args[2];
            String filein = args[3];
            String[] authen = new String[]{user, password};
            Object[] return1 = new Object[4];
            Object[] return2 = new Object[4];
            Object[] return3 = new Object[4];
            System.out.println("Start the Gateway Process:" + Utils.getWacthTime());
            GWInterface.startProcess(null, null, null, authen, return1);
            String[] starts = (String[])return1[2];
            int i = 0;
            while (i < starts.length) {
                System.out.println(starts[i]);
                ++i;
            }
            System.out.println(" ");
            System.out.println("Load input file:" + Utils.getWacthTime());
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            FileInputStream inFile = new FileInputStream(filein);
            int maxBlockSize = 512;
            int buffSize = Math.min(inFile.available(), maxBlockSize);
            byte[] block = new byte[buffSize];
            int p = inFile.read(block, 0, buffSize);
            while (p > 0) {
                buffer.write(block);
                buffSize = Math.min(inFile.available(), maxBlockSize);
                block = new byte[buffSize];
                p = inFile.read(block, 0, buffSize);
            }
            inFile.close();
            if (buffer.size() < 0) {
                System.out.println("File contain no data ...");
                System.exit(1);
            }
            String data = new String(buffer.toByteArray(), encodding);
            String recp = null;
            if (args.length > 5) {
                recp = String.valueOf(args[4]) + " - " + args[5];
            }
            System.out.println("\t file loaded " + Utils.getWacthTime());
            System.out.println(" ");
            System.out.println("Process PKI Function:");
            if (cmd.equalsIgnoreCase("Sign")) {
                params = new String[]{data};
                System.out.println("\t*Start signature signing process [" + Utils.getWacthTime() + "]");
                GWInterface.signingProcess(null, null, null, params, return2);
            }
            if (cmd.equalsIgnoreCase("Verify")) {
                params = new String[]{data};
                System.out.println("\t*Start signature verify process [" + Utils.getWacthTime() + "]");
                GWInterface.verifyProcess(null, null, null, params, return2);
            }
            if (cmd.equalsIgnoreCase("Open")) {
                params = new String[]{data};
                System.out.println("\t*Start open enveloped and signature verify process [" + Utils.getWacthTime() + "]");
                GWInterface.cryptoProcess(null, null, null, params, return2);
            }
            if (cmd.equalsIgnoreCase("SignEnv")) {
                if (recp == null) {
                    GWInterface.usages();
                    System.out.println("The operation required recipients as the certificate name");
                    System.exit(1);
                }
                params = new String[]{data, recp};
                System.out.println("\t*Start signature signing and envelope process [" + Utils.getWacthTime() + "]");
                GWInterface.signAndEnvelopeProcess(null, null, null, params, return2);
            }
            if (cmd.equalsIgnoreCase("Env")) {
                if (recp == null) {
                    GWInterface.usages();
                    System.out.println("The operation required recipients as the certificate name");
                    System.exit(1);
                }
                params = new String[]{data, recp};
                System.out.println("\t*Start envelope process [" + Utils.getWacthTime() + "]");
                GWInterface.envelopeProcess(null, null, null, params, return2);
            }
            if (cmd.equalsIgnoreCase("EnvN")) {
                if (recp == null) {
                    GWInterface.usages();
                    System.out.println("The operation required recipients as the certificate name");
                    System.exit(1);
                }
                params = new String[]{data, recp};
                System.out.println("\t*Start envelope with CA Nic name process [" + Utils.getWacthTime() + "]");
                GWInterface.envelopeProcessByCANicName(null, null, null, params, return2);
            }
            if (return2 != null) {
                String[] result = (String[])return2[2];
                if (result.length > 1) {
                    String errorCode = result[0];
                    String outData = result[1];
                    if (errorCode.equals("0")) {
                        System.out.println("\t*Finished pki operation [" + Utils.getWacthTime() + "]");
                        String outfile = String.valueOf(filein) + ".out";
                        System.out.println(" ");
                        System.out.println("Export file " + outfile + " " + Utils.getWacthTime());
                        FileOutputStream fout = new FileOutputStream(outfile);
                        fout.write(outData.getBytes(encodding));
                        fout.close();
                        System.out.println("\t Finished export " + outfile + " " + Utils.getWacthTime());
                    } else {
                        System.out.println("! Error code:" + errorCode + ", " + outData);
                    }
                }
            } else {
                System.out.println("! Operation fail ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void usages() {
        System.out.println("Gate Way Interface CGI");
        System.out.println("Usages:");
        System.out.println(" GWInterface <cmd> <agent id> <pin> <filein> [fileout] [CA Subject|CA Nic Name] [Cert SN]");
        System.out.println("  cmd - command such as: Sign, SignEnv, Env, EnvN, SignEnvN");
        System.out.println("        Sign = Signature Signing");
        System.out.println("        SignEnv = Signature Signing and then Envelope");
        System.out.println("        SignEnvN = Signature eigning and then envelope by specific CA Nic Name");
        System.out.println("        Env = Envelope ");
        System.out.println("        EnvN = Envelope by specific CA Nic Name");
        System.out.println("  filein - Input file ");
        System.out.println("  fileout - Output result file ");
        System.out.println("  CerrtID - Certificate ID in following systax: ");
        System.out.println("        1.Fully Issuer and Serial Number as:<Issuer Subject Name> - <SN>");
        System.out.println("          Sample :CN=TOT Root CA, O=TOT Corporation, OU=Certificate Authority - 100901");
        System.out.println("        2.CA Nic name and Serial Number as:<CA Nic name> - <SN>");
        System.out.println("          Sample :TOT - 100901");
    }
}

