/*
 * Decompiled with CFR 0.152.
 */
package management;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.List;
import th.co.oga.security.pki.Certification.CSRGeneration;
import th.co.oga.security.pki.Certification.CSRProfile;
import th.co.oga.security.pki.Certification.CertChain;
import th.co.oga.security.pki.Certification.CertPackage;
import th.co.oga.security.pki.Certification.CertPackageEncodingFormatNotSupportException;
import th.co.oga.security.pki.Certification.CertPackageException;
import th.co.oga.security.pki.Certification.CertPackageTypeNotSupportException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertificationRequestException;
import th.co.oga.security.pki.Certification.PFXProfile;
import th.co.oga.security.pki.HouseKeeping.AgentProfileNotInitializedException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.HouseKeeping.RoomOperationException;
import th.co.oga.security.pki.Operation.PFXOperation;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import th.co.oga.security.pki.Operator.SunPKCS12Driver;
import th.co.oga.security.pki.PinCode;
import th.co.oga.security.pki.X500.DName;
import ui.TCDSecureSuite;

public class CertificateManager {
    Room room = null;

    public CertificateManager(Room room) {
        this.room = room;
        TCDSecureSuite.logger.debug((Object)"TRUSTED\tCertificateManager instantiated.");
    }

    public CSRProfile requestOfflineGenerate(DName subj) throws RoomOperationException, CertificationRequestException, AgentProfileNotInitializedException {
        CSRGeneration csrGenerator = this.room.getCSRGenerator();
        CSRProfile csrProfile = csrGenerator.genCertRequest(subj);
        this.room.keepCSR(csrProfile);
        TCDSecureSuite.logger.info((Object)"TRUSTED\tRequest offline generate");
        return csrProfile;
    }

    public CSRProfile requestOfflineGenerateToFile(DName subj, String filename, String format) throws RoomOperationException, CertificationRequestException, AgentProfileNotInitializedException, FileNotFoundException, IOException {
        CSRProfile csrProfile = this.requestOfflineGenerate(subj);
        csrProfile.exportCSR(filename, format);
        TCDSecureSuite.logger.info((Object)("TRUSTED\tRequest offline generate to file [" + filename + "]"));
        return csrProfile;
    }

    public void importSingleCertificateFile(String filename, String fileExtension, List option) throws CertPackageTypeNotSupportException, CertificateException, SecureStoreException, CertPackageException, FileNotFoundException, CertPackageEncodingFormatNotSupportException, IOException {
        File file = new File(filename);
        SecureStoreOperator secureStoreOperator = this.room.getSecureStoreOperator();
        CertPackage certPackage = secureStoreOperator.getCertPackageInstance(fileExtension.toUpperCase());
        certPackage.importFromFile(file, option);
        secureStoreOperator.importCertPackage(certPackage);
        TCDSecureSuite.logger.info((Object)("TRUSTED\tImported single certPackage [" + certPackage + "] to file [" + filename + "]"));
    }

    public void importChainCertificateFile(String filename, String fileExtension, List option) throws CertPackageException, CertPackageTypeNotSupportException, CertificateException, SecureStoreException, FileNotFoundException, CertPackageEncodingFormatNotSupportException, IOException {
        File file = new File(filename);
        SecureStoreOperator secureStoreOperator = this.room.getSecureStoreOperator();
        CertPackage certPackage = secureStoreOperator.getCertPackageInstance(fileExtension.toUpperCase());
        certPackage.importFromFile(file, option);
        secureStoreOperator.importCertPackage(certPackage);
        TCDSecureSuite.logger.info((Object)("TRUSTED\tImported chain certPackage [" + certPackage.getFriendlyName() + "] to file [" + filename + "]"));
    }

    public void importPfxFile(String filename, String pin) throws CertPackageTypeNotSupportException, CertificateException, SecureStoreException, FileNotFoundException, CertPackageEncodingFormatNotSupportException, CertPackageException, IOException, NoSuchProviderException, KeyStoreException {
        File file = new File(filename);
        SecureStoreOperator secureStoreOperator = this.room.getSecureStoreOperator();
        PinCode pinCode = new PinCode(pin);
        PFXProfile pfxProfile = null;
        try {
            pfxProfile = new PFXProfile(secureStoreOperator.getPKCS12Device(), file, pinCode);
            this.room.importCertPackage((CertPackage)pfxProfile);
        }
        catch (CertPackageException e) {
            pfxProfile = new PFXProfile((PFXOperation)new SunPKCS12Driver(), file, pinCode);
            this.room.importCertPackage((CertPackage)pfxProfile);
        }
        TCDSecureSuite.logger.info((Object)("TRUSTED\tImported pfxProfile [" + pfxProfile + "] to file [" + filename + "]"));
    }

    public void exportSingleCertificateFile(String filename, String certGroup, int id) throws SecureStoreException, CertPackageException, IOException {
        if (!(filename.toLowerCase().endsWith(".cer") || filename.toLowerCase().endsWith(".der") || filename.toLowerCase().endsWith(".pem"))) {
            filename = String.valueOf(filename) + ".cer";
        }
        SecureStoreOperator secureStoreOperator = this.room.getSecureStoreOperator();
        List certList = secureStoreOperator.getCertificates(certGroup);
        CertProfile certProfile = (CertProfile)certList.get(id);
        File file = new File(filename);
        FileOutputStream fos = new FileOutputStream(file);
        byte[] raw = certProfile.getBytes();
        fos.write(raw);
        fos.close();
        TCDSecureSuite.logger.info((Object)("TRUSTED\tExported certProfile [" + certProfile + "] to file [" + filename + "]"));
    }

    public void exportChainCertificateFile(String filename, String certGroup, int id) throws SecureStoreException, CertPackageException, IOException {
        if (!(filename.toLowerCase().endsWith(".p7") || filename.toLowerCase().endsWith(".p7b") || filename.toLowerCase().endsWith(".p7c"))) {
            filename = String.valueOf(filename) + ".p7b";
        }
        SecureStoreOperator secureStoreOperator = this.room.getSecureStoreOperator();
        List certList = secureStoreOperator.getCertificates(certGroup);
        CertProfile certProfile = (CertProfile)certList.get(id);
        CertChain certChain = secureStoreOperator.getCertChain(certProfile);
        File file = new File(filename);
        FileOutputStream fos = new FileOutputStream(file);
        byte[] raw = certChain.getBytes();
        fos.write(raw);
        fos.close();
        TCDSecureSuite.logger.info((Object)("TRUSTED\tExported certProfile [" + certProfile + "], certChain [" + certChain + "] to file [" + filename + "]"));
    }

    public void exportPfxFile(String filename, String certGroup, int id, String pin) throws SecureStoreException, CertPackageException, IOException {
        if (!filename.toLowerCase().endsWith(".pfx") && !filename.toLowerCase().endsWith(".p12")) {
            filename = String.valueOf(filename) + ".pfx";
        }
        SecureStoreOperator secureStoreOperator = this.room.getSecureStoreOperator();
        List certList = secureStoreOperator.getCertificates(certGroup);
        CertProfile certProfile = (CertProfile)certList.get(id);
        PinCode pinCode = new PinCode(pin);
        PFXProfile pfxProfile = secureStoreOperator.getPFX(certProfile, pinCode);
        File file = new File(filename);
        FileOutputStream fos = new FileOutputStream(file);
        byte[] raw = pfxProfile.getBytes();
        fos.write(raw);
        fos.close();
        TCDSecureSuite.logger.info((Object)("TRUSTED\tExported certProfile [" + certProfile + "], pfxProfile [" + pfxProfile + "] to file [" + filename + "]"));
    }

    public void deleteCertificate(String certGroup, int id) throws Exception {
        SecureStoreOperator secureStoreOperator = this.room.getSecureStoreOperator();
        List certList = secureStoreOperator.getCertificates(certGroup);
        CertProfile certProfile = (CertProfile)certList.get(id);
        CertProfile defaultCert = this.room.getOwner().getDefaultCertificate();
        if (defaultCert != null && defaultCert.equals(certProfile)) {
            throw new Exception("Default certificate cannot be deleted.");
        }
        secureStoreOperator.deleteCertPackage(certProfile);
        TCDSecureSuite.logger.info((Object)"TRUSTED\tAgent room deleted.");
    }
}

