/*
 * Decompiled with CFR 0.152.
 */
package management;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportTable;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.OIDs;
import th.co.oga.security.pki.Operation.DataEncryptionFailException;
import th.co.oga.security.pki.Operation.KeyGenerateFailException;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operation.SecureStoreFindingFailException;
import th.co.oga.security.pki.Operator.SecureOperator;
import th.co.oga.security.pki.Utils;
import ui.TCDSecureSuite;

public class CryptographicManager {
    ByteArrayOutputStream signedData = new ByteArrayOutputStream();
    ByteArrayOutputStream encryptedData = new ByteArrayOutputStream();
    Room room;

    public CryptographicManager(Room room) {
        this.room = room;
        TCDSecureSuite.logger.debug((Object)"CRYPTOGRAPHIC\tCryptographicManager instantiated.");
    }

    public void resetSignedData() {
        TCDSecureSuite.logger.info((Object)"CRYPTOGRAPHIC\tResetSignedData");
        this.signedData.reset();
    }

    public void resetEncrypedData() {
        TCDSecureSuite.logger.info((Object)"CRYPTOGRAPHIC\tResetEncryptedData");
        this.encryptedData.reset();
    }

    public void signdata(byte[] raw, int profileId, int algoId) throws SecureStoreException, InvalidKeyException, NoSuchAlgorithmException, SecureStoreFindingFailException, SignatureException, AlgorithmSupportException, IOException {
        SecureOperator secureOperator = this.room.getSecureOperator();
        CertProfile[] certProfileList = this.room.getCertificates();
        AlgorithmSupportTable algoTable = secureOperator.getSupportAlgorithm();
        AlgorithmSet algoSet = algoTable.getSignatureAlgorithm();
        CertProfile certProfile = certProfileList[profileId];
        AlgorithmProfile algoProfile = (AlgorithmProfile)algoSet.get(algoId);
        byte[] signedRaw = secureOperator.signData(raw, algoProfile, certProfile);
        TCDSecureSuite.logger.info((Object)("CRYPTOGRAPHIC\tSigned raw data bytes = " + raw.length));
        this.signedData.write(signedRaw);
    }

    public void encryptData(byte[] raw, int algoId) throws IOException, DataEncryptionFailException, NoSuchAlgorithmException, InvalidKeySpecException, AlgorithmSupportException, InvalidKeyException, KeyGenerateFailException {
        SecureOperator secureOperator = this.room.getSecureOperator();
        AlgorithmSupportTable algoTable = secureOperator.getSupportAlgorithm();
        AlgorithmSet algoSet = algoTable.getSymetricEncryptionAlgorithm();
        AlgorithmProfile algoProfile = (AlgorithmProfile)algoSet.get(algoId);
        SecretKey key = secureOperator.getCryptoOperator().genSecretKey(algoProfile, "12345");
        AlgorithmParameterSpec algoParamSpec = secureOperator.getAlgorithmParameterSpec(algoProfile);
        byte[] encryptedRaw = secureOperator.encryptData(raw, algoProfile, key, algoParamSpec);
        this.encryptedData.write(encryptedRaw);
        TCDSecureSuite.logger.info((Object)"CRYPTOGRAPHIC\tEncrypted raw dta.");
    }

    public void encryptFile(int algoId, String key, String srcFilename, String desFilename) throws DataEncryptionFailException, IOException, NoSuchAlgorithmException, InvalidKeySpecException, AlgorithmSupportException {
        SecureOperator secureOperator = this.room.getSecureOperator();
        AlgorithmSupportTable algoTable = secureOperator.getSupportAlgorithm();
        AlgorithmSet algoSet = algoTable.getSymetricEncryptionAlgorithm();
        AlgorithmProfile algoProfile = (AlgorithmProfile)algoSet.get(algoId);
        FileInputStream fis = new FileInputStream(new File(srcFilename));
        FileOutputStream fos = new FileOutputStream(new File(desFilename));
        ByteArrayOutputStream dataBuffer = new ByteArrayOutputStream();
        int blockSize = 64;
        int buffSize = Math.min(fis.available(), blockSize);
        byte[] buff = new byte[buffSize];
        while (fis.read(buff, 0, buffSize) > -1) {
            dataBuffer.write(buff);
            if (fis.available() < 1) break;
            buffSize = Math.min(fis.available(), blockSize);
            buff = new byte[buffSize];
        }
        fis.close();
        byte[] rawdata = dataBuffer.toByteArray();
        System.out.println("Get algorithm ...");
        AlgorithmSupportTable algos = secureOperator.getSupportAlgorithm();
        AlgorithmSet encAlgoSet = algos.getSymetricEncryptionAlgorithm();
        AlgorithmProfile encAlgo = encAlgoSet.findByOID(OIDs.DES_CBC_pad);
        System.out.println("Algorithm name:" + algoProfile.getAlgorithmName());
        System.out.println("Encrypt data...");
        System.out.println("Start ..." + Utils.getWacthTime());
        byte[] cipherText = secureOperator.encryptData(rawdata, algoProfile, key);
        System.out.println("Finish ..." + Utils.getWacthTime());
        System.out.println("Save to file ...");
        fos.write(cipherText);
        fis.close();
        fos.close();
        TCDSecureSuite.logger.info((Object)("CRYPTOGRAPHIC\tEncrypted file from source [" + srcFilename + "] to [" + desFilename + "]"));
    }

    public void decryptFile(int algoId, String key, String srcFilename, String desFilename) throws DataEncryptionFailException, IOException {
        SecureOperator secureOperator = this.room.getSecureOperator();
        AlgorithmSupportTable algoTable = secureOperator.getSupportAlgorithm();
        AlgorithmSet algoSet = algoTable.getSymetricEncryptionAlgorithm();
        AlgorithmProfile algoProfile = (AlgorithmProfile)algoSet.get(algoId);
        FileInputStream fis = new FileInputStream(new File(srcFilename));
        FileOutputStream fos = new FileOutputStream(new File(desFilename));
        ByteArrayOutputStream dataBuffer = new ByteArrayOutputStream();
        int blockSize = 64;
        int buffSize = Math.min(fis.available(), blockSize);
        byte[] buff = new byte[buffSize];
        while (fis.read(buff, 0, buffSize) > -1) {
            dataBuffer.write(buff);
            if (fis.available() < 1) break;
            buffSize = Math.min(fis.available(), blockSize);
            buff = new byte[buffSize];
        }
        fis.close();
        byte[] rawdata = dataBuffer.toByteArray();
        System.out.println("Get algorithm ...");
        System.out.println("Algorithm name:" + algoProfile.getAlgorithmName());
        System.out.println("Encrypt data...");
        System.out.println("Start ..." + Utils.getWacthTime());
        byte[] cipherText = secureOperator.decryptData(rawdata, algoProfile, key);
        System.out.println("Finish ..." + Utils.getWacthTime());
        System.out.println("Save to file ...");
        fos.write(cipherText);
        fis.close();
        fos.close();
        TCDSecureSuite.logger.info((Object)("CRYPTOGRAPHIC\tDecrypted file source [" + srcFilename + "] to [" + desFilename + "]"));
    }

    public CertProfile[] getCertificates() throws SecureStoreException {
        CertProfile[] certProfileList = this.room.getCertificates();
        TCDSecureSuite.logger.info((Object)"CRYPTOGRAPHIC\tGetCertificates");
        return certProfileList;
    }

    public AlgorithmSet getAlgorithmSet() {
        SecureOperator secureOperator = this.room.getSecureOperator();
        AlgorithmSupportTable algoTable = secureOperator.getSupportAlgorithm();
        AlgorithmSet algoSet = algoTable.getSignatureAlgorithm();
        TCDSecureSuite.logger.info((Object)"CRYPTOGRAPHIC\tGetAlgorihmSet");
        return algoSet;
    }

    public ByteArrayOutputStream getEncryptedData() {
        TCDSecureSuite.logger.info((Object)"CRYPTOGRAPHIC\tGetEncryptedData");
        return this.encryptedData;
    }

    public ByteArrayOutputStream getSignedData() {
        TCDSecureSuite.logger.info((Object)"CRYPTOGRAPHIC\tGetSignedData");
        return this.signedData;
    }

    public AlgorithmSet getEncryptionAlgorithm() {
        SecureOperator secureOperator = this.room.getSecureOperator();
        AlgorithmSupportTable algoTable = secureOperator.getSupportAlgorithm();
        AlgorithmSet algoSet = algoTable.getSymetricEncryptionAlgorithm();
        TCDSecureSuite.logger.info((Object)"CRYPTOGRAPHIC\tGetEncryptionAlgorithm");
        return algoSet;
    }
}

