/*
 * Decompiled with CFR 0.152.
 */
package management;

import java.io.IOException;
import java.security.Provider;
import th.co.oga.security.pki.Certification.CertPackageException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Engine.SecureEngine;
import th.co.oga.security.pki.Engine.SecureProviderType;
import th.co.oga.security.pki.HouseKeeping.AgentProfile;
import th.co.oga.security.pki.HouseKeeping.AgentProfileNotFoundException;
import th.co.oga.security.pki.HouseKeeping.AgentProfileVerifyException;
import th.co.oga.security.pki.HouseKeeping.ConfigFailException;
import th.co.oga.security.pki.HouseKeeping.HouseKeeper;
import th.co.oga.security.pki.HouseKeeping.KeeperFatalException;
import th.co.oga.security.pki.HouseKeeping.KeeperSoftException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.PinCode;
import th.co.oga.security.pki.X500.DName;
import ui.TCDSecureSuite;

public class SecureAgentManager {
    private HouseKeeper house;

    public SecureAgentManager() {
        TCDSecureSuite.logger.debug((Object)"AGENT\tSecuerAgentManager instantiated.");
    }

    public SecureAgentManager(HouseKeeper h) {
        this();
        this.house = h;
    }

    public void register(String agentId, String agentName, Provider provider, Provider cryptoProvider, String commonName, String country, String locality, String orgUnit, String org, String province, String address, String email) throws KeeperFatalException, Throwable {
        DName dName = new DName(commonName, country, locality, orgUnit, org, province, address, email);
        SecureEngine secureEngine = new SecureEngine(provider);
        secureEngine.setProvider(provider);
        SecureProviderType secureProviderType = SecureProviderType.getInstance((String)SecureProviderType.CRYPTO_MANAGER);
        secureEngine.setProvider(secureProviderType, cryptoProvider);
        AgentProfile agentProfile = new AgentProfile(agentId, agentName);
        agentProfile.setSubjectName(dName);
        agentProfile.setEngine(secureEngine);
        this.house.registerAgent(agentProfile);
        TCDSecureSuite.logger.info((Object)("AGENT\tRegistered agent " + agentProfile.toString()));
    }

    public void buildRoom(String agentId, String pin) throws KeeperFatalException, KeeperSoftException, AgentProfileNotFoundException, AgentProfileVerifyException, ConfigFailException {
        HouseKeeper house = new HouseKeeper();
        Room room = house.reserveRoom(agentId);
        PinCode pinCode = new PinCode(pin);
        room.lock(pinCode);
        room.close();
        TCDSecureSuite.logger.info((Object)("AGENT\tBuilt room for " + agentId));
    }

    public void changePin(Room room, String oldPin, String newPin) throws KeeperFatalException, KeeperSoftException {
        PinCode oldPinCode = new PinCode(oldPin);
        PinCode newPinCode = new PinCode(newPin);
        room.changPIN(oldPinCode, newPinCode);
        TCDSecureSuite.logger.info((Object)"AGENT\tChanged pin.");
    }

    public void setRoom(HouseKeeper house, Room room, String keyPairAlgoOid, int keyPairSize, String keyWrapAlgoOid, String encryptionAlgoOid, String signatureAlgoOid) throws KeeperFatalException, KeeperSoftException, AgentProfileNotFoundException, AgentProfileVerifyException, ConfigFailException {
        AgentProfile agentProfile = room.getOwner();
        agentProfile.setKeyPairAlgo(keyPairAlgoOid);
        agentProfile.setKeyPairSize(keyPairSize);
        agentProfile.setKeyWrapAlgo(keyWrapAlgoOid);
        agentProfile.setEncryptionAlgo(encryptionAlgoOid);
        agentProfile.setSignatureAlgo(signatureAlgoOid);
        house.updateAgentProfile(agentProfile);
        TCDSecureSuite.logger.info((Object)"AGENT\tSet room.");
    }

    public void wipeRoom(Room room) throws KeeperFatalException, KeeperSoftException {
        TCDSecureSuite.logger.info((Object)"AGENT\tWiped room.");
        room.erase();
    }

    public Room signOn(String agentId, String pin) throws KeeperFatalException, KeeperSoftException {
        HouseKeeper house = new HouseKeeper();
        Room room = house.reserveRoom(agentId);
        room.open(new PinCode(pin));
        TCDSecureSuite.logger.info((Object)("AGENT\tSigned on " + agentId));
        return room;
    }

    public void setDefaultCertificate(HouseKeeper house, Room room, CertProfile certProfile) throws CertPackageException, IOException, AgentProfileNotFoundException, AgentProfileVerifyException, ConfigFailException {
        AgentProfile agent = room.getOwner();
        agent.setDefaultCertificate(certProfile);
        house.updateAgentProfile(agent);
    }
}

