/*
 * Decompiled with CFR 0.152.
 */
package management;

import SecurePackaging.P7SecurePackager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operation.SecureStoreFindingFailException;
import th.co.oga.security.pki.Packaging.RawEnvelopedData;
import th.co.oga.security.pki.Packaging.RawSignedData;
import th.co.oga.security.pki.Packaging.SecurePackageCRLException;
import th.co.oga.security.pki.Packaging.SecurePackageEncipherException;
import th.co.oga.security.pki.Packaging.SecurePackageEncodingFailException;
import th.co.oga.security.pki.Packaging.SecurePackageEnvelopeException;
import th.co.oga.security.pki.Packaging.SecurePackageInvalidDataException;
import th.co.oga.security.pki.Packaging.SecurePackageSigningFailException;
import th.co.oga.security.pki.Packaging.SecurePackageVerifyFailException;
import th.co.oga.security.pki.Utils;
import ui.TCDSecureSuite;
import ui.packaging.CertProfileItem;

public class SecurePackageManager {
    private Room room;
    private P7SecurePackager packager;
    private RawSignedData rawSignedData;
    private RawEnvelopedData rawEnvelopedData;

    public SecurePackageManager(Room room) throws SecureStoreException, AlgorithmSupportException, EntryNotFoundException {
        this.room = room;
        this.packager = new P7SecurePackager(room);
        TCDSecureSuite.logger.debug((Object)"DATAPACKAGING\tSecurePackageManager instantiated.");
    }

    public void addRecipient(Room room, int certId, byte[] raw, String outputFilename) throws SecureStoreException, AlgorithmSupportException, SecurePackageEncodingFailException, SecurePackageEnvelopeException, SecurePackageInvalidDataException, IOException {
        RawEnvelopedData rawEnvelopedData = this.packager.importEnvelopedData(raw);
        CertProfile[] certProfileList = room.getTrustedCertificates();
        this.packager.addRecipient(rawEnvelopedData, certProfileList[certId]);
        FileOutputStream fos = new FileOutputStream(new File(outputFilename));
        this.packager.exportEnvelopedData(rawEnvelopedData, fos);
        TCDSecureSuite.logger.info((Object)("DATAPACKAGING\tAdded recipient from raw bytes = " + raw.length + " to [" + outputFilename + "]"));
    }

    public void envelopeData(String inputFilename, CertProfile[] certProfileList) throws SecurePackageEncodingFailException, IOException, SecurePackageEnvelopeException, SecurePackageEncipherException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        FileInputStream srcIn = new FileInputStream(inputFilename);
        int maxBlockSize = 512;
        int buffSize = Math.min(srcIn.available(), maxBlockSize);
        byte[] x = new byte[buffSize];
        int p = srcIn.read(x, 0, buffSize);
        while (p > 0) {
            bo.write(x);
            buffSize = Math.min(srcIn.available(), maxBlockSize);
            x = new byte[buffSize];
            p = srcIn.read(x, 0, buffSize);
        }
        srcIn.close();
        byte[] data = bo.toByteArray();
        bo.close();
        this.rawEnvelopedData = this.packager.envelopeData(data, certProfileList[0]);
        int i = 1;
        while (i < certProfileList.length) {
            this.packager.addRecipient(this.rawEnvelopedData, certProfileList[i]);
            System.out.println("Added recipient to envelope " + certProfileList[i]);
            ++i;
        }
        TCDSecureSuite.logger.info((Object)("DATAPACKAGING\tEnveloped data from source [" + inputFilename + "]"));
    }

    public void envelopeData(byte[] raw, CertProfile[] certProfileList) throws Exception {
        if (certProfileList.length == 0) {
            throw new Exception("Empty profile list.\nSigning operation failed.");
        }
        this.rawEnvelopedData = this.packager.envelopeData(raw, certProfileList[0]);
        int i = 1;
        while (i < certProfileList.length) {
            this.packager.addRecipient(this.rawEnvelopedData, certProfileList[i]);
            ++i;
        }
        TCDSecureSuite.logger.info((Object)("DATAPACKAGING\tEnveloped data from raw bytes = " + raw.length));
    }

    public RawEnvelopedData getRawEnvelopedData() {
        TCDSecureSuite.logger.info((Object)"DATAPACKAGING\tGetRawEnvelopedData");
        return this.rawEnvelopedData;
    }

    public void addRecipient(int certId, String inputFilename, String outputFilename) throws SecureStoreException, AlgorithmSupportException, SecurePackageEncodingFailException, SecurePackageEnvelopeException, SecurePackageInvalidDataException, IOException {
        FileInputStream fis = new FileInputStream(new File(inputFilename));
        RawEnvelopedData rawEnvelopedData = this.packager.importEnvelopedData(fis);
        CertProfile[] certProfileList = this.room.getTrustedCertificates();
        this.packager.addRecipient(rawEnvelopedData, certProfileList[certId]);
        FileOutputStream fos = new FileOutputStream(outputFilename);
        this.packager.exportEnvelopedData(rawEnvelopedData, fos);
        TCDSecureSuite.logger.info((Object)("DATAPACKAGING\tAdded recipient source [" + inputFilename + "] to [" + outputFilename + "]"));
    }

    public void verifySignature(String inputFilename) throws SecureStoreException, AlgorithmSupportException, FileNotFoundException, SecurePackageEncodingFailException, CertificateException, NoSuchAlgorithmException, SignatureException, SecurePackageVerifyFailException, SecurePackageCRLException {
        FileInputStream fis = new FileInputStream(inputFilename);
        RawSignedData rawSignedData = this.packager.importSignedData(fis);
        CertProfile certProfile = new CertProfile();
        this.packager.signerVerify(rawSignedData, certProfile);
        TCDSecureSuite.logger.info((Object)("DATAPACKAGING\tVerified signature source [" + inputFilename + "]"));
    }

    public void signPrimary(String inputFilename, String outputFilename) throws IOException, SecureStoreException, AlgorithmSupportException, SecureStoreFindingFailException, SecurePackageInvalidDataException, SecurePackageSigningFailException {
        FileInputStream fis = new FileInputStream(inputFilename);
        int maxBlockSize = 512;
        int buffSize = Math.min(fis.available(), maxBlockSize);
        byte[] buff = new byte[buffSize];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int p = fis.read(buff, 0, buffSize);
        while (p > 0) {
            baos.write(buff);
            buffSize = Math.min(fis.available(), maxBlockSize);
            buff = new byte[buffSize];
            p = fis.read(buff, 0, buffSize);
        }
        byte[] raw = baos.toByteArray();
        RawSignedData rawSignedData = this.packager.signData(raw);
        FileOutputStream fos = new FileOutputStream(outputFilename);
        this.packager.exportSignedData(rawSignedData, fos);
        TCDSecureSuite.logger.info((Object)("DATAPACKAGING\tSigned primary from source [" + inputFilename + "] to [" + outputFilename + "]"));
    }

    public void signPrimary(byte[] raw, String outputFilename) throws SecureStoreException, AlgorithmSupportException, SecureStoreFindingFailException, FileNotFoundException, SecurePackageInvalidDataException, SecurePackageSigningFailException {
        System.out.println("Raw " + raw);
        this.rawSignedData = this.packager.signData(raw);
        FileOutputStream fos = new FileOutputStream(outputFilename);
        this.packager.exportSignedData(this.rawSignedData, fos);
        TCDSecureSuite.logger.info((Object)("DATAPACKAGING\tSigned primary from raw bytes = " + raw.length + " to [" + outputFilename + "]"));
    }

    public void signSecodnary(String inputFilename, String outputFilename) throws SecureStoreException, AlgorithmSupportException, SecurePackageEncodingFailException, IOException, SecureStoreFindingFailException, SecurePackageInvalidDataException, SecurePackageSigningFailException {
        FileInputStream fis = new FileInputStream(inputFilename);
        this.rawSignedData = this.packager.importSignedData(fis);
        fis.close();
        this.packager.sign(this.rawSignedData);
        FileOutputStream fos = new FileOutputStream(outputFilename);
        this.packager.exportSignedData(this.rawSignedData, fos);
        fos.close();
        TCDSecureSuite.logger.info((Object)("DATAPACKAGING\tSigned secondary from source [" + inputFilename + "] to [" + outputFilename + "]"));
    }

    public void signSecodnary(String outputFilename) throws SecureStoreException, AlgorithmSupportException, SecurePackageEncodingFailException, IOException, SecureStoreFindingFailException, SecurePackageInvalidDataException, SecurePackageSigningFailException {
        if (this.rawSignedData == null) {
            return;
        }
        this.packager.sign(this.rawSignedData);
        FileOutputStream fos = new FileOutputStream(outputFilename);
        this.packager.exportSignedData(this.rawSignedData, fos);
        fos.close();
        TCDSecureSuite.logger.info((Object)("DATAPACKAGING\tSigned secondary to [" + outputFilename + "]"));
    }

    public void signSecondary(CertProfileItem certProfile) throws SecureStoreFindingFailException, AlgorithmSupportException, SecurePackageSigningFailException {
        if (this.rawSignedData == null) {
            return;
        }
        this.packager.sign(this.rawSignedData, certProfile.getCertProfile());
        TCDSecureSuite.logger.info((Object)"DATAPACKAGING\tSigned secondary in memory");
    }

    public void envelopeData(String srcFile, String tarFile) {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            FileInputStream srcIn = new FileInputStream(srcFile);
            int maxBlockSize = 512;
            int buffSize = Math.min(srcIn.available(), maxBlockSize);
            byte[] x = new byte[buffSize];
            int p = srcIn.read(x, 0, buffSize);
            while (p > 0) {
                bo.write(x);
                buffSize = Math.min(srcIn.available(), maxBlockSize);
                x = new byte[buffSize];
                p = srcIn.read(x, 0, buffSize);
            }
            srcIn.close();
            byte[] data = bo.toByteArray();
            bo.close();
            System.out.println("Finished --> " + Utils.getWacthTime());
            System.out.println("Envelope data");
            System.out.println("Start --> " + Utils.getWacthTime());
            RawEnvelopedData envelopedData = this.packager.envelopeData(data, this.packager.getDefaultCertificate());
            System.out.println("Finished --> " + Utils.getWacthTime());
            System.out.println("Save to file");
            System.out.println("Start --> " + Utils.getWacthTime());
            FileOutputStream tarOut = new FileOutputStream(tarFile);
            this.packager.exportEnvelopedData(envelopedData, tarOut);
            tarOut.close();
            System.out.println("Finished --> " + Utils.getWacthTime());
            System.out.println("Close room");
            this.room.close();
            TCDSecureSuite.logger.info((Object)("DATAPACKAGING\tEnveloped data from source [" + srcFile + "] to [" + tarFile + "]"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void envelopeData(byte[] data, String outputFilename) {
        try {
            System.out.println("Envelope data");
            System.out.println("Start --> " + Utils.getWacthTime());
            RawEnvelopedData envelopedData = this.packager.envelopeData(data, this.packager.getDefaultCertificate());
            System.out.println("Finished --> " + Utils.getWacthTime());
            System.out.println("Save to file");
            System.out.println("Start --> " + Utils.getWacthTime());
            FileOutputStream tarOut = new FileOutputStream(outputFilename);
            this.packager.exportEnvelopedData(envelopedData, tarOut);
            tarOut.close();
            System.out.println("Finished --> " + Utils.getWacthTime());
            System.out.println("Close room");
            this.room.close();
            TCDSecureSuite.logger.info((Object)("DATAPACKAGING\tEnveloped data from raw bytes = " + data.length + " to [" + outputFilename + "]"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void openSignedFile(String filename) throws SecureStoreException, SecurePackageEncodingFailException, SecureStoreFindingFailException, SecurePackageInvalidDataException, AlgorithmSupportException, IOException {
        FileInputStream fis = new FileInputStream(filename);
        this.rawSignedData = this.packager.importSignedData(fis);
        fis.close();
        TCDSecureSuite.logger.info((Object)("DATAPACKAGING\tOpened signed file source [" + filename + "]"));
    }

    public P7SecurePackager getPackager() {
        TCDSecureSuite.logger.info((Object)"DATAPACKAGING\tGetPackager");
        return this.packager;
    }

    public RawSignedData getRawSignedData() {
        TCDSecureSuite.logger.info((Object)"DATAPACKAGING\tGetRawSignedData");
        return this.rawSignedData;
    }

    public void exportEnvelope(String envelopeFilename) throws SecurePackageInvalidDataException, IOException {
        FileOutputStream tarOut = new FileOutputStream(envelopeFilename);
        this.packager.exportEnvelopedData(this.rawEnvelopedData, tarOut);
        tarOut.close();
        TCDSecureSuite.logger.info((Object)("DATAPACKAGING\tExported envelope to [" + envelopeFilename + "]"));
    }

    public void openEnvelop(String envelopedFilename) throws IOException, SecurePackageEncodingFailException {
        System.out.println("Load enveloped file to be test");
        System.out.println("Start --> " + Utils.getWacthTime());
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        FileInputStream srcIn = new FileInputStream(envelopedFilename);
        this.rawEnvelopedData = this.packager.importEnvelopedData(srcIn);
        srcIn.close();
        bo.close();
        System.out.println("Finished --> " + Utils.getWacthTime());
        System.out.println("Enveloped Data :" + this.rawEnvelopedData.getEncryptedInfo().getAlgorithm().getAlgorithmName());
        System.out.println("Envelope data");
        System.out.println("Start --> " + Utils.getWacthTime());
        TCDSecureSuite.logger.info((Object)("DATAPACKAGING\tOpened Evenelop source [" + envelopedFilename + "]"));
    }
}

