/*
 * Decompiled with CFR 0.152.
 */
package management;

import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.HouseKeeping.ConfigFailException;
import th.co.oga.security.pki.HouseKeeping.ProfileAlreadyExistException;
import th.co.oga.security.pki.HouseKeeping.ProfileNotFoundException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Trusted.Authority;
import th.co.oga.security.pki.Trusted.AuthorityService;
import th.co.oga.security.pki.Trusted.ServiceName;
import th.co.oga.security.pki.Trusted.TrustedPolicies;
import ui.TCDSecureSuite;

public class TrustedManager {
    CertProfile[] caCertProfileList;
    CertProfile[] trustedCertProfileList;
    Authority[] autoritiesList;
    Room room;

    public TrustedManager(Room room) throws SecureStoreException, ASN1Exception {
        this.room = room;
        this.listCaRegister();
        TCDSecureSuite.logger.debug((Object)"TRUSTED\tTrustedManager instantiated.");
    }

    public void listCaRegister() throws SecureStoreException, ASN1Exception {
        this.caCertProfileList = this.room.getCaCertificates();
        this.trustedCertProfileList = this.room.getTrustedCertificates();
        this.autoritiesList = this.room.getAuthorities();
        TCDSecureSuite.logger.debug((Object)"TRUSTED\tListCaRegister");
    }

    public void configService() throws SecureStoreException, ASN1Exception, ProfileAlreadyExistException, ProfileNotFoundException, ConfigFailException {
        ServiceName[] serviceNameList = this.room.getAllServiceNames();
        this.autoritiesList = this.room.getAuthorities();
        int i = 0;
        while (i < this.autoritiesList.length) {
            Authority auth = this.autoritiesList[i];
            AuthorityService[] authorityServiceList = auth.getServices();
            this.room.updateAuthority(auth);
            ++i;
        }
        TCDSecureSuite.logger.debug((Object)"TRUSTED\tConfigService");
    }

    public Authority[] getAutoritiesList() throws SecureStoreException, ASN1Exception {
        this.autoritiesList = this.room.getAuthorities();
        TCDSecureSuite.logger.debug((Object)"TRUSTED\tGetAuthoritiesList");
        return this.autoritiesList;
    }

    public CertProfile[] getCaCertProfileList() throws SecureStoreException {
        this.caCertProfileList = this.room.getCaCertificates();
        TCDSecureSuite.logger.debug((Object)"TRUSTED\tGetCaCertProfileList");
        return this.caCertProfileList;
    }

    public CertProfile[] getTrustedCertProfileList() throws SecureStoreException {
        this.trustedCertProfileList = this.room.getTrustedCertificates();
        TCDSecureSuite.logger.debug((Object)"TRUSTED\tGetTrustedCertProfileList");
        return this.trustedCertProfileList;
    }

    public void setTrustedPolicies(TrustedPolicies policies) throws ConfigFailException {
        this.room.setTrustedPolicies(policies);
        TCDSecureSuite.logger.debug((Object)("TRUSTED\tSet trusted policies " + policies));
    }

    public void updateAuthority(Authority authority) throws ProfileAlreadyExistException, ProfileNotFoundException, ConfigFailException {
        this.room.updateAuthority(authority);
        TCDSecureSuite.logger.debug((Object)("TRUSTED\tUpdated authority " + authority));
    }
}

