/*
 * Decompiled with CFR 0.152.
 */
package samples;

import commond.SpringUtilities;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import samples.AuthenPackage;
import samples.FormNotValidException;
import samples.PkiTheme;
import th.co.oga.security.pki.HouseKeeping.KeeperFatalException;

public class LoginForm
extends JDialog {
    public static final long serialVersionUID = 1L;
    private JLabel blankLabel = new JLabel("");
    private JLabel userLabel = new JLabel("User ID", 11);
    private JLabel passLabel = new JLabel("Password", 11);
    private JButton submit = new JButton("Submit");
    private JTextField userInput = new JTextField(10);
    private JTextField passInput = new JPasswordField(10);
    private boolean validated = false;
    private AuthenPackage authen;

    public LoginForm() throws KeeperFatalException {
        super(new JFrame("PKI Profile Login"), "PKI Profile Login", true);
        super.setLocation(100, 100);
        this.setDefaultCloseOperation(1);
        this.submit.setActionCommand("ButtonPressed");
        this.submit.addActionListener(new ButtonHandler());
        Container p = this.getRootPane().getContentPane();
        p.setLayout(new SpringLayout());
        p.add(this.userLabel);
        this.userLabel.setLabelFor(this.userInput);
        p.add(this.userInput);
        p.add(this.passLabel);
        this.passLabel.setLabelFor(this.passInput);
        p.add(this.passInput);
        p.add(this.blankLabel);
        this.blankLabel.setLabelFor(this.submit);
        p.add(this.submit);
        SpringUtilities.makeCompactGrid(p, 3, 2, 3, 3, 3, 3);
        p.setBackground(PkiTheme.Standard.getBackgroundColor());
        p.setForeground(PkiTheme.Standard.getForegroundColor());
        this.pack();
    }

    public AuthenPackage getAuthenPackage(String user) throws FormNotValidException {
        this.authen = new AuthenPackage();
        this.authen.setAgent(user);
        this.userInput.setText(user);
        this.setModal(true);
        this.setVisible(true);
        if (!this.validated) {
            throw new FormNotValidException("PKI Sotore login", "Login data not supplied !");
        }
        return this.authen;
    }

    class ButtonHandler
    implements ActionListener {
        ButtonHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (LoginForm.this.userInput.getText().length() > 0 && LoginForm.this.passInput.getText().length() > 0) {
                LoginForm.this.authen = new AuthenPackage(LoginForm.this.userInput.getText(), LoginForm.this.passInput.getText());
                LoginForm.this.validated = true;
                LoginForm.this.setVisible(false);
            }
        }
    }
}

