/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import th.co.oga.security.pki.HouseKeeping.KeeperFatalException;
import th.co.oga.security.pki.HouseKeeping.KeeperSoftException;
import th.co.oga.security.pki.HouseKeeping.RoomCloseException;
import ui.TCDSecureSuite;
import ui.agent.ChangePin;

public class TCDAgentMenu
extends JMenu {
    private static final long serialVersionUID = 1L;
    private JMenuItem mnuRegisterNewAgent;
    private JMenuItem mnuSignOn;
    private JMenuItem mnuCryptographicPolicies;
    private JMenuItem mnuChangePin;
    private JMenuItem mnuDelete;
    private JMenuItem mnuLogout;
    private JMenuItem mnuExit;
    private TCDSecureSuite theSuite;
    private TCDAgentMenu mnu = this;
    private JMenuItem mnuScanToken;

    public TCDAgentMenu(TCDSecureSuite theSuite) {
        super("Agent");
        this.setMnemonic('A');
        this.theSuite = theSuite;
        this.setName("Agent");
        this.instantiateMenuItem();
        this.initialiseListener();
        this.addMenuItem();
        this.setNotAuthorised();
    }

    public void instantiateMenuItem() {
        this.mnuRegisterNewAgent = new JMenuItem("Register New Agent");
        this.mnuSignOn = new JMenuItem("Sign On");
        this.mnuCryptographicPolicies = new JMenuItem("Cryptographic Policies");
        this.mnuScanToken = new JMenuItem("Scan Token");
        this.mnuChangePin = new JMenuItem("Change PIN");
        this.mnuDelete = new JMenuItem("Delete");
        this.mnuLogout = new JMenuItem("Logout");
        this.mnuExit = new JMenuItem("Exit");
    }

    public void initialiseListener() {
        this.mnuRegisterNewAgent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Menu: Register New Agent");
                TCDAgentMenu.this.theSuite.showAgentRegistration();
            }
        });
        this.mnuSignOn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Menu: Sign On");
                TCDAgentMenu.this.theSuite.showSignOn();
            }
        });
        this.mnuCryptographicPolicies.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Menu: Cryptographic Policy");
                TCDAgentMenu.this.theSuite.showCryptographic();
            }
        });
        this.mnuChangePin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChangePin dialog = TCDAgentMenu.this.theSuite.showChangePin();
            }
        });
        this.mnuLogout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    TCDAgentMenu.this.theSuite.setSignOut();
                }
                catch (RoomCloseException e1) {
                    TCDAgentMenu.this.theSuite.showWarningDialog("Sign Out", "Failed during signing out.\nYou have signed out.");
                    e1.printStackTrace();
                }
                TCDAgentMenu.this.theSuite.showInformationDialog("Sign Out", "You have signed out.");
                TCDAgentMenu.this.theSuite.exit();
            }
        });
        this.mnuDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(null, "All of your privacy information will be cleared,\nAre you sure to delete your information in your safe space.", TCDAgentMenu.this.mnu.getName(), 0);
                if (result == 0) {
                    try {
                        TCDAgentMenu.this.theSuite.wipeRoom();
                        TCDAgentMenu.this.theSuite.showInformationDialog(TCDAgentMenu.this.mnu, "Privacy Room Deleted\nYou have been signed out.");
                        TCDAgentMenu.this.theSuite.setSignOut();
                        TCDAgentMenu.this.theSuite.showBlankScreen();
                    }
                    catch (KeeperFatalException e1) {
                        TCDAgentMenu.this.theSuite.showErrorDialog(TCDAgentMenu.this.mnu, e1.getMessage());
                        e1.printStackTrace();
                    }
                    catch (KeeperSoftException e1) {
                        TCDAgentMenu.this.theSuite.showErrorDialog(TCDAgentMenu.this.mnu, e1.getMessage());
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.mnuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (TCDAgentMenu.this.theSuite.getRoom() != null) {
                        TCDAgentMenu.this.theSuite.setSignOut();
                        System.out.println("Set signout");
                    }
                }
                catch (RoomCloseException e1) {
                    e1.printStackTrace();
                }
                TCDAgentMenu.this.theSuite.exit();
            }
        });
        this.mnuScanToken.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println("Scan Token");
                TCDAgentMenu.this.theSuite.scanHsm();
            }
        });
    }

    public void addMenuItem() {
        this.add(this.mnuRegisterNewAgent);
        this.add(this.mnuSignOn);
        this.add(this.mnuCryptographicPolicies);
        this.add(this.mnuChangePin);
        this.add(this.mnuDelete);
        this.add(this.mnuLogout);
        this.add(new JSeparator());
        this.add(this.mnuScanToken);
        this.add(new JSeparator());
        this.add(this.mnuExit);
    }

    public void setAuthorised() {
        this.mnuRegisterNewAgent.setEnabled(false);
        this.mnuSignOn.setEnabled(false);
        this.mnuCryptographicPolicies.setEnabled(true);
        this.mnuChangePin.setEnabled(true);
        this.mnuDelete.setEnabled(true);
        this.mnuLogout.setEnabled(true);
        this.mnuScanToken.setEnabled(true);
    }

    public void setNotAuthorised() {
        this.mnuRegisterNewAgent.setEnabled(true);
        this.mnuSignOn.setEnabled(true);
        this.mnuCryptographicPolicies.setEnabled(false);
        this.mnuChangePin.setEnabled(false);
        this.mnuDelete.setEnabled(false);
        this.mnuLogout.setEnabled(false);
        this.mnuScanToken.setEnabled(false);
    }
}

