/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import ui.TCDSecureSuite;

public class TCDCryptographicMenu
extends JMenu {
    private static final long serialVersionUID = 1L;
    private JMenuItem mnuSignData;
    private JMenuItem mnuEncryptData;
    private JMenuItem mnuEncryptFile;
    private JMenuItem mnuDecryptFile;
    private TCDSecureSuite theSuite;

    public TCDCryptographicMenu(TCDSecureSuite theSuite) {
        super("Cryptographic");
        this.setMnemonic('C');
        this.theSuite = theSuite;
        this.instantiateMenuItem();
        this.initialiseListener();
        this.addMenuItem();
        this.setNotAuthorised();
    }

    public void instantiateMenuItem() {
        this.mnuSignData = new JMenuItem("Sign Data");
        this.mnuEncryptData = new JMenuItem("Encrypt Data");
        this.mnuEncryptFile = new JMenuItem("Encrypt File");
        this.mnuDecryptFile = new JMenuItem("Decrypt File");
    }

    public void initialiseListener() {
        this.mnuSignData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Menu: Sign Data");
                TCDCryptographicMenu.this.theSuite.showCryptoSigning();
            }
        });
        this.mnuEncryptData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Menu: Encrypt Data");
                TCDCryptographicMenu.this.theSuite.showCryptoEncryptData();
            }
        });
        this.mnuEncryptFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Menu: Encrypt File");
                TCDCryptographicMenu.this.theSuite.showCryptoEncryptFile();
            }
        });
        this.mnuDecryptFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Menu: Decrypt File");
                TCDCryptographicMenu.this.theSuite.showCryptoDecryptFile();
            }
        });
    }

    public void addMenuItem() {
        this.add(this.mnuSignData);
        this.add(this.mnuEncryptData);
        this.add(new JSeparator());
        this.add(this.mnuEncryptFile);
        this.add(this.mnuDecryptFile);
    }

    public void setAuthorised() {
        this.mnuSignData.setEnabled(true);
        this.mnuEncryptData.setEnabled(true);
        this.mnuEncryptFile.setEnabled(true);
        this.mnuDecryptFile.setEnabled(true);
    }

    public void setNotAuthorised() {
        this.mnuSignData.setEnabled(false);
        this.mnuEncryptData.setEnabled(false);
        this.mnuEncryptFile.setEnabled(false);
        this.mnuDecryptFile.setEnabled(false);
    }
}

