/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import ui.TCDSecureSuite;
import ui.help.SystemInfo;

public class TCDHelpMenu
extends JMenu {
    private static final long serialVersionUID = 1L;
    private JMenuItem mnuHelp;
    private JMenuItem mnuLogManager;
    private JMenuItem mnuAbout;
    private JMenuItem mnuSysInfo;
    private TCDSecureSuite theSuite;
    private SystemInfo sysInfo;

    public TCDHelpMenu(TCDSecureSuite theSuite) {
        super("Help");
        this.setMnemonic('H');
        this.theSuite = theSuite;
        this.instantiateMenuItem();
        this.initialiseListener();
        this.addMenuItem();
    }

    public void instantiateMenuItem() {
        this.mnuHelp = new JMenuItem("Help");
        this.mnuLogManager = new JMenuItem("Log Manager");
        this.mnuAbout = new JMenuItem("About");
        this.mnuSysInfo = new JMenuItem("SystemInfo");
    }

    public void initialiseListener() {
        this.mnuHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Menu: help");
                TCDHelpMenu.this.theSuite.showHelp("Help", "help.html");
            }
        });
        this.mnuLogManager.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Menu: Log Manager");
                TCDHelpMenu.this.theSuite.showLogManager();
            }
        });
        this.mnuAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Menu: mnuAbout");
                TCDHelpMenu.this.theSuite.showAbout("Help", "about.html");
            }
        });
        this.mnuSysInfo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Menu: System Info");
                TCDHelpMenu.this.sysInfo = new SystemInfo(TCDHelpMenu.this.theSuite.getRoom());
                TCDHelpMenu.this.sysInfo.Active();
            }
        });
    }

    public void addMenuItem() {
        this.add(this.mnuHelp);
        this.add(this.mnuLogManager);
        this.add(this.mnuSysInfo);
        this.add(new JSeparator());
        this.add(this.mnuAbout);
    }

    public void setAuthorised() {
        this.mnuLogManager.setEnabled(true);
    }

    public void setNotAuthorised() {
        this.mnuLogManager.setEnabled(false);
    }
}

