/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import management.CertificateManager;
import management.CryptographicManager;
import management.SecureAgentManager;
import management.SecurePackageManager;
import management.TrustedManager;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Certification.CSRProfile;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.HouseKeeping.AgentProfile;
import th.co.oga.security.pki.HouseKeeping.HouseKeeper;
import th.co.oga.security.pki.HouseKeeping.KeeperFatalException;
import th.co.oga.security.pki.HouseKeeping.KeeperSoftException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.HouseKeeping.RoomCloseException;
import th.co.oga.security.pki.HouseKeeping.SaveHouse;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Trusted.Authority;
import ui.ProgressDialog;
import ui.TCDMenuBar;
import ui.agent.AgentRegistration;
import ui.agent.ChangePin;
import ui.agent.Cryptographic;
import ui.agent.SignOn;
import ui.ca.CARegister;
import ui.ca.CARegisterDialog;
import ui.ca.CATrustedPolicies;
import ui.ca.CSRExport;
import ui.ca.CSROnlineSend;
import ui.ca.CSRView;
import ui.ca.CertFileExport;
import ui.ca.CertFileImport;
import ui.ca.CertificateRequest;
import ui.ca.CertificateStoreManager;
import ui.ca.PKIRepositories;
import ui.crypto.DecryptFile;
import ui.crypto.EncryptData;
import ui.crypto.EncryptFile;
import ui.crypto.Signing;
import ui.help.About;
import ui.help.HelpTopic;
import ui.help.LogManager;
import ui.packaging.DataEnvelope;
import ui.packaging.DataSigning;
import ui.packaging.OpenEnvelope;
import ui.packaging.SignedDataViewer;

public class TCDSecureSuite
extends JFrame {
    public static final int CRL_DAEMON = 34874;
    JFileChooser fileChooser = new JFileChooser(SaveHouse.userHome);
    public static String DEFAULT_DIR = "c:/cryptoga";
    public static String DEFAULT_ROOM_DIR = String.valueOf(DEFAULT_DIR) + "/rooms";
    public static String DEFAULT_HELP_DIR = String.valueOf(DEFAULT_DIR) + "/help";
    public static String DEFAULT_LOG_FILENAME = "tcd.log";
    public static String DEFAULT_LOG_DIR = DEFAULT_DIR;
    public static String DEFAULT_LOG_PATH = DEFAULT_DIR;
    public static DateFormat df = DateFormat.getDateInstance(2, Locale.US);
    public static String DEFAULT_RECIPIENT = "prl@scitech.au.edu";
    private static final long serialVersionUID = 1L;
    private TCDMenuBar menuBar;
    private String agentId;
    private String agentName;
    private String commonName;
    private Room room;
    private HouseKeeper house;
    public static Logger logger = Logger.getLogger((String)"TCDPKI");
    SecureAgentManager secureAgentManager = null;
    TrustedManager trustedManager = null;
    CertificateManager certificateManager = null;
    CryptographicManager cryptographicManager = null;
    SecurePackageManager securePackageManager = null;
    private ProgressDialog progressDialog;
    private CARegisterDialog theCARegisterDialog = null;

    public TCDSecureSuite() {
        super("TCD Secure Suite");
        this.setName("TCD Secure Suite");
        TCDSecureSuite.setDefaultLookAndFeelDecorated(true);
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setIconImage(this.getToolkit().getImage("images/logo.jpg"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                try {
                    TCDSecureSuite.this.setSignOut();
                    System.exit(0);
                }
                catch (RoomCloseException e1) {
                    e1.printStackTrace();
                    System.exit(-1);
                }
            }
        });
        this.menuBar = new TCDMenuBar(this);
        this.setJMenuBar(this.menuBar);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        try {
            this.house = new HouseKeeper();
            DEFAULT_HELP_DIR = this.house.getHelpLocaltion();
            this.secureAgentManager = new SecureAgentManager(this.house);
            this.room = null;
        }
        catch (KeeperFatalException e) {
            this.showErrorDialog(this, "Fatal error during start up.\nTCDSecureSuite cannot start.");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public JFileChooser getFileChosser() {
        return this.fileChooser;
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        new TCDSecureSuite();
    }

    public SecureAgentManager getSecureAgentManager() {
        return this.secureAgentManager;
    }

    public void setSignOn(String agentId, String pin) {
        try {
            this.agentId = agentId;
            this.room = this.secureAgentManager.signOn(agentId, pin);
            AgentProfile profile = this.room.getOwner();
            this.agentName = profile.getName();
            this.commonName = profile.getSubjectName().getCommonName();
            this.setTitle("TCD Secure Suite [" + this.agentName + "'s Privacy Room]");
            this.showInformationDialog(this, "Welcome " + agentId);
            if (DEFAULT_HELP_DIR == null) {
                DEFAULT_HELP_DIR = this.room.getHelpLocaltion();
            }
            DEFAULT_LOG_DIR = this.room.getLogLocaltion();
            DEFAULT_LOG_PATH = String.valueOf(DEFAULT_LOG_DIR) + "/" + DEFAULT_LOG_FILENAME;
            File logDir = new File(DEFAULT_LOG_DIR);
            System.out.println("Default Log Path = " + DEFAULT_LOG_PATH);
            if (!logDir.exists()) {
                logDir.mkdirs();
                System.out.println("Create log directory");
            }
            LogManager.archiveLog(DEFAULT_LOG_DIR, DEFAULT_LOG_FILENAME);
            String pattern = "%d\t%p\t%m\t%n";
            PatternLayout layout = new PatternLayout(pattern);
            System.out.println("Logger location: " + this.getLogFilename());
            try {
                logger.addAppender((Appender)new FileAppender((Layout)layout, this.getLogFilename(), true));
            }
            catch (IOException e1) {
                this.showWarningDialog(this, "Cannot get logger. Application will not log.");
                e1.printStackTrace();
            }
            logger.info((Object)("GENERAL\tAgent " + agentId + " : " + this.agentName + " logged in."));
            logger.debug((Object)"GENERAL\tRoom opened.");
            this.menuBar.getMnuAgent().setAuthorised();
            this.menuBar.getMnuTrusted().setAuthorised();
            this.menuBar.getMnuCryptographic().setAuthorised();
            this.menuBar.getMnuDataPackaging().setAuthorised();
            this.menuBar.getMnuHelp().setAuthorised();
            this.trustedManager = new TrustedManager(this.room);
            this.cryptographicManager = new CryptographicManager(this.room);
            this.securePackageManager = new SecurePackageManager(this.room);
            System.out.println("TCDSecurePackagin : " + this.securePackageManager);
            this.certificateManager = new CertificateManager(this.room);
        }
        catch (SecureStoreException e) {
            this.showInformationDialog(this, e.getMessage());
            e.printStackTrace();
        }
        catch (KeeperFatalException e) {
            this.showErrorDialog(this, "Invalid username/password\n" + e.getMessage());
            e.printStackTrace();
        }
        catch (KeeperSoftException e) {
            this.showErrorDialog(this, "Invalid username/password\n" + e.getMessage());
            e.printStackTrace();
        }
        catch (AlgorithmSupportException e) {
            this.showErrorDialog(this, "Invalid username/password\n" + e.getMessage());
            e.printStackTrace();
        }
        catch (ASN1Exception e) {
            this.showErrorDialog(this, "Invalid username/password\n" + e.getMessage());
            e.printStackTrace();
        }
        catch (EntryNotFoundException e) {
            this.showErrorDialog(this, "Invalid username/password\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void showInformationDialog(Object owner, String message) {
        String title = owner instanceof Component ? ((Component)owner).getName() : (owner instanceof String ? (String)owner : "TCDSecureSuite");
        int style = 1;
        this.showMessage(title, message, style);
    }

    public void showWarningDialog(Object owner, String message) {
        String title = owner instanceof Component ? String.valueOf(((Component)owner).getName()) + " Warning" : (owner instanceof String ? (String)owner : "TCDSecureSuite");
        int style = 2;
        this.showMessage(title, message, style);
    }

    public void showErrorDialog(Object owner, String message) {
        String title = owner instanceof Component ? String.valueOf(((Component)owner).getName()) + " Error" : (owner instanceof String ? (String)owner : "TCDSecureSuite");
        int style = 0;
        this.showMessage(title, message, style);
    }

    public void showMessage(String title, String message, int style) {
        message = this.prepareMessage(message);
        JOptionPane.showMessageDialog(null, message, title, style);
    }

    public void showMessage(String title, String message, int style, Icon icon) {
        message = this.prepareMessage(message);
        JOptionPane.showMessageDialog(null, message, title, -1, icon);
    }

    public void scanHsm() {
        try {
            this.room.scandTokens();
        }
        catch (Exception e) {
            this.showErrorDialog("Operation Fail", e.getMessage());
        }
    }

    public void setSignOut() throws RoomCloseException {
        System.out.println("setSignOut");
        if (this.room != null) {
            System.out.println("Room close");
            this.room.close();
            logger.debug((Object)"GENERAL\tRoom closed.");
            this.room = null;
            logger.info((Object)("GENERAL\tAgent " + this.agentId + " : " + this.agentName + " logged out"));
        }
        this.menuBar.getMnuAgent().setNotAuthorised();
        this.menuBar.getMnuTrusted().setNotAuthorised();
        this.menuBar.getMnuCryptographic().setNotAuthorised();
        this.menuBar.getMnuDataPackaging().setNotAuthorised();
        this.menuBar.getMnuHelp().setNotAuthorised();
        this.trustedManager = null;
        this.certificateManager = null;
        this.cryptographicManager = null;
        this.securePackageManager = null;
        this.setTitle("TCD Secure Suite");
        this.showBlankScreen();
    }

    public void wipeRoom() throws KeeperFatalException, KeeperSoftException {
        this.secureAgentManager.wipeRoom(this.room);
    }

    public void changePin(String oldPin, String newPin) throws KeeperFatalException, KeeperSoftException {
        this.secureAgentManager.changePin(this.room, oldPin, newPin);
    }

    public Room getRoom() {
        return this.room;
    }

    public HouseKeeper getHouse() {
        return this.house;
    }

    public Cryptographic showCryptographic() {
        Cryptographic panel = new Cryptographic(this);
        this.setContentPane(panel);
        this.setVisible(true);
        return panel;
    }

    public void showAgentRegistration() {
        this.setContentPane(new AgentRegistration(this));
        this.setVisible(true);
    }

    public CARegister showCARegister() {
        CARegister caRegisterPanel = new CARegister(this);
        this.setContentPane(caRegisterPanel);
        this.setVisible(true);
        return caRegisterPanel;
    }

    public void showTrustedPolicies() {
        this.setContentPane(new CATrustedPolicies(this));
        this.setVisible(true);
    }

    public void showBlankScreen() {
        this.setContentPane(new JPanel());
        this.setVisible(true);
    }

    public void showSignOn() {
        this.showBlankScreen();
        SignOn dialog = new SignOn(this);
        dialog.setVisible(true);
    }

    public CertificateRequest showCertificateRequest() {
        CertificateRequest panel = new CertificateRequest(this);
        this.setContentPane(panel);
        this.setVisible(true);
        return panel;
    }

    public PKIRepositories showPKIRepositories() {
        PKIRepositories panel = new PKIRepositories(this);
        this.setContentPane(panel);
        this.setVisible(true);
        return panel;
    }

    public CertificateStoreManager showCertificateStoreManager() {
        CertificateStoreManager panel = new CertificateStoreManager(this, 0);
        this.setContentPane(panel);
        this.setVisible(true);
        return panel;
    }

    public CertificateStoreManager showCertificateStoreManager(int group) {
        CertificateStoreManager panel = new CertificateStoreManager(this, group);
        this.setContentPane(panel);
        this.setVisible(true);
        return panel;
    }

    public CertificateStoreManager showAgentCertificate() {
        CertificateStoreManager panel = new CertificateStoreManager(this, CertificateStoreManager.TAB_AGENT);
        this.setContentPane(panel);
        this.setVisible(true);
        return panel;
    }

    public CertificateStoreManager showAuthorityCertificate() {
        CertificateStoreManager panel = new CertificateStoreManager(this, CertificateStoreManager.TAB_CA);
        this.setContentPane(panel);
        this.setVisible(true);
        return panel;
    }

    public CertificateStoreManager showPeopleCertificate() {
        CertificateStoreManager panel = new CertificateStoreManager(this, CertificateStoreManager.TAB_PEOPLE);
        this.setContentPane(panel);
        this.setVisible(true);
        return panel;
    }

    public Signing showCryptoSigning() {
        Signing panel = new Signing(this);
        this.setContentPane(panel);
        this.setVisible(true);
        return panel;
    }

    public EncryptData showCryptoEncryptData() {
        EncryptData panel = new EncryptData(this);
        this.setContentPane(panel);
        this.setVisible(true);
        return panel;
    }

    public EncryptFile showCryptoEncryptFile() {
        EncryptFile panel = new EncryptFile(this);
        this.setContentPane(panel);
        this.setVisible(true);
        return panel;
    }

    public DecryptFile showCryptoDecryptFile() {
        DecryptFile panel = new DecryptFile(this);
        this.setContentPane(panel);
        this.setVisible(true);
        return panel;
    }

    public DataSigning showPKCSSignData() {
        DataSigning panel = new DataSigning(this);
        this.setContentPane(panel);
        this.setVisible(true);
        return panel;
    }

    public DataEnvelope showPKCSEnvelopeData() {
        DataEnvelope panel = new DataEnvelope(this);
        this.setContentPane(panel);
        this.setVisible(true);
        return panel;
    }

    public SignedDataViewer showPKCSSignedDataViewer() {
        SignedDataViewer panel = new SignedDataViewer(this);
        this.setContentPane(panel);
        this.setVisible(true);
        return panel;
    }

    public OpenEnvelope showPKCSOpenEnvelopeData() {
        OpenEnvelope panel = new OpenEnvelope(this);
        this.setContentPane(panel);
        this.setVisible(true);
        return panel;
    }

    public void exit() {
        try {
            this.setSignOut();
        }
        catch (RoomCloseException e) {
            e.printStackTrace();
        }
        this.dispose();
    }

    public TrustedManager getTrustedManager() {
        return this.trustedManager;
    }

    public void showCSRExport(CSRProfile csrProfile) {
        CSRExport fileExport = new CSRExport(this, csrProfile);
        fileExport.setVisible(true);
    }

    public CertificateManager getCertificateManager() {
        if (this.certificateManager == null) {
            this.certificateManager = new CertificateManager(this.room);
        }
        return this.certificateManager;
    }

    public CertFileImport showCertFileImport(int currentTab) {
        CertFileImport fileImport = new CertFileImport(this, currentTab);
        fileImport.setVisible(true);
        return fileImport;
    }

    public void showCertFileExport(int exportTab, int id) {
        CertFileExport fileExport = new CertFileExport(this, exportTab, id);
        fileExport.setVisible(true);
    }

    public CryptographicManager getCryptographicManager() {
        return this.cryptographicManager;
    }

    public CSRView showCSRView(CertProfile certProfile) {
        CSRView dialog = new CSRView(this, certProfile);
        dialog.setVisible(true);
        return dialog;
    }

    public void showHelp(String topic, String filename) {
        String fileUrl = "file:" + DEFAULT_HELP_DIR + "/" + filename;
        System.out.println("Show help :" + fileUrl);
        HelpTopic dialog = new HelpTopic(this, topic, fileUrl);
        dialog.setVisible(true);
    }

    public LogManager showLogManager() {
        LogManager panel = new LogManager(this, this.getLogFilename());
        this.setContentPane(panel);
        this.setVisible(true);
        return panel;
    }

    public void showAbout(String topic, String filename) {
        String fileUrl = "file:" + DEFAULT_HELP_DIR + "/" + filename;
        System.out.println("Show About :" + fileUrl);
        About dialog = new About(this, topic, fileUrl);
        dialog.setVisible(true);
    }

    public SecurePackageManager getSecurePackageManager() throws SecureStoreException, AlgorithmSupportException, EntryNotFoundException {
        System.out.println("getSecurePackageManager : " + this.securePackageManager);
        return new SecurePackageManager(this.room);
    }

    public ChangePin showChangePin() {
        ChangePin dialog = new ChangePin(this);
        dialog.setVisible(true);
        return dialog;
    }

    private String prepareMessage(String str) {
        int limitedLength;
        System.out.println("STR " + str);
        if (str == null) {
            return str;
        }
        StringBuffer preparedStr = new StringBuffer(str);
        int startingPoint = limitedLength = 80;
        while (str.length() > startingPoint) {
            int lastSpace = preparedStr.substring(0, startingPoint).lastIndexOf(32, startingPoint);
            startingPoint += limitedLength;
            preparedStr.insert(lastSpace, "\n");
        }
        return preparedStr.toString();
    }

    public void showProgressDialog(Object owner, String message) {
        String title = owner instanceof Component ? String.valueOf(((Component)owner).getName()) + " Error" : (owner instanceof String ? (String)owner : "TCDSecureSuite");
        int style = 1;
        String filename = String.valueOf(DEFAULT_DIR) + "/images/rhombus_2.gif";
        ImageIcon icon = new ImageIcon(filename);
        this.showMessage(title, message, style, icon);
    }

    public ProgressDialog showProgress() {
        if (this.progressDialog == null) {
            this.progressDialog = new ProgressDialog();
        }
        this.progressDialog.setVisible(true);
        return this.progressDialog;
    }

    public void hideProgress() {
        this.progressDialog.setVisible(false);
    }

    public String getAgentName() {
        return this.agentName;
    }

    public String getAgentHomeDir() {
        String dir = String.valueOf(DEFAULT_ROOM_DIR) + "/" + this.agentId;
        return dir;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public CSROnlineSend showCSROnlineSend(CSRProfile csrProfile) {
        CSROnlineSend dialog = new CSROnlineSend(this, csrProfile);
        dialog.setVisible(true);
        return dialog;
    }

    public static String formatDate(String d) {
        Date date;
        try {
            date = df.parse(d);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return d;
        }
        return df.format(date);
    }

    public static String formatDate(Date d) {
        return df.format(d);
    }

    public CARegisterDialog showCARegisterDialog(Authority authority, boolean b) {
        if (this.theCARegisterDialog != null) {
            this.theCARegisterDialog.setVisible(false);
            this.theCARegisterDialog.dispose();
            System.out.println("Dispose");
        }
        this.theCARegisterDialog = new CARegisterDialog(this, authority, b);
        this.theCARegisterDialog.setVisible(true);
        return this.theCARegisterDialog;
    }

    public String getLogFilename() {
        return DEFAULT_LOG_PATH;
    }
}

