/*
 * Decompiled with CFR 0.152.
 */
package ui.agent;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.security.Provider;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import management.SecureAgentManager;
import th.co.oga.security.pki.Engine.SecureProviderName;
import ui.TCDSecureSuite;
import ui.agent.InvalidInputException;
import ui.agent.PrivacyRoomLock;

public class AgentRegistration
extends JPanel {
    private AgentRegistration thePanel = this;
    private static final long serialVersionUID = 1L;
    private JButton btnBuild = null;
    private JButton btnCancel = null;
    private JButton btnHelp = null;
    private JComboBox cbxCryptoOperator = null;
    private JComboBox cbxStoreOperator = null;
    private JLabel lblAgentRegistration = null;
    private JLabel lblAgentID = null;
    private JLabel lblAgentName = null;
    private JLabel lblCommonName = null;
    private JLabel lblOrganization = null;
    private JLabel lblOrganizationUnit = null;
    private JLabel lblStreetAddress = null;
    private JLabel lblProvince = null;
    private JLabel lblLocality = null;
    private JLabel lblCountry = null;
    private JLabel lblEmailAddress = null;
    private JLabel lblCryptoOperator = null;
    private JLabel lblStoreOperator = null;
    private JPanel pnlCsrSubjectName = null;
    private JPanel pnlOperators = null;
    private JTextField txtAgentID = null;
    private JTextField txtAgentName = null;
    private JTextField txtCommonName = null;
    private JTextField txtOrganization = null;
    private JTextField txtOrganizationUnit = null;
    private JTextField txtStreetAddress = null;
    private JTextField txtProvince = null;
    private JTextField txtLocality = null;
    private JTextField txtCountry = null;
    private JTextField txtEmailAddress = null;
    private TCDSecureSuite theSuite = null;

    public AgentRegistration(TCDSecureSuite theSuite) {
        this.theSuite = theSuite;
        this.setName("Agent Registration");
        this.initialise();
    }

    private void initialise() {
        this.setBorder(new LineBorder(new Color(255, 255, 255)));
        this.setLayout(null);
        this.setFont(new Font("sansserif", 0, 10));
        this.add((Component)this.getBtnBuild(), this.getBtnBuild().getName());
        this.add((Component)this.getBtnCancel(), this.getBtnCancel().getName());
        this.add((Component)this.getBtnHelp(), this.getBtnHelp().getName());
        this.add((Component)this.getPnlCsrSubjectName(), this.getPnlCsrSubjectName().getName());
        this.add((Component)this.getPnlOperators(), this.getPnlOperators().getName());
        this.add((Component)this.getLblAgentRegistration(), this.getLblAgentRegistration().getName());
        this.add((Component)this.getLblAgentID(), this.getLblAgentID().getName());
        this.add((Component)this.getLblAgentName(), this.getLblAgentName().getName());
        this.add((Component)this.getTxtAgentID(), this.getTxtAgentID().getName());
        this.add((Component)this.getTxtAgentName(), this.getTxtAgentName().getName());
    }

    private JButton getBtnBuild() {
        if (this.btnBuild == null) {
            this.btnBuild = new JButton();
            this.btnBuild.setName("btnBuild");
            this.btnBuild.setText("Build");
            this.btnBuild.setBounds(220, 490, 100, 30);
            this.btnBuild.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    try {
                        AgentRegistration.this.validateInput();
                        PrivacyRoomLock dialog = new PrivacyRoomLock(AgentRegistration.this.theSuite);
                        dialog.setVisible(true);
                        if (!dialog.isTaskDone()) {
                            return;
                        }
                        String pin = dialog.getNewPin();
                        String confirm = dialog.getConfirm();
                        AgentRegistration.this.applyChange(pin);
                        AgentRegistration.this.theSuite.showInformationDialog(AgentRegistration.this.thePanel, "The agent has been built");
                        AgentRegistration.this.theSuite.showBlankScreen();
                    }
                    catch (InvalidInputException e1) {
                        AgentRegistration.this.theSuite.showErrorDialog(AgentRegistration.this.thePanel, e1.getMessage());
                        e1.printStackTrace();
                    }
                    catch (Throwable e1) {
                        AgentRegistration.this.theSuite.showErrorDialog(AgentRegistration.this.thePanel, e1.getMessage());
                        e1.printStackTrace();
                    }
                }
            });
        }
        return this.btnBuild;
    }

    private void validateInput() throws InvalidInputException {
        if (this.txtAgentID.getText().trim().length() == 0) {
            throw new InvalidInputException("Agent ID is empty.");
        }
        if (this.txtAgentName.getText().trim().length() == 0) {
            throw new InvalidInputException("Agent name is empty.");
        }
        if (this.txtCommonName.getText().trim().length() == 0) {
            throw new InvalidInputException("Common name is empty.");
        }
        if (this.txtOrganization.getText().trim().length() == 0) {
            throw new InvalidInputException("Organization is empty.");
        }
        if (this.txtOrganizationUnit.getText().trim().length() == 0) {
            throw new InvalidInputException("Organization unit is empty.");
        }
        if (this.txtStreetAddress.getText().trim().length() == 0) {
            throw new InvalidInputException("Street address is empty.");
        }
        if (this.txtProvince.getText().trim().length() == 0) {
            throw new InvalidInputException("Province is empty.");
        }
        if (this.txtLocality.getText().trim().length() == 0) {
            throw new InvalidInputException("Locality is empty.");
        }
        if (this.txtCountry.getText().trim().length() != 2) {
            throw new InvalidInputException("Country code must be exactly 2 alphabets.");
        }
        if (this.txtEmailAddress.getText().trim().length() == 0) {
            throw new InvalidInputException("E-mail is empty.");
        }
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setName("btnCancel");
            this.btnCancel.setText("Cancel");
            this.btnCancel.setBounds(340, 490, 100, 30);
            this.btnCancel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    AgentRegistration.this.theSuite.showBlankScreen();
                }
            });
        }
        return this.btnCancel;
    }

    private JButton getBtnHelp() {
        if (this.btnHelp == null) {
            this.btnHelp = new JButton();
            this.btnHelp.setName("btnHelp");
            this.btnHelp.setText("Help");
            this.btnHelp.setBounds(460, 490, 100, 30);
            this.btnHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("HELP: agentregistration.html");
                    AgentRegistration.this.theSuite.showHelp("Help", "agentregistration.html");
                }
            });
        }
        return this.btnHelp;
    }

    private JComboBox getCbxCryptoOperator() {
        if (this.cbxCryptoOperator == null) {
            String[] list = SecureProviderName.getAllName();
            this.cbxCryptoOperator = new JComboBox<String>(list);
            this.cbxCryptoOperator.setName("cbxCryptoOperator");
            this.cbxCryptoOperator.setBackground(Color.white);
            this.cbxCryptoOperator.setBounds(150, 25, 180, 25);
        }
        return this.cbxCryptoOperator;
    }

    private JComboBox getCbxStoreOperator() {
        if (this.cbxStoreOperator == null) {
            String[] list = SecureProviderName.getAllName();
            this.cbxStoreOperator = new JComboBox<String>(list);
            this.cbxStoreOperator.setName("cbxStoreOperator");
            this.cbxStoreOperator.setBackground(Color.white);
            this.cbxStoreOperator.setBounds(450, 25, 180, 25);
        }
        return this.cbxStoreOperator;
    }

    private JLabel getLblAgentRegistration() {
        if (this.lblAgentRegistration == null) {
            this.lblAgentRegistration = new JLabel();
            this.lblAgentRegistration.setName("lblAgentRegistration");
            this.lblAgentRegistration.setText("  Agent Registration");
            this.lblAgentRegistration.setHorizontalTextPosition(2);
            this.lblAgentRegistration.setVerticalTextPosition(0);
            this.lblAgentRegistration.setBorder(new LineBorder(new Color(255, 255, 255)));
            this.lblAgentRegistration.setBounds(10, 10, 760, 30);
        }
        return this.lblAgentRegistration;
    }

    private JLabel getLblAgentID() {
        if (this.lblAgentID == null) {
            this.lblAgentID = new JLabel();
            this.lblAgentID.setName("lblAgentID");
            this.lblAgentID.setText("Agent ID :");
            this.lblAgentID.setHorizontalTextPosition(4);
            this.lblAgentID.setVerticalTextPosition(0);
            this.lblAgentID.setBounds(50, 75, 80, 25);
        }
        return this.lblAgentID;
    }

    private JLabel getLblAgentName() {
        if (this.lblAgentName == null) {
            this.lblAgentName = new JLabel();
            this.lblAgentName.setName("lblAgentName");
            this.lblAgentName.setText("Agent Name :");
            this.lblAgentName.setHorizontalTextPosition(4);
            this.lblAgentName.setVerticalTextPosition(0);
            this.lblAgentName.setBounds(50, 100, 80, 25);
        }
        return this.lblAgentName;
    }

    private JLabel getLblCommonName() {
        if (this.lblCommonName == null) {
            this.lblCommonName = new JLabel();
            this.lblCommonName.setName("lblCommonName");
            this.lblCommonName.setText("* Common Name :");
            this.lblCommonName.setBounds(50, 25, 150, 25);
        }
        return this.lblCommonName;
    }

    private JLabel getLblOrganization() {
        if (this.lblOrganization == null) {
            this.lblOrganization = new JLabel();
            this.lblOrganization.setName("lblOrganization");
            this.lblOrganization.setText("Organization :");
            this.lblOrganization.setBounds(50, 50, 150, 25);
        }
        return this.lblOrganization;
    }

    private JLabel getLblOrganizationUnit() {
        if (this.lblOrganizationUnit == null) {
            this.lblOrganizationUnit = new JLabel();
            this.lblOrganizationUnit.setName("lblOrganizationUnit");
            this.lblOrganizationUnit.setText("Organization Unit :");
            this.lblOrganizationUnit.setBounds(50, 75, 150, 25);
        }
        return this.lblOrganizationUnit;
    }

    private JLabel getLblStreetAddress() {
        if (this.lblStreetAddress == null) {
            this.lblStreetAddress = new JLabel();
            this.lblStreetAddress.setName("lblStreetAddress");
            this.lblStreetAddress.setText("Street Address :");
            this.lblStreetAddress.setBounds(50, 100, 150, 25);
        }
        return this.lblStreetAddress;
    }

    private JLabel getLblProvince() {
        if (this.lblProvince == null) {
            this.lblProvince = new JLabel();
            this.lblProvince.setName("lblProvince");
            this.lblProvince.setText("Province :");
            this.lblProvince.setBounds(50, 125, 150, 25);
        }
        return this.lblProvince;
    }

    private JLabel getLblLocality() {
        if (this.lblLocality == null) {
            this.lblLocality = new JLabel();
            this.lblLocality.setName("lblLocality");
            this.lblLocality.setText("Locality/Province Code :");
            this.lblLocality.setBounds(50, 150, 150, 25);
        }
        return this.lblLocality;
    }

    private JLabel getLblCountry() {
        if (this.lblCountry == null) {
            this.lblCountry = new JLabel();
            this.lblCountry.setName("lblCountry");
            this.lblCountry.setText("Country :");
            this.lblCountry.setBounds(50, 175, 150, 25);
        }
        return this.lblCountry;
    }

    private JLabel getLblEmailAddress() {
        if (this.lblEmailAddress == null) {
            this.lblEmailAddress = new JLabel();
            this.lblEmailAddress.setName("lblEmailAddress");
            this.lblEmailAddress.setText("eMail Address :");
            this.lblEmailAddress.setBounds(50, 200, 150, 25);
        }
        return this.lblEmailAddress;
    }

    private JLabel getLblCryptoOperator() {
        this.lblCryptoOperator = new JLabel();
        this.lblCryptoOperator.setName("lblCryptoOperator");
        this.lblCryptoOperator.setText("Crypto Operator :");
        this.lblCryptoOperator.setBounds(50, 25, 100, 25);
        return this.lblCryptoOperator;
    }

    private JLabel getLblStoreOperator() {
        this.lblStoreOperator = new JLabel();
        this.lblStoreOperator.setName("lblStoreOperator");
        this.lblStoreOperator.setText("Store Operator :");
        this.lblStoreOperator.setBounds(350, 25, 100, 25);
        return this.lblStoreOperator;
    }

    private JPanel getPnlCsrSubjectName() {
        if (this.pnlCsrSubjectName == null) {
            this.pnlCsrSubjectName = new JPanel();
            this.pnlCsrSubjectName.setName("pnlCsrSubjectName");
            this.pnlCsrSubjectName.setBorder(new TitledBorder(new LineBorder(new Color(255, 255, 255)), "  CSR Subject Name : "));
            this.pnlCsrSubjectName.setLayout(null);
            this.pnlCsrSubjectName.setBounds(25, 140, 640, 250);
            this.pnlCsrSubjectName.add((Component)this.getLblCommonName(), this.getLblCommonName().getName());
            this.pnlCsrSubjectName.add((Component)this.getLblOrganization(), this.getLblOrganization().getName());
            this.pnlCsrSubjectName.add((Component)this.getLblOrganizationUnit(), this.getLblOrganizationUnit().getName());
            this.pnlCsrSubjectName.add((Component)this.getLblStreetAddress(), this.getLblStreetAddress().getName());
            this.pnlCsrSubjectName.add((Component)this.getLblProvince(), this.getLblProvince().getName());
            this.pnlCsrSubjectName.add((Component)this.getLblLocality(), this.getLblLocality().getName());
            this.pnlCsrSubjectName.add((Component)this.getLblCountry(), this.getLblCountry().getName());
            this.pnlCsrSubjectName.add((Component)this.getLblEmailAddress(), this.getLblEmailAddress().getName());
            this.pnlCsrSubjectName.add((Component)this.getTxtCommonName(), this.getTxtCommonName().getName());
            this.pnlCsrSubjectName.add((Component)this.getTxtOrganization(), this.getTxtOrganization().getName());
            this.pnlCsrSubjectName.add((Component)this.getTxtOrganizationUnit(), this.getTxtOrganizationUnit().getName());
            this.pnlCsrSubjectName.add((Component)this.getTxtStreetAddress(), this.getTxtStreetAddress().getName());
            this.pnlCsrSubjectName.add((Component)this.getTxtProvince(), this.getTxtProvince().getName());
            this.pnlCsrSubjectName.add((Component)this.getTxtLocality(), this.getTxtLocality().getName());
            this.pnlCsrSubjectName.add((Component)this.getTxtCountry(), this.getTxtCountry().getName());
            this.pnlCsrSubjectName.add((Component)this.getTxtEmailAddress(), this.getTxtEmailAddress().getName());
        }
        return this.pnlCsrSubjectName;
    }

    private JPanel getPnlOperators() {
        if (this.pnlOperators == null) {
            this.pnlOperators = new JPanel();
            this.pnlOperators.setName("pnlOperators");
            this.pnlOperators.setBorder(new TitledBorder(new LineBorder(new Color(255, 255, 255)), "  Operators : "));
            this.pnlOperators.setLayout(null);
            this.pnlOperators.setBounds(25, 400, 680, 70);
            this.pnlOperators.add((Component)this.getLblCryptoOperator(), this.getLblCryptoOperator().getName());
            this.pnlOperators.add((Component)this.getCbxCryptoOperator(), this.getCbxCryptoOperator().getName());
            this.pnlOperators.add((Component)this.getLblStoreOperator(), this.getLblStoreOperator().getName());
            this.pnlOperators.add((Component)this.getCbxStoreOperator(), this.getCbxStoreOperator().getName());
        }
        return this.pnlOperators;
    }

    private JTextField getTxtAgentID() {
        if (this.txtAgentID == null) {
            this.txtAgentID = new JTextField();
            this.txtAgentID.setName("txtAgentID");
            this.txtAgentID.setBounds(150, 75, 200, 25);
        }
        return this.txtAgentID;
    }

    private JTextField getTxtAgentName() {
        if (this.txtAgentName == null) {
            this.txtAgentName = new JTextField();
            this.txtAgentName.setName("txtAgentName");
            this.txtAgentName.setBounds(150, 100, 400, 25);
        }
        return this.txtAgentName;
    }

    private JTextField getTxtCommonName() {
        if (this.txtCommonName == null) {
            this.txtCommonName = new JTextField();
            this.txtCommonName.setName("txtCommonName");
            this.txtCommonName.setBounds(200, 25, 300, 25);
        }
        return this.txtCommonName;
    }

    private JTextField getTxtOrganization() {
        if (this.txtOrganization == null) {
            this.txtOrganization = new JTextField();
            this.txtOrganization.setName("txtOrganization");
            this.txtOrganization.setBounds(200, 50, 300, 25);
        }
        return this.txtOrganization;
    }

    private JTextField getTxtOrganizationUnit() {
        if (this.txtOrganizationUnit == null) {
            this.txtOrganizationUnit = new JTextField();
            this.txtOrganizationUnit.setName("txtOrganizationUnit");
            this.txtOrganizationUnit.setBounds(200, 75, 300, 25);
        }
        return this.txtOrganizationUnit;
    }

    private JTextField getTxtStreetAddress() {
        if (this.txtStreetAddress == null) {
            this.txtStreetAddress = new JTextField();
            this.txtStreetAddress.setName("txtStreetAddress");
            this.txtStreetAddress.setBounds(200, 100, 300, 25);
        }
        return this.txtStreetAddress;
    }

    private JTextField getTxtProvince() {
        if (this.txtProvince == null) {
            this.txtProvince = new JTextField();
            this.txtProvince.setName("txtProvince");
            this.txtProvince.setBounds(200, 125, 300, 25);
        }
        return this.txtProvince;
    }

    private JTextField getTxtLocality() {
        if (this.txtLocality == null) {
            this.txtLocality = new JTextField();
            this.txtLocality.setName("txtLocality");
            this.txtLocality.setBounds(200, 150, 300, 25);
        }
        return this.txtLocality;
    }

    private JTextField getTxtCountry() {
        if (this.txtCountry == null) {
            this.txtCountry = new JTextField();
            this.txtCountry.setName("txtCountry");
            this.txtCountry.setBounds(200, 175, 300, 25);
        }
        return this.txtCountry;
    }

    private JTextField getTxtEmailAddress() {
        if (this.txtEmailAddress == null) {
            this.txtEmailAddress = new JTextField();
            this.txtEmailAddress.setName("txtEmailAddress");
            this.txtEmailAddress.setBounds(200, 200, 300, 25);
        }
        return this.txtEmailAddress;
    }

    private void applyChange(String pin) throws Throwable {
        SecureAgentManager secureAgentManager = this.theSuite.getSecureAgentManager();
        String agentId = this.txtAgentID.getText();
        String agentName = this.txtAgentName.getText();
        Provider storeProvider = null;
        Provider cryptoProvider = null;
        String commonName = this.txtCommonName.getText();
        String country = this.txtCountry.getText();
        String locality = this.txtLocality.getText();
        String orgUnit = this.txtOrganizationUnit.getText();
        String org = this.txtOrganization.getText();
        String province = this.txtProvince.getText();
        String address = this.txtStreetAddress.getText();
        String email = this.txtEmailAddress.getText();
        String cryptoOperatorName = (String)this.cbxCryptoOperator.getSelectedItem();
        SecureProviderName CryptoSecureProviderName = SecureProviderName.getInstance((String)cryptoOperatorName);
        cryptoProvider = CryptoSecureProviderName.getProviderInstance();
        String storeOperatorName = (String)this.cbxStoreOperator.getSelectedItem();
        SecureProviderName StoresecureProviderName = SecureProviderName.getInstance((String)storeOperatorName);
        storeProvider = StoresecureProviderName.getProviderInstance();
        secureAgentManager.register(agentId, agentName, storeProvider, cryptoProvider, commonName, country, locality, orgUnit, org, province, address, email);
        secureAgentManager.buildRoom(agentId, pin);
    }
}

