/*
 * Decompiled with CFR 0.152.
 */
package ui.agent;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import ui.TCDSecureSuite;

public class ChangePin
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton btnChange = null;
    private JButton btnCancel = null;
    private JLabel lblTitle = null;
    private JLabel lblOldPin = null;
    private JLabel lblNewPin = null;
    private JLabel lblConfirm = null;
    private JLabel lblMessage = null;
    private JPasswordField pwdOldPin = null;
    private JPasswordField pwdNewPin = null;
    private JPasswordField pwdConfirm = null;
    private String oldPin;
    private String newPin;
    private String confirm;
    private final ChangePin dialog = this;
    private TCDSecureSuite theSuite = null;

    public ChangePin(TCDSecureSuite theSuite) {
        this.theSuite = theSuite;
        this.initialize();
        this.setName("Change PIN");
        this.setLocationRelativeTo(null);
    }

    public String getOldPin() {
        return this.oldPin;
    }

    public String getNewPin() {
        return this.newPin;
    }

    public String getConfirm() {
        return this.confirm;
    }

    private JButton getBtnChange() {
        if (this.btnChange == null) {
            this.btnChange = new JButton();
            this.btnChange.setName("btnChange");
            this.btnChange.setText("Change");
            this.btnChange.setBounds(92, 163, 85, 25);
            this.btnChange.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    System.out.println("Change Pin . . . ");
                    ChangePin.this.oldPin = new String(ChangePin.this.pwdOldPin.getPassword());
                    ChangePin.this.newPin = new String(ChangePin.this.pwdNewPin.getPassword());
                    ChangePin.this.confirm = new String(ChangePin.this.pwdConfirm.getPassword());
                    try {
                        Integer.parseInt(ChangePin.this.newPin);
                    }
                    catch (Exception e) {
                        ChangePin.this.theSuite.showErrorDialog(ChangePin.this.dialog, "PIN must be digits.");
                        return;
                    }
                    if (!ChangePin.this.newPin.equals(ChangePin.this.confirm)) {
                        ChangePin.this.theSuite.showErrorDialog(ChangePin.this.dialog, "Please verify the new PIN.");
                        return;
                    }
                    try {
                        System.out.println("Change Pin");
                        String newPin = ChangePin.this.dialog.getNewPin();
                        String oldPin = ChangePin.this.dialog.getOldPin();
                        ChangePin.this.theSuite.changePin(oldPin, newPin);
                        ChangePin.this.theSuite.showInformationDialog(ChangePin.this.dialog, "The PIN has been changed.");
                    }
                    catch (Throwable e1) {
                        ChangePin.this.theSuite.showErrorDialog(ChangePin.this.dialog, "Unable to change the PIN\nThe original PIN is invalid.");
                        e1.printStackTrace();
                    }
                    ChangePin.this.setVisible(false);
                }
            });
        }
        return this.btnChange;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setName("btnCancel");
            this.btnCancel.setText("Cancel");
            this.btnCancel.setBounds(199, 163, 85, 25);
            this.btnCancel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    System.out.println("Cancelling . . . ");
                    ChangePin.this.setVisible(false);
                }
            });
        }
        return this.btnCancel;
    }

    private JLabel getLblTitle() {
        if (this.lblTitle == null) {
            this.lblTitle = new JLabel();
            this.lblTitle.setName("lblTitle");
            this.lblTitle.setFont(new Font("dialog", 1, 18));
            this.lblTitle.setText("Privacy Room Lock");
            this.lblTitle.setBounds(100, 25, 200, 25);
        }
        return this.lblTitle;
    }

    private JLabel getLblOldPin() {
        if (this.lblOldPin == null) {
            this.lblOldPin = new JLabel();
            this.lblOldPin.setName("lblOldPin");
            this.lblOldPin.setText("OLD PIN :");
            this.lblOldPin.setBounds(79, 62, 66, 14);
        }
        return this.lblOldPin;
    }

    private JLabel getLblNewPin() {
        if (this.lblNewPin == null) {
            this.lblNewPin = new JLabel();
            this.lblNewPin.setName("lblNewPin");
            this.lblNewPin.setText("NEW PIN :");
            this.lblNewPin.setBounds(79, 83, 66, 14);
        }
        return this.lblNewPin;
    }

    private JLabel getLblConfirm() {
        if (this.lblConfirm == null) {
            this.lblConfirm = new JLabel();
            this.lblConfirm.setName("lblConfirm");
            this.lblConfirm.setText("Confirm :");
            this.lblConfirm.setBounds(78, 104, 61, 14);
        }
        return this.lblConfirm;
    }

    private JLabel getLblMessage() {
        if (this.lblMessage == null) {
            this.lblMessage = new JLabel();
            this.lblMessage.setName("lblMessage");
            this.lblMessage.setText("Please enter your PIN for authentication");
            this.lblMessage.setBounds(78, 140, 234, 15);
        }
        return this.lblMessage;
    }

    private JPasswordField getPwdOldPin() {
        if (this.pwdOldPin == null) {
            this.pwdOldPin = new JPasswordField();
            this.pwdOldPin.setName("pwdOldPin");
            this.pwdOldPin.setBounds(165, 62, 135, 18);
        }
        return this.pwdOldPin;
    }

    private JPasswordField getPwdNewPin() {
        if (this.pwdNewPin == null) {
            this.pwdNewPin = new JPasswordField();
            this.pwdNewPin.setName("pwdNewPin");
            this.pwdNewPin.setBounds(165, 83, 135, 18);
        }
        return this.pwdNewPin;
    }

    private JPasswordField getPwdConfirm() {
        if (this.pwdConfirm == null) {
            this.pwdConfirm = new JPasswordField();
            this.pwdConfirm.setName("pwdConfirm");
            this.pwdConfirm.setBounds(165, 104, 136, 18);
        }
        return this.pwdConfirm;
    }

    private void initialize() {
        this.setTitle("Change PIN");
        this.setModal(true);
        this.setResizable(false);
        this.setSize(400, 250);
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(null);
        panel.add((Component)this.getLblTitle(), this.getLblTitle().getName());
        panel.add((Component)this.getLblOldPin(), this.getLblOldPin().getName());
        panel.add((Component)this.getLblNewPin(), this.getLblNewPin().getName());
        panel.add((Component)this.getLblConfirm(), this.getLblConfirm().getName());
        panel.add((Component)this.getPwdOldPin(), this.getPwdOldPin().getName());
        panel.add((Component)this.getPwdNewPin(), this.getPwdNewPin().getName());
        panel.add((Component)this.getPwdConfirm(), this.getPwdConfirm().getName());
        panel.add((Component)this.getLblMessage(), this.getLblMessage().getName());
        panel.add((Component)this.getBtnChange(), this.getBtnChange().getName());
        panel.add((Component)this.getBtnCancel(), this.getBtnCancel().getName());
    }
}

