/*
 * Decompiled with CFR 0.152.
 */
package ui.agent;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import management.SecureAgentManager;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Algorithm.AlgorithmSetName;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportTable;
import th.co.oga.security.pki.Certification.CertPackageException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.HouseKeeping.AgentProfile;
import th.co.oga.security.pki.HouseKeeping.AgentProfileNotFoundException;
import th.co.oga.security.pki.HouseKeeping.AgentProfileVerifyException;
import th.co.oga.security.pki.HouseKeeping.ConfigFailException;
import th.co.oga.security.pki.HouseKeeping.HouseKeeper;
import th.co.oga.security.pki.HouseKeeping.KeeperFatalException;
import th.co.oga.security.pki.HouseKeeping.KeeperSoftException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operator.MozillaJSS.JSSAlgorithm;
import th.co.oga.security.pki.Operator.SecureOperator;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import ui.TCDSecureSuite;
import ui.packaging.CertProfileItem;

public class Cryptographic
extends JPanel {
    private static final long serialVersionUID = -5147050429667744967L;
    private JButton btnApply = null;
    private JButton btnCancel = null;
    private JButton btnHelp = null;
    private JComboBox cbxKeyPairAlgorithm = null;
    private JComboBox cbxKeyPairSize = null;
    private JComboBox cbxSignatureAlgorithm = null;
    private JComboBox cbxDataEncryptionAlgorithm = null;
    private JComboBox cbxKeyWrapAlgorithm = null;
    private JComboBox cbxDefaultCertificate = null;
    private JLabel ivjJLabel1 = null;
    private JLabel ivjJLabel2 = null;
    private JLabel ivjJLabel3 = null;
    private JLabel ivjJLabel4 = null;
    private JLabel ivjJLabel5 = null;
    private JLabel ivjJLabel6 = null;
    private JLabel lblDefaultCertificate = null;
    private TCDSecureSuite theSuite;
    Room room;
    String keyPairAlgoName;
    int keyPairSize;
    String keyWrapAlgoName;
    String encryptionAlgoName;
    String signatureAlgoName;

    public Cryptographic(TCDSecureSuite theSuite) {
        this.setName("Cryptographic Policy");
        this.theSuite = theSuite;
        try {
            AlgorithmSet signatureAlgoSet;
            Room room = theSuite.getRoom();
            SecureOperator secureOperator = room.getSecureOperator();
            AlgorithmSupportTable algoTable = secureOperator.getSupportAlgorithm();
            AgentProfile profile = room.getOwner();
            this.keyPairAlgoName = profile.getKeyPairAlgo();
            this.keyPairSize = profile.getKeyPairSize();
            this.keyWrapAlgoName = profile.getKeyWrapAlgo();
            this.encryptionAlgoName = profile.getEncryptionAlgo();
            try {
                signatureAlgoSet = algoTable.getSignatureAlgorithm();
                this.signatureAlgoName = signatureAlgoSet.findByOID(profile.getSignatureAlgo()).getName();
            }
            catch (AlgorithmSupportException e) {
                e.printStackTrace();
            }
            try {
                AlgorithmSet keypairAlgoSet = algoTable.getKeyPairAlgorithm();
                this.keyPairAlgoName = keypairAlgoSet.findByOID(profile.getKeyPairAlgo()).getName();
            }
            catch (AlgorithmSupportException e) {
                e.printStackTrace();
            }
            try {
                AlgorithmSet keyWarpAlgoSet = algoTable.getKeyWrapAlgorithm();
                this.keyWrapAlgoName = keyWarpAlgoSet.findByOID(profile.getKeyWrapAlgo()).getName();
            }
            catch (AlgorithmSupportException e) {
                e.printStackTrace();
            }
            try {
                AlgorithmSet encryptAlgoSet = algoTable.getEncryptionAlgorithm();
                this.encryptionAlgoName = encryptAlgoSet.findByOID(profile.getEncryptionAlgo()).getName();
            }
            catch (AlgorithmSupportException e) {
                e.printStackTrace();
            }
            try {
                signatureAlgoSet = algoTable.getSignatureAlgorithm();
                this.signatureAlgoName = signatureAlgoSet.findByOID(profile.getSignatureAlgo()).getName();
            }
            catch (AlgorithmSupportException e) {
                e.printStackTrace();
            }
            System.out.println("keyPairAlgoName : " + this.keyPairAlgoName);
            System.out.println("keyPairSize : " + this.keyPairSize);
            System.out.println("keyWrapAlgoName : " + this.keyWrapAlgoName);
            System.out.println("encryptionAlgoName : " + this.encryptionAlgoName);
            System.out.println("signatureAlgoName : " + this.signatureAlgoName);
            this.initialize();
        }
        catch (NullPointerException e) {
            theSuite.showErrorDialog(this, e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            theSuite.showErrorDialog(this, e.getMessage());
            e.printStackTrace();
        }
    }

    private JButton getBtnApply() {
        if (this.btnApply == null) {
            this.btnApply = new JButton();
            this.btnApply.setName("btnApply");
            this.btnApply.setText("Apply");
            this.btnApply.setBounds(110, 280, 100, 25);
            final Cryptographic panel = this;
            this.btnApply.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        Cryptographic.this.applyChange();
                    }
                    catch (CertPackageException e) {
                        Cryptographic.this.theSuite.showErrorDialog(this, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (KeeperFatalException e) {
                        Cryptographic.this.theSuite.showErrorDialog(this, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (AlgorithmSupportException e) {
                        Cryptographic.this.theSuite.showErrorDialog(this, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (KeeperSoftException e) {
                        Cryptographic.this.theSuite.showErrorDialog(this, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (AgentProfileNotFoundException e) {
                        Cryptographic.this.theSuite.showErrorDialog(this, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (AgentProfileVerifyException e) {
                        Cryptographic.this.theSuite.showErrorDialog(this, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (ConfigFailException e) {
                        Cryptographic.this.theSuite.showErrorDialog(this, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        Cryptographic.this.theSuite.showErrorDialog(this, e.getMessage());
                        e.printStackTrace();
                    }
                    Cryptographic.this.theSuite.showInformationDialog(panel, "Profile has been updated.");
                }
            });
        }
        return this.btnApply;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setName("btnCancel");
            this.btnCancel.setText("Cancel");
            this.btnCancel.setBounds(220, 280, 100, 25);
            this.btnCancel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    Cryptographic.this.theSuite.showBlankScreen();
                }
            });
        }
        return this.btnCancel;
    }

    private JButton getBtnHelp() {
        if (this.btnHelp == null) {
            this.btnHelp = new JButton();
            this.btnHelp.setName("btnHelp");
            this.btnHelp.setText("Help");
            this.btnHelp.setBounds(330, 280, 100, 25);
            this.btnHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("HELP: cryptographic.html");
                    Cryptographic.this.theSuite.showHelp("Help", "cryptographic.html");
                }
            });
        }
        return this.btnHelp;
    }

    private JComboBox getCbxKeyPairAlgorithm() {
        if (this.cbxKeyPairAlgorithm == null) {
            this.cbxKeyPairAlgorithm = new JComboBox();
            final Cryptographic panel = this;
            this.cbxKeyPairAlgorithm.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("Change...");
                    try {
                        Cryptographic.this.updateKeyPairSize();
                    }
                    catch (Exception e) {
                        Cryptographic.this.theSuite.showErrorDialog(panel, e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
            this.cbxKeyPairAlgorithm.setName("cbxKeyPairAlgorithm");
            this.cbxKeyPairAlgorithm.setBackground(Color.white);
            this.cbxKeyPairAlgorithm.setBounds(230, 60, 200, 25);
            Room room = null;
            JComboBox cbxTemp = this.cbxKeyPairAlgorithm;
            room = this.theSuite.getRoom();
            SecureOperator secureOperator = room.getSecureOperator();
            AlgorithmSupportTable algoTable = secureOperator.getSupportAlgorithm();
            AlgorithmSet algoSet = algoTable.getKeyPairAlgorithm();
            Object[] profileList = algoSet.toArray();
            int i = 0;
            while (i < profileList.length) {
                AlgorithmProfile profile = (AlgorithmProfile)profileList[i];
                String name = profile.getAlgorithmName();
                cbxTemp.addItem(name);
                if (name.equals(this.keyPairAlgoName)) {
                    cbxTemp.setSelectedItem(name);
                }
                ++i;
            }
        }
        return this.cbxKeyPairAlgorithm;
    }

    private void updateKeyPairSize() throws Exception {
        if (this.cbxKeyPairSize == null) {
            return;
        }
        this.room = this.theSuite.getRoom();
        SecureOperator secureOperator = this.room.getSecureOperator();
        AlgorithmSupportTable algoTable = secureOperator.getSupportAlgorithm();
        AlgorithmSet algoSet = algoTable.getKeyPairAlgorithm();
        int index = this.cbxKeyPairAlgorithm.getSelectedIndex();
        Object[] profileList = algoSet.toArray();
        AlgorithmProfile profile = (AlgorithmProfile)profileList[index];
        String[] values = this.getKeyPairValues(profile);
        this.cbxKeyPairSize.removeAllItems();
        int i = 0;
        while (i < values.length) {
            this.cbxKeyPairSize.addItem(values[i]);
            ++i;
        }
    }

    private void updateKeyPairSize(int defaultSize) throws Exception {
        if (this.cbxKeyPairSize == null) {
            return;
        }
        this.room = this.theSuite.getRoom();
        SecureOperator secureOperator = this.room.getSecureOperator();
        AlgorithmSupportTable algoTable = secureOperator.getSupportAlgorithm();
        AlgorithmSet algoSet = algoTable.getKeyPairAlgorithm();
        int index = this.cbxKeyPairAlgorithm.getSelectedIndex();
        Object[] profileList = algoSet.toArray();
        AlgorithmProfile profile = (AlgorithmProfile)profileList[index];
        String[] values = this.getKeyPairValues(profile);
        this.cbxKeyPairSize.removeAllItems();
        int i = 0;
        while (i < values.length) {
            this.cbxKeyPairSize.addItem(values[i]);
            if (values[i].equals("" + defaultSize)) {
                this.cbxKeyPairSize.setSelectedItem(values[i]);
            }
            ++i;
        }
        System.out.println("Defaul size : " + defaultSize);
    }

    public String[] getKeyPairValues(AlgorithmProfile algProfile) throws Exception {
        System.out.println("Name:" + algProfile.getName());
        System.out.println("\tKey Size Method:" + algProfile.getKeySizeMethod());
        String[] sizes = algProfile.getKeySizeValues();
        System.out.print("\tKey Size Values:");
        int s = 0;
        while (s < sizes.length) {
            System.out.print(String.valueOf(sizes[s]) + " ");
            ++s;
        }
        System.out.print("\r\n");
        return sizes;
    }

    public void getInfo(AlgorithmSupportTable supportTable, AlgorithmSetName algoSetName) throws Exception {
        System.out.println("");
        System.out.println("Test Algorithm set ................:" + algoSetName.getName());
        JSSAlgorithm jssAlgo = new JSSAlgorithm();
        AlgorithmSet set = jssAlgo.getAlgorithmSet(algoSetName);
        int i = 0;
        while (i < set.size()) {
            AlgorithmProfile algProfile = (AlgorithmProfile)set.get(i);
            System.out.println("Name:" + algProfile.getName());
            System.out.println("\tKey Size Method:" + algProfile.getKeySizeMethod());
            String[] sizes = algProfile.getKeySizeValues();
            System.out.print("\tKey Size Values:");
            int s = 0;
            while (s < sizes.length) {
                System.out.print(String.valueOf(sizes[s]) + " ");
                ++s;
            }
            System.out.print("\r\n");
            ++i;
        }
    }

    private JComboBox getCbxSignatureAlgorithm() {
        if (this.cbxSignatureAlgorithm == null) {
            this.cbxSignatureAlgorithm = new JComboBox();
            this.cbxSignatureAlgorithm.setName("cbxSignatureAlgorithm");
            this.cbxSignatureAlgorithm.setBackground(Color.white);
            this.cbxSignatureAlgorithm.setBounds(230, 125, 200, 25);
            Room room = null;
            JComboBox cbxTemp = this.cbxSignatureAlgorithm;
            room = this.theSuite.getRoom();
            SecureOperator secureOperator = room.getSecureOperator();
            AlgorithmSupportTable algoTable = secureOperator.getSupportAlgorithm();
            AlgorithmSet algoSet = algoTable.getSignatureAlgorithm();
            Object[] profileList = algoSet.toArray();
            int i = 0;
            while (i < profileList.length) {
                AlgorithmProfile profile = (AlgorithmProfile)profileList[i];
                String name = profile.getAlgorithmName();
                cbxTemp.addItem(name);
                if (name.equals(this.signatureAlgoName)) {
                    cbxTemp.setSelectedItem(name);
                }
                ++i;
            }
            System.out.println("Default SignatureAlgorithm : " + this.signatureAlgoName);
        }
        return this.cbxSignatureAlgorithm;
    }

    private JComboBox getCbxDataEncryptionAlgorithm() {
        if (this.cbxDataEncryptionAlgorithm == null) {
            this.cbxDataEncryptionAlgorithm = new JComboBox();
            this.cbxDataEncryptionAlgorithm.setName("cbxDataEncryptionAlgorithm");
            this.cbxDataEncryptionAlgorithm.setBackground(Color.white);
            this.cbxDataEncryptionAlgorithm.setBounds(230, 150, 200, 25);
            try {
                Room room = null;
                JComboBox cbxTemp = this.cbxDataEncryptionAlgorithm;
                room = this.theSuite.getRoom();
                SecureOperator secureOperator = room.getSecureOperator();
                AlgorithmSupportTable algoTable = secureOperator.getSupportAlgorithm();
                AlgorithmSet algoSet = algoTable.getAlgorithmSet(AlgorithmSetName.ENCRYPT_SYMETRIC);
                Object[] profileList = algoSet.toArray();
                int i = 0;
                while (i < profileList.length) {
                    AlgorithmProfile profile = (AlgorithmProfile)profileList[i];
                    String name = profile.getAlgorithmName();
                    cbxTemp.addItem(name);
                    if (name.equals(this.encryptionAlgoName)) {
                        cbxTemp.setSelectedItem(name);
                    }
                    ++i;
                }
            }
            catch (AlgorithmSupportException e) {
                this.theSuite.showErrorDialog(this, e.getMessage());
                e.printStackTrace();
            }
        }
        return this.cbxDataEncryptionAlgorithm;
    }

    private JComboBox getCbxKeyWrapAlgorithm() {
        if (this.cbxKeyWrapAlgorithm == null) {
            this.cbxKeyWrapAlgorithm = new JComboBox();
            this.cbxKeyWrapAlgorithm.setName("cbxKeyWrapAlgorithm");
            this.cbxKeyWrapAlgorithm.setBackground(Color.white);
            this.cbxKeyWrapAlgorithm.setBounds(230, 175, 200, 25);
            Room room = null;
            JComboBox cbxTemp = this.cbxKeyWrapAlgorithm;
            room = this.theSuite.getRoom();
            SecureOperator secureOperator = room.getSecureOperator();
            AlgorithmSupportTable algoTable = secureOperator.getSupportAlgorithm();
            AlgorithmSet algoSet = algoTable.getKeyWrapAlgorithm();
            Object[] profileList = algoSet.toArray();
            int i = 0;
            while (i < profileList.length) {
                AlgorithmProfile profile = (AlgorithmProfile)profileList[i];
                String name = profile.getAlgorithmName();
                cbxTemp.addItem(name);
                System.out.println("KW : " + name + " --" + this.keyWrapAlgoName);
                if (name.equals(this.keyWrapAlgoName)) {
                    cbxTemp.setSelectedItem(name);
                }
                ++i;
            }
        }
        return this.cbxKeyWrapAlgorithm;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            this.ivjJLabel1 = new JLabel();
            this.ivjJLabel1.setName("JLabel1");
            this.ivjJLabel1.setFont(new Font("dialog", 1, 14));
            this.ivjJLabel1.setBorder(new EtchedBorder());
            this.ivjJLabel1.setText("Cryptographic Policies");
            this.ivjJLabel1.setBounds(12, 12, 531, 25);
        }
        return this.ivjJLabel1;
    }

    private JLabel getJLabel2() {
        if (this.ivjJLabel2 == null) {
            this.ivjJLabel2 = new JLabel();
            this.ivjJLabel2.setName("JLabel2");
            this.ivjJLabel2.setText("Key Pair Generator Algorithm: ");
            this.ivjJLabel2.setBounds(51, 64, 177, 14);
        }
        return this.ivjJLabel2;
    }

    private JLabel getJLabel3() {
        if (this.ivjJLabel3 == null) {
            this.ivjJLabel3 = new JLabel();
            this.ivjJLabel3.setName("JLabel3");
            this.ivjJLabel3.setText("Key Pair Size: ");
            this.ivjJLabel3.setBounds(139, 88, 81, 14);
        }
        return this.ivjJLabel3;
    }

    private JLabel getJLabel4() {
        if (this.ivjJLabel4 == null) {
            this.ivjJLabel4 = new JLabel();
            this.ivjJLabel4.setName("JLabel4");
            this.ivjJLabel4.setText("Data Encryption Algorithm: ");
            this.ivjJLabel4.setBounds(68, 150, 154, 25);
        }
        return this.ivjJLabel4;
    }

    private JLabel getJLabel5() {
        if (this.ivjJLabel5 == null) {
            this.ivjJLabel5 = new JLabel();
            this.ivjJLabel5.setName("JLabel5");
            this.ivjJLabel5.setText("Signature Algorithm: ");
            this.ivjJLabel5.setBounds(101, 125, 120, 25);
        }
        return this.ivjJLabel5;
    }

    private JLabel getJLabel6() {
        if (this.ivjJLabel6 == null) {
            this.ivjJLabel6 = new JLabel();
            this.ivjJLabel6.setName("JLabel6");
            this.ivjJLabel6.setText("Key Wrapping Algorithm: ");
            this.ivjJLabel6.setBounds(75, 175, 144, 25);
        }
        return this.ivjJLabel6;
    }

    private JComboBox getCbxKeyPairSize() {
        if (this.cbxKeyPairSize == null) {
            this.cbxKeyPairSize = new JComboBox();
            this.cbxKeyPairSize.setName("cbxKeyPairSize");
            this.cbxKeyPairSize.setBackground(Color.white);
            this.cbxKeyPairSize.setBounds(230, 87, 200, 25);
            Cryptographic panel = this;
            try {
                this.updateKeyPairSize(this.keyPairSize);
            }
            catch (Exception e) {
                this.theSuite.showErrorDialog(panel, e.getMessage());
                e.printStackTrace();
            }
        }
        return this.cbxKeyPairSize;
    }

    private JLabel getLblDefaultCertificate() {
        if (this.lblDefaultCertificate == null) {
            this.lblDefaultCertificate = new JLabel("Default Certificate :");
            this.lblDefaultCertificate.setBounds(110, 200, 200, 25);
        }
        return this.lblDefaultCertificate;
    }

    private JComboBox getCbxDefaultCertificate() {
        if (this.cbxDefaultCertificate == null) {
            this.cbxDefaultCertificate = new JComboBox();
            this.cbxDefaultCertificate.setBackground(new Color(255, 255, 255));
            this.cbxDefaultCertificate.setBounds(230, 200, 200, 25);
            try {
                this.room = this.theSuite.getRoom();
                AgentProfile agentProfile = this.room.getOwner();
                CertProfile defaultProfile = null;
                try {
                    defaultProfile = agentProfile.getDefaultCertificate();
                }
                catch (IOException e) {
                    System.out.println("Unable to retrieve default certificate");
                    e.printStackTrace();
                }
                SecureStoreOperator operator = this.room.getSecureStoreOperator();
                List list = operator.getCertificates("USER Certificate");
                for (CertProfile certProfile : list) {
                    CertProfileItem certProfileItem = new CertProfileItem(certProfile);
                    this.cbxDefaultCertificate.addItem(certProfileItem);
                    System.out.println("Compare \n\t" + defaultProfile + "\n\t" + certProfile);
                    if (defaultProfile == null || !defaultProfile.toString().equals(certProfile.toString())) continue;
                    this.cbxDefaultCertificate.setSelectedItem((Object)certProfileItem);
                }
            }
            catch (SecureStoreException e) {
                System.out.println("Error during retrieving default cert");
                e.printStackTrace();
            }
            catch (CertificateException e) {
                System.out.println("Error during retrieving default cert");
                e.printStackTrace();
            }
        }
        return this.cbxDefaultCertificate;
    }

    private void initialize() {
        this.setName("pnlCryptographic");
        this.setLayout(null);
        this.setSize(558, 332);
        this.add((Component)this.getJLabel1(), this.getJLabel1().getName());
        this.add((Component)this.getJLabel2(), this.getJLabel2().getName());
        this.add((Component)this.getJLabel3(), this.getJLabel3().getName());
        this.add((Component)this.getJLabel4(), this.getJLabel4().getName());
        this.add((Component)this.getJLabel5(), this.getJLabel5().getName());
        this.add((Component)this.getJLabel6(), this.getJLabel6().getName());
        this.add((Component)this.getLblDefaultCertificate(), this.getLblDefaultCertificate().getName());
        this.add((Component)this.getBtnApply(), this.getBtnApply().getName());
        this.add((Component)this.getBtnCancel(), this.getBtnCancel().getName());
        this.add((Component)this.getBtnHelp(), this.getBtnHelp().getName());
        this.add((Component)this.getCbxKeyPairAlgorithm(), this.getCbxKeyPairAlgorithm().getName());
        this.add((Component)this.getCbxSignatureAlgorithm(), this.getCbxSignatureAlgorithm().getName());
        this.add((Component)this.getCbxDataEncryptionAlgorithm(), this.getCbxDataEncryptionAlgorithm().getName());
        this.add((Component)this.getCbxKeyWrapAlgorithm(), this.getCbxKeyWrapAlgorithm().getName());
        this.add((Component)this.getCbxKeyPairSize(), this.getCbxKeyPairSize().getName());
        this.add((Component)this.getCbxDefaultCertificate(), this.getCbxDefaultCertificate().getName());
    }

    private void applyChange() throws AlgorithmSupportException, KeeperFatalException, KeeperSoftException, AgentProfileNotFoundException, AgentProfileVerifyException, ConfigFailException, CertPackageException, IOException {
        SecureAgentManager manager = this.theSuite.getSecureAgentManager();
        HouseKeeper house = this.theSuite.getHouse();
        Room room = this.theSuite.getRoom();
        String keyPairAlgoOid = null;
        int keyPairSize = 1;
        String keyWrapAlgoOid = null;
        String encryptionAlgoOid = null;
        String signatureAlgoOid = null;
        SecureOperator secureOperator = room.getSecureOperator();
        AlgorithmSupportTable algoTable = secureOperator.getSupportAlgorithm();
        AlgorithmSet algoSet = algoTable.getKeyPairAlgorithm();
        AlgorithmProfile algoProfile = algoSet.findByName((String)this.cbxKeyPairAlgorithm.getSelectedItem());
        keyPairAlgoOid = algoProfile.getOID();
        keyPairSize = Integer.parseInt((String)this.cbxKeyPairSize.getSelectedItem());
        algoSet = algoTable.getKeyWrapAlgorithm();
        algoProfile = algoSet.findByName((String)this.cbxKeyWrapAlgorithm.getSelectedItem());
        keyWrapAlgoOid = algoProfile.getOID();
        algoSet = algoTable.getSignatureAlgorithm();
        algoProfile = algoSet.findByName((String)this.cbxSignatureAlgorithm.getSelectedItem());
        signatureAlgoOid = algoProfile.getOID();
        System.out.println("SignatureAlgorithm : " + (String)this.cbxSignatureAlgorithm.getSelectedItem());
        System.out.println("algoProfile : " + algoProfile);
        System.out.println("signatureAlgoOid : " + signatureAlgoOid);
        algoSet = algoTable.getEncryptionAlgorithm();
        algoProfile = algoSet.findByName((String)this.cbxDataEncryptionAlgorithm.getSelectedItem());
        encryptionAlgoOid = algoProfile.getOID();
        manager.setRoom(house, room, keyPairAlgoOid, keyPairSize, keyWrapAlgoOid, encryptionAlgoOid, signatureAlgoOid);
        CertProfileItem certItem = (CertProfileItem)((Object)this.cbxDefaultCertificate.getSelectedItem());
        CertProfile certProfile = certItem.getCertProfile();
        manager.setDefaultCertificate(this.theSuite.getHouse(), room, certProfile);
        try {
            this.theSuite.getSecurePackageManager();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

