/*
 * Decompiled with CFR 0.152.
 */
package ui.ca;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.PasswordAuthentication;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import th.co.oga.security.pki.HouseKeeping.ConfigFailException;
import th.co.oga.security.pki.HouseKeeping.ProfileAlreadyExistException;
import th.co.oga.security.pki.HouseKeeping.ProfileNotFoundException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Transport.InvalidProtocolNameException;
import th.co.oga.security.pki.Transport.ProtocolProperties;
import th.co.oga.security.pki.Transport.TransportProtocol;
import th.co.oga.security.pki.Transport.UnSupportProtocolException;
import th.co.oga.security.pki.Trusted.Authority;
import th.co.oga.security.pki.Trusted.AuthorityService;
import th.co.oga.security.pki.Trusted.ProtocolName;
import th.co.oga.security.utils.UnknowMadatoryException;
import ui.TCDSecureSuite;
import ui.ca.data.CARegisterDialogData;

public class AuthorityServiceSetup
extends JDialog {
    private static final long serialVersionUID = -1317223703992088603L;
    private JPanel pnlContent;
    private JButton btnOk;
    private JButton btnCancel;
    private JButton btnHelp;
    private JLabel lblService;
    private JLabel datService;
    private JLabel lblProtocol;
    private JComboBox cbxProtocol;
    private JLabel lblHost;
    private JTextField txtHost;
    private JLabel lblPort;
    private JTextField txtPort;
    private JLabel lblPath;
    private JTextField txtPath;
    private JLabel lblUser;
    private JTextField txtUser;
    private JLabel lblPassword;
    private JPasswordField txtPassword;
    private JLabel lblRcpAddress;
    private JTextField txtRcpAddress;
    private JLabel lblSenderAddress;
    private JTextField txtSenderAddress;
    private Container pane;
    private JPanel pnlProxy;
    private JPanel pnlService;
    private JScrollPane scroll;
    private ProtocolProperties props;
    private JTextField[] txtValue;
    private String[] strProxy;
    private String[] strValue;
    private int row = 0;
    private TCDSecureSuite theSuite;
    private final AuthorityServiceSetup theDialog = this;
    private AuthorityService service = null;
    private Authority authority = null;
    private String serviceName;
    private String protocol;
    private String host;
    private String port;
    private String path;
    private String user;
    private String password;
    private String rcpAddress;
    private String senderAddress;
    protected boolean isCalledFromCARegister;

    public AuthorityServiceSetup(TCDSecureSuite theSuite, CARegisterDialogData data, boolean isCalledFromCARegister) {
        this.isCalledFromCARegister = isCalledFromCARegister;
        this.initialise();
        this.theSuite = theSuite;
        this.authority = data.getAuthority();
        this.service = data.getService();
        this.putData();
        this.setName("Authority Service Setup");
        this.setLocationRelativeTo(null);
    }

    private void putData() {
        this.serviceName = this.service.getName();
        this.protocol = this.service.getProtocolName();
        this.host = this.service.getHost();
        this.port = "" + this.service.getPort();
        this.path = this.service.getPath();
        this.rcpAddress = this.service.getRecipient();
        this.senderAddress = this.service.getSender();
        PasswordAuthentication authen = this.service.getAuthen();
        if (authen != null) {
            this.user = authen.getUserName();
            this.password = new String(authen.getPassword());
        }
        this.datService.setText(this.serviceName);
        this.cbxProtocol.addItem(ProtocolName.HTTP.getName());
        this.cbxProtocol.addItem(ProtocolName.HTTPS.getName());
        this.cbxProtocol.addItem(ProtocolName.LDAP.getName());
        this.cbxProtocol.addItem(ProtocolName.SMTP.getName());
        int i = 0;
        while (i < this.cbxProtocol.getItemCount()) {
            if (((String)this.cbxProtocol.getItemAt(i)).toUpperCase().equals(this.protocol.toUpperCase())) {
                this.cbxProtocol.setSelectedIndex(i);
            }
            ++i;
        }
        this.txtHost.setText(this.host);
        this.txtPort.setText(this.port);
        this.txtPath.setText(this.path);
        this.txtUser.setText(this.user);
        this.txtPassword.setText(this.password);
        this.txtRcpAddress.setText(this.rcpAddress);
        this.txtSenderAddress.setText(this.senderAddress);
    }

    public void initialise() {
        this.setTitle("Authority Service Detail Setup");
        this.setFont(new Font("sansserif", 0, 10));
        this.setModal(true);
        this.setResizable(false);
        this.setSize(400, 480);
        this.pane = this.getContentPane();
        this.pane.setLayout(null);
        this.pane.add((Component)this.getPnlContent(), this.getPnlContent().getName());
        this.pane.add((Component)this.getPnlProxy(), this.getPnlProxy().getName());
        this.pane.add((Component)this.getBtnOk(), this.getBtnOk().getName());
        this.pane.add((Component)this.getBtnCancel(), this.getBtnCancel().getName());
        this.pane.add((Component)this.getBtnHelp(), this.getBtnHelp().getName());
    }

    private JPanel getPnlContent() {
        if (this.pnlContent == null) {
            this.pnlContent = new JPanel();
            this.pnlContent.setLayout(null);
            this.pnlContent.setBounds(20, 20, 350, 250);
            this.pnlContent.setBorder(new LineBorder(new Color(0, 0, 0)));
            this.pnlContent.add((Component)this.getLblService(), this.getLblService().getName());
            this.pnlContent.add((Component)this.getDatService(), this.getDatService().getName());
            this.pnlContent.add((Component)this.getLblProtocol(), this.getLblProtocol().getName());
            this.pnlContent.add((Component)this.getCbxProtocol(), this.getCbxProtocol().getName());
            this.pnlContent.add((Component)this.getLblHost(), this.getLblHost().getName());
            this.pnlContent.add((Component)this.getTxtHost(), this.getTxtHost().getName());
            this.pnlContent.add((Component)this.getLblPort(), this.getLblPort().getName());
            this.pnlContent.add((Component)this.getTxtPort(), this.getTxtPort().getName());
            this.pnlContent.add((Component)this.getLblPath(), this.getLblPath().getName());
            this.pnlContent.add((Component)this.getTxtPath(), this.getTxtPath().getName());
            this.pnlContent.add((Component)this.getLblUser(), this.getLblUser().getName());
            this.pnlContent.add((Component)this.getTxtUser(), this.getTxtUser().getName());
            this.pnlContent.add((Component)this.getLblPassword(), this.getLblPassword().getName());
            this.pnlContent.add((Component)this.getTxtPassword(), this.getTxtPassword().getName());
            this.pnlContent.add((Component)this.getLblRcpAddress(), this.getLblRcpAddress().getName());
            this.pnlContent.add((Component)this.getTxtRcpAddress(), this.getTxtRcpAddress().getName());
            this.pnlContent.add((Component)this.getLblSenderAddress(), this.getLblSenderAddress().getName());
            this.pnlContent.add((Component)this.getTxtSenderAddress(), this.getTxtSenderAddress().getName());
        }
        return this.pnlContent;
    }

    private JPanel getPnlProxy() {
        if (this.pnlProxy == null) {
            this.pnlProxy = new JPanel();
            this.pnlProxy.setName("Proxy");
            this.pnlProxy.setLayout(null);
            this.pnlProxy.setBounds(20, 280, 350, 100);
            this.pnlProxy.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 0)), " Proxy: "));
            this.scroll = new JScrollPane(this.getPnlService());
            this.scroll.setBounds(10, 20, 330, 70);
            this.pnlProxy.add((Component)this.scroll, this.getPnlService().getName());
        }
        return this.pnlProxy;
    }

    private JPanel getPnlService() {
        if (this.pnlService == null) {
            this.pnlService = new JPanel();
            this.pnlService.setLayout(new GridLayout(0, 1, 3, 3));
        }
        return this.pnlService;
    }

    private void getProtocolProperties() throws InvalidProtocolNameException, UnSupportProtocolException, UnknowMadatoryException {
        ProtocolProperties pp;
        String strProtocol = (String)this.cbxProtocol.getSelectedItem();
        ProtocolName protocolName = ProtocolName.getInstance((String)strProtocol);
        this.txtPort.setText("" + protocolName.getPortNumber());
        this.pnlService.removeAll();
        strProtocol = (String)this.cbxProtocol.getSelectedItem();
        this.props = ProtocolProperties.getInstance((TransportProtocol)protocolName);
        this.row = this.props.size();
        this.strProxy = new String[this.row];
        this.strValue = new String[this.row];
        int i = 0;
        Enumeration enu = this.props.getMandatories();
        while (enu.hasMoreElements()) {
            this.strProxy[i] = (String)enu.nextElement();
            String check = this.props.getValue(this.strProxy[i]);
            this.strValue[i] = check.equals(ProtocolProperties.UNDEFINE) ? "" : this.props.getValue(this.strProxy[i]);
            ++i;
        }
        i = 0;
        if (strProtocol.toUpperCase().equals(this.service.getProtocolName().toUpperCase()) && (pp = this.service.getParameters()) != null) {
            enu = pp.getMandatories();
            while (enu.hasMoreElements()) {
                String element = (String)enu.nextElement();
                String check = pp.getValue(element);
                this.strValue[i] = check.equals(ProtocolProperties.UNDEFINE) ? "" : pp.getValue(element);
                ++i;
            }
        }
        JPanel[] pnlMain = new JPanel[this.row];
        JLabel[] lblProxy = new JLabel[this.row];
        this.txtValue = new JTextField[this.row];
        i = 0;
        while (i < this.row) {
            pnlMain[i] = new JPanel();
            pnlMain[i].setName("main" + i);
            pnlMain[i].setLayout(new GridLayout(1, 2, 3, 3));
            lblProxy[i] = new JLabel(this.strProxy[i]);
            pnlMain[i].add(lblProxy[i]);
            this.txtValue[i] = new JTextField(this.strValue[i]);
            pnlMain[i].add(this.txtValue[i]);
            this.pnlService.add((Component)pnlMain[i], i);
            ++i;
        }
        this.pnlProxy.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 0)), " Proxy: " + strProtocol));
        this.pane.setVisible(false);
        this.pane.setVisible(true);
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton("OK");
            this.btnOk.setBounds(65, 390, 80, 25);
            this.btnOk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        int i = 0;
                        while (i < AuthorityServiceSetup.this.row) {
                            System.out.println(String.valueOf(AuthorityServiceSetup.this.strProxy[i]) + " :: " + AuthorityServiceSetup.this.txtValue[i].getText());
                            if (AuthorityServiceSetup.this.txtValue[i].getText().equals("")) {
                                AuthorityServiceSetup.this.props.setValue(AuthorityServiceSetup.this.strProxy[i], ProtocolProperties.UNDEFINE);
                            } else {
                                ((AuthorityServiceSetup)AuthorityServiceSetup.this).strValue[i] = AuthorityServiceSetup.this.txtValue[i].getText();
                                AuthorityServiceSetup.this.props.setValue(AuthorityServiceSetup.this.strProxy[i], AuthorityServiceSetup.this.strValue[i]);
                            }
                            ++i;
                        }
                        AuthorityServiceSetup.this.serviceName = AuthorityServiceSetup.this.datService.getText();
                        AuthorityServiceSetup.this.protocol = (String)AuthorityServiceSetup.this.cbxProtocol.getSelectedItem();
                        ProtocolName protocolName = ProtocolName.getInstance((String)AuthorityServiceSetup.this.protocol);
                        AuthorityServiceSetup.this.host = AuthorityServiceSetup.this.txtHost.getText();
                        try {
                            AuthorityServiceSetup.this.port = AuthorityServiceSetup.this.txtPort.getText();
                            Integer.parseInt(AuthorityServiceSetup.this.port);
                        }
                        catch (NumberFormatException e) {
                            AuthorityServiceSetup.this.theSuite.showErrorDialog(AuthorityServiceSetup.this.theDialog, "Invalid port number");
                            return;
                        }
                        AuthorityServiceSetup.this.path = AuthorityServiceSetup.this.txtPath.getText();
                        AuthorityServiceSetup.this.user = AuthorityServiceSetup.this.txtUser.getText();
                        AuthorityServiceSetup.this.password = new String(AuthorityServiceSetup.this.txtPassword.getPassword());
                        AuthorityServiceSetup.this.rcpAddress = AuthorityServiceSetup.this.txtRcpAddress.getText();
                        AuthorityServiceSetup.this.senderAddress = AuthorityServiceSetup.this.txtSenderAddress.getText();
                        PasswordAuthentication authen = new PasswordAuthentication(AuthorityServiceSetup.this.user, AuthorityServiceSetup.this.txtPassword.getPassword());
                        AuthorityServiceSetup.this.service.setProtocol(protocolName);
                        AuthorityServiceSetup.this.service.setHost(AuthorityServiceSetup.this.host);
                        AuthorityServiceSetup.this.service.setPath(AuthorityServiceSetup.this.path);
                        AuthorityServiceSetup.this.service.setPort(AuthorityServiceSetup.this.port);
                        AuthorityServiceSetup.this.service.setRecipient(AuthorityServiceSetup.this.rcpAddress);
                        AuthorityServiceSetup.this.service.setSender(AuthorityServiceSetup.this.senderAddress);
                        AuthorityServiceSetup.this.service.setParameter(AuthorityServiceSetup.this.props);
                        AuthorityServiceSetup.this.authority.setService(AuthorityServiceSetup.this.service);
                        System.out.println("Update: " + AuthorityServiceSetup.this.serviceName + " " + AuthorityServiceSetup.this.protocol + "://" + AuthorityServiceSetup.this.host + ":" + AuthorityServiceSetup.this.port + "/" + AuthorityServiceSetup.this.path);
                        System.out.println("U/P : " + AuthorityServiceSetup.this.user + "/" + AuthorityServiceSetup.this.password);
                        System.out.println("rcp/sender : " + AuthorityServiceSetup.this.rcpAddress + "/" + AuthorityServiceSetup.this.senderAddress);
                        Room room = AuthorityServiceSetup.this.theSuite.getRoom();
                        room.updateAuthority(AuthorityServiceSetup.this.authority);
                        AuthorityServiceSetup.this.theSuite.showInformationDialog(AuthorityServiceSetup.this.theDialog, "Authority Service has been updated.");
                        AuthorityServiceSetup.this.setVisible(false);
                        AuthorityServiceSetup.this.theSuite.showCARegisterDialog(AuthorityServiceSetup.this.authority, AuthorityServiceSetup.this.isCalledFromCARegister);
                    }
                    catch (InvalidProtocolNameException e) {
                        AuthorityServiceSetup.this.theSuite.showErrorDialog(AuthorityServiceSetup.this.theDialog, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (ProfileAlreadyExistException e) {
                        AuthorityServiceSetup.this.theSuite.showErrorDialog(AuthorityServiceSetup.this.theDialog, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (ProfileNotFoundException e) {
                        AuthorityServiceSetup.this.theSuite.showErrorDialog(AuthorityServiceSetup.this.theDialog, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (ConfigFailException e) {
                        AuthorityServiceSetup.this.theSuite.showErrorDialog(AuthorityServiceSetup.this.theDialog, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (UnknowMadatoryException e) {
                        AuthorityServiceSetup.this.theSuite.showErrorDialog(AuthorityServiceSetup.this.theDialog, e.getMessage());
                        e.printStackTrace();
                    }
                    catch (UnSupportProtocolException e) {
                        AuthorityServiceSetup.this.theSuite.showErrorDialog(AuthorityServiceSetup.this.theDialog, e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
        }
        return this.btnOk;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton("Cancel");
            this.btnCancel.setBounds(155, 390, 80, 25);
            this.btnCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    AuthorityServiceSetup.this.setVisible(false);
                }
            });
        }
        return this.btnCancel;
    }

    private JButton getBtnHelp() {
        if (this.btnHelp == null) {
            this.btnHelp = new JButton("Help");
            this.btnHelp.setBounds(245, 390, 80, 25);
            this.btnHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("HELP: authorityservicesetup.html");
                    AuthorityServiceSetup.this.theSuite.showHelp("Help", "authorityservicesetup.html");
                }
            });
        }
        return this.btnHelp;
    }

    private JLabel getLblService() {
        if (this.lblService == null) {
            this.lblService = new JLabel("Service :");
            this.lblService.setBounds(20, 20, 150, 20);
        }
        return this.lblService;
    }

    private JLabel getDatService() {
        if (this.datService == null) {
            this.datService = new JLabel("Timestamp");
            this.datService.setBounds(170, 20, 150, 20);
        }
        return this.datService;
    }

    private JLabel getLblProtocol() {
        if (this.lblProtocol == null) {
            this.lblProtocol = new JLabel("Protocol :");
            this.lblProtocol.setBounds(20, 45, 150, 20);
        }
        return this.lblProtocol;
    }

    private JComboBox getCbxProtocol() {
        if (this.cbxProtocol == null) {
            this.cbxProtocol = new JComboBox();
            this.cbxProtocol.setBackground(new Color(255, 255, 255));
            this.cbxProtocol.setBounds(170, 45, 150, 20);
            this.cbxProtocol.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    try {
                        AuthorityServiceSetup.this.getProtocolProperties();
                    }
                    catch (InvalidProtocolNameException e1) {
                        e1.printStackTrace();
                    }
                    catch (UnSupportProtocolException e1) {
                        e1.printStackTrace();
                    }
                    catch (UnknowMadatoryException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
        return this.cbxProtocol;
    }

    private JLabel getLblHost() {
        if (this.lblHost == null) {
            this.lblHost = new JLabel("Host :");
            this.lblHost.setBounds(20, 70, 150, 20);
        }
        return this.lblHost;
    }

    private JTextField getTxtHost() {
        if (this.txtHost == null) {
            this.txtHost = new JTextField();
            this.txtHost.setBounds(170, 70, 150, 20);
        }
        return this.txtHost;
    }

    private JLabel getLblPort() {
        if (this.lblPort == null) {
            this.lblPort = new JLabel("Port :");
            this.lblPort.setBounds(20, 95, 150, 20);
        }
        return this.lblPort;
    }

    private JTextField getTxtPort() {
        if (this.txtPort == null) {
            this.txtPort = new JTextField();
            this.txtPort.setBounds(170, 95, 150, 20);
        }
        return this.txtPort;
    }

    private JLabel getLblPath() {
        if (this.lblPath == null) {
            this.lblPath = new JLabel("Path :");
            this.lblPath.setBounds(20, 120, 150, 20);
        }
        return this.lblPath;
    }

    private JTextField getTxtPath() {
        if (this.txtPath == null) {
            this.txtPath = new JTextField();
            this.txtPath.setBounds(170, 120, 150, 20);
        }
        return this.txtPath;
    }

    private JLabel getLblUser() {
        if (this.lblUser == null) {
            this.lblUser = new JLabel("User :");
            this.lblUser.setBounds(20, 145, 150, 20);
        }
        return this.lblUser;
    }

    private JTextField getTxtUser() {
        if (this.txtUser == null) {
            this.txtUser = new JTextField();
            this.txtUser.setBounds(170, 145, 150, 20);
        }
        return this.txtUser;
    }

    private JLabel getLblPassword() {
        if (this.lblPassword == null) {
            this.lblPassword = new JLabel("Password :");
            this.lblPassword.setBounds(20, 170, 150, 20);
        }
        return this.lblPassword;
    }

    private JPasswordField getTxtPassword() {
        if (this.txtPassword == null) {
            this.txtPassword = new JPasswordField();
            this.txtPassword.setBounds(170, 170, 150, 20);
        }
        return this.txtPassword;
    }

    private JLabel getLblRcpAddress() {
        if (this.lblRcpAddress == null) {
            this.lblRcpAddress = new JLabel("Recipient Address :");
            this.lblRcpAddress.setBounds(20, 195, 150, 20);
        }
        return this.lblRcpAddress;
    }

    private JTextField getTxtRcpAddress() {
        if (this.txtRcpAddress == null) {
            this.txtRcpAddress = new JTextField();
            this.txtRcpAddress.setBounds(170, 195, 150, 20);
        }
        return this.txtRcpAddress;
    }

    private JLabel getLblSenderAddress() {
        if (this.lblSenderAddress == null) {
            this.lblSenderAddress = new JLabel("Sender Address :");
            this.lblSenderAddress.setBounds(20, 220, 150, 20);
        }
        return this.lblSenderAddress;
    }

    private JTextField getTxtSenderAddress() {
        if (this.txtSenderAddress == null) {
            this.txtSenderAddress = new JTextField();
            this.txtSenderAddress.setBounds(170, 220, 150, 20);
        }
        return this.txtSenderAddress;
    }
}

