/*
 * Decompiled with CFR 0.152.
 */
package ui.ca;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import management.TrustedManager;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.HouseKeeping.ConfigFailException;
import th.co.oga.security.pki.HouseKeeping.ProfileNotFoundException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Trusted.Authority;
import th.co.oga.security.pki.X500.DName;
import ui.TCDSecureSuite;
import ui.ca.data.CARegisterData;
import ui.ca.data.CARegisterDataModel;

public class CARegister
extends JPanel {
    private final CARegister thePanel = this;
    private static final long serialVersionUID = 1L;
    private JButton btnSetup;
    private JButton btnRemove;
    private JButton btnHelp;
    private JLabel lblTitle;
    private JScrollPane pnlTable;
    private JTable tblRegister;
    private TCDSecureSuite theSuite;
    private ArrayList tableData;
    private CertProfile[] caProfileList;
    private Authority[] authorityList;

    public CARegister(TCDSecureSuite theSuite) {
        this.theSuite = theSuite;
        this.setName("CA Register");
        TrustedManager manager = theSuite.getTrustedManager();
        try {
            this.caProfileList = manager.getCaCertProfileList();
            this.authorityList = manager.getAutoritiesList();
            this.putData();
            this.initialize();
        }
        catch (SecureStoreException e) {
            theSuite.showErrorDialog(this.thePanel, "Unable to retrieve data of this agent.\nThe form will not open.");
            e.printStackTrace();
        }
        catch (ASN1Exception e) {
            theSuite.showErrorDialog(this.thePanel, "Unable to retrieve data of this agent.\nThe form will not open.");
            e.printStackTrace();
        }
    }

    public void putData() {
        this.tableData = new ArrayList();
        System.out.println("authorityList.length " + this.authorityList.length);
        int i = 0;
        while (i < this.authorityList.length) {
            Authority authority = this.authorityList[i];
            String commonName = authority.getName();
            String nicName = "";
            if (authority.getNicName() != null) {
                nicName = authority.getNicName();
            } else {
                try {
                    nicName = DName.getInstance((X500Principal)authority.getSubjectName()).getCommonName();
                }
                catch (ASN1Exception e) {
                    nicName = authority.getSubjectName().getName();
                }
            }
            String register = authority.isRegistered() ? "Registered" : "Unregistered";
            String services = authority.getServiceNames();
            CARegisterData data = new CARegisterData(commonName, nicName, register, services);
            this.tableData.add(data);
            ++i;
        }
    }

    public void initialize() {
        this.setBorder(new LineBorder(new Color(255, 255, 255)));
        this.setLayout(null);
        this.setFont(new Font("sansserif", 0, 10));
        this.add((Component)this.getBtnSetup(), this.getBtnSetup().getName());
        this.add((Component)this.getBtnRemove(), this.getBtnRemove().getName());
        this.add((Component)this.getBtnHelp(), this.getBtnHelp().getName());
        this.add((Component)this.getLblTitle(), this.getLblTitle().getName());
        this.add((Component)this.getPnlTable(), this.getPnlTable().getName());
    }

    private JButton getBtnSetup() {
        if (this.btnSetup == null) {
            this.btnSetup = new JButton();
            this.btnSetup.setName("btnSetup");
            this.btnSetup.setText("Setup");
            this.btnSetup.setBounds(220, 490, 100, 30);
            this.btnSetup.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    int row = CARegister.this.tblRegister.getSelectedRow();
                    if (row < 0) {
                        return;
                    }
                    CARegister.this.theSuite.showCARegisterDialog(CARegister.this.authorityList[row], true);
                }
            });
        }
        return this.btnSetup;
    }

    private JButton getBtnRemove() {
        if (this.btnRemove == null) {
            this.btnRemove = new JButton();
            this.btnRemove.setName("btnRemove");
            this.btnRemove.setText("Remove");
            this.btnRemove.setBounds(340, 490, 100, 30);
            this.btnRemove.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    System.out.println("REMOVE CA. . .");
                    int row = CARegister.this.tblRegister.getSelectedRow();
                    try {
                        Room room = CARegister.this.theSuite.getRoom();
                        room.removeAuthority(CARegister.this.authorityList[row]);
                        CARegister.this.theSuite.showCARegister();
                        CARegister.this.theSuite.showInformationDialog(CARegister.this.thePanel, "CA has been removed.");
                    }
                    catch (ProfileNotFoundException e) {
                        CARegister.this.theSuite.showErrorDialog(CARegister.this.thePanel, "The certificate is not registered.");
                        e.printStackTrace();
                    }
                    catch (ConfigFailException e) {
                        CARegister.this.theSuite.showErrorDialog(CARegister.this.thePanel, e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
        }
        return this.btnRemove;
    }

    private JButton getBtnHelp() {
        if (this.btnHelp == null) {
            this.btnHelp = new JButton();
            this.btnHelp.setName("btnHelp");
            this.btnHelp.setText("Help");
            this.btnHelp.setBounds(460, 490, 100, 30);
            this.btnHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("HELP: caregister.html");
                    CARegister.this.theSuite.showHelp("Help", "caregister.html");
                }
            });
        }
        return this.btnHelp;
    }

    private JLabel getLblTitle() {
        if (this.lblTitle == null) {
            this.lblTitle = new JLabel();
            this.lblTitle.setName("lblTitle");
            this.lblTitle.setText("  Certificate Authority Register");
            this.lblTitle.setHorizontalTextPosition(2);
            this.lblTitle.setVerticalTextPosition(0);
            this.lblTitle.setBorder(new LineBorder(new Color(255, 255, 255)));
            this.lblTitle.setBounds(10, 10, 760, 30);
        }
        return this.lblTitle;
    }

    private JScrollPane getPnlTable() {
        if (this.pnlTable == null) {
            this.pnlTable = new JScrollPane(this.getTblRegister());
            this.pnlTable.setName("pnlTable");
            this.pnlTable.setBackground(Color.LIGHT_GRAY);
            this.pnlTable.setBorder(new LineBorder(new Color(255, 255, 255)));
            this.pnlTable.setBounds(50, 75, 690, 400);
        }
        return this.pnlTable;
    }

    private JTable getTblRegister() {
        if (this.tblRegister == null) {
            CARegisterDataModel dataModel = new CARegisterDataModel(this.tableData);
            this.tblRegister = new JTable(dataModel);
            this.tblRegister.setName("tblRegister");
            this.tblRegister.setShowHorizontalLines(false);
        }
        return this.tblRegister;
    }
}

