/*
 * Decompiled with CFR 0.152.
 */
package ui.ca;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.HouseKeeping.ConfigFailException;
import th.co.oga.security.pki.HouseKeeping.ProfileAlreadyExistException;
import th.co.oga.security.pki.HouseKeeping.ProfileNotFoundException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Trusted.Authority;
import th.co.oga.security.pki.Trusted.AuthorityService;
import th.co.oga.security.pki.Trusted.ServiceName;
import th.co.oga.security.pki.X500.DName;
import ui.TCDSecureSuite;
import ui.ca.AuthorityServiceSetup;
import ui.ca.data.CARegisterDialogData;
import ui.ca.data.CARegisterDialogDataModel;

public class CARegisterDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JLabel lblTitle = null;
    private JLabel lblName = null;
    private JLabel lblCommonName = null;
    private JLabel lblTitleNicName = null;
    private JTextField txtNicName = null;
    private JScrollPane pnlServices = null;
    private JTable tblServices = null;
    private JButton btnDetail = null;
    private JButton btnCancel = null;
    private JButton btnHelp = null;
    private JButton btnNicName = null;
    private TCDSecureSuite theSuite = null;
    private ArrayList tableData = null;
    private Authority authority = null;
    private String commonName = null;
    private String nicName = "";
    private final CARegisterDialog theDialog = this;
    protected boolean isCalledFromCARegister;

    public CARegisterDialog(TCDSecureSuite theSuite, Authority authority, boolean isCalledFromCARegister) {
        this.isCalledFromCARegister = isCalledFromCARegister;
        this.setTitle("Certificate Authority (CA)");
        this.theSuite = theSuite;
        this.authority = authority;
        this.commonName = authority.getName();
        if (authority.getNicName() != null) {
            this.nicName = authority.getNicName();
        } else {
            try {
                this.nicName = DName.getInstance((X500Principal)authority.getSubjectName()).getCommonName();
            }
            catch (ASN1Exception e) {
                this.nicName = authority.getSubjectName().getName();
            }
        }
        this.tableData = new ArrayList();
        this.putData();
        this.initialize();
        this.setLocationRelativeTo(null);
        if (!authority.isRegistered()) {
            this.txtNicName.setEnabled(false);
        }
        this.btnNicName.setEnabled(false);
    }

    public void putData() {
        Room room = this.theSuite.getRoom();
        ServiceName[] serviceNames = room.getAllServiceNames();
        int i = 0;
        while (i < serviceNames.length) {
            ServiceName serviceName = serviceNames[i];
            AuthorityService service = this.authority.getService(serviceName);
            CARegisterDialogData data = new CARegisterDialogData(this.authority, service);
            this.tableData.add(data);
            ++i;
        }
    }

    private JButton getBtnDetail() {
        if (this.btnDetail == null) {
            this.btnDetail = new JButton("Advanced Setup");
            this.btnDetail.setBounds(45, 410, 130, 30);
            this.btnDetail.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int row = CARegisterDialog.this.tblServices.getSelectedRow();
                    if (row < 0 || row >= CARegisterDialog.this.tableData.size()) {
                        CARegisterDialog.this.theSuite.showWarningDialog(CARegisterDialog.this.theDialog, "Please click on a certificate to advanced setup.");
                        return;
                    }
                    AuthorityServiceSetup dialog = new AuthorityServiceSetup(CARegisterDialog.this.theSuite, (CARegisterDialogData)CARegisterDialog.this.tableData.get(row), true);
                    dialog.setVisible(true);
                }
            });
        }
        return this.btnDetail;
    }

    private JButton getBtnNicName() {
        if (this.btnNicName == null) {
            this.btnNicName = new JButton();
            this.btnNicName.setName("btnNicName");
            this.btnNicName.setText("SaveNicName");
            this.btnNicName.setBounds(180, 410, 130, 30);
            this.btnNicName.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    block7: {
                        try {
                            if (!CARegisterDialog.this.authority.isRegistered()) break block7;
                            Room room = CARegisterDialog.this.theSuite.getRoom();
                            CARegisterDialog.this.nicName = CARegisterDialog.this.txtNicName.getText();
                            if (CARegisterDialog.this.nicName.length() <= 0) {
                                try {
                                    CARegisterDialog.this.nicName = DName.getInstance((X500Principal)CARegisterDialog.this.authority.getSubjectName()).getCommonName();
                                }
                                catch (ASN1Exception e) {
                                    CARegisterDialog.this.nicName = CARegisterDialog.this.authority.getSubjectName().getName();
                                }
                            }
                            CARegisterDialog.this.authority.setNicName(CARegisterDialog.this.nicName);
                            CARegisterDialog.this.txtNicName.setText(CARegisterDialog.this.nicName);
                            room.updateAuthority(CARegisterDialog.this.authority);
                            CARegisterDialog.this.btnNicName.setEnabled(false);
                        }
                        catch (ProfileAlreadyExistException e1) {
                            CARegisterDialog.this.theSuite.showErrorDialog(CARegisterDialog.this.theDialog, e1.getMessage());
                            e1.printStackTrace();
                        }
                        catch (ProfileNotFoundException e1) {
                            CARegisterDialog.this.theSuite.showErrorDialog(CARegisterDialog.this.theDialog, e1.getMessage());
                            e1.printStackTrace();
                        }
                        catch (ConfigFailException e1) {
                            CARegisterDialog.this.theSuite.showErrorDialog(CARegisterDialog.this.theDialog, e1.getMessage());
                            e1.printStackTrace();
                        }
                    }
                }
            });
        }
        return this.btnNicName;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setName("btnCancel");
            this.btnCancel.setText("Close");
            this.btnCancel.setBounds(315, 410, 130, 30);
            this.btnCancel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    System.out.println("Cancel Button . . .");
                    CARegisterDialog.this.setVisible(false);
                    if (CARegisterDialog.this.isCalledFromCARegister) {
                        CARegisterDialog.this.theSuite.showCARegister();
                    }
                }
            });
        }
        return this.btnCancel;
    }

    private JButton getBtnHelp() {
        if (this.btnHelp == null) {
            this.btnHelp = new JButton();
            this.btnHelp.setName("btnHelp");
            this.btnHelp.setText("Help");
            this.btnHelp.setBounds(450, 410, 130, 30);
            this.btnHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("HELP: caregisterdialog.html");
                    CARegisterDialog.this.theSuite.showHelp("Help", "caregisterdialog.html");
                }
            });
        }
        return this.btnHelp;
    }

    private JLabel getLblTitle() {
        if (this.lblTitle == null) {
            this.lblTitle = new JLabel();
            this.lblTitle.setName("lblTitle");
            this.lblTitle.setText("Certificate Authority (CA)");
            this.lblTitle.setHorizontalTextPosition(2);
            this.lblTitle.setVerticalTextPosition(0);
            this.lblTitle.setBorder(new LineBorder(new Color(255, 255, 255)));
            this.lblTitle.setBounds(10, 10, 610, 30);
        }
        return this.lblTitle;
    }

    private JLabel getLblName() {
        if (this.lblName == null) {
            this.lblName = new JLabel();
            this.lblName.setName("lblName");
            this.lblName.setText("Name: ");
            this.lblName.setHorizontalTextPosition(2);
            this.lblName.setVerticalTextPosition(0);
            this.lblName.setBounds(15, 50, 100, 30);
        }
        return this.lblName;
    }

    private JLabel getLblCommonName() {
        if (this.lblCommonName == null) {
            this.lblCommonName = new JLabel();
            this.lblCommonName.setName("lblCommonName");
            this.lblCommonName.setText(this.commonName);
            this.lblCommonName.setHorizontalTextPosition(2);
            this.lblCommonName.setVerticalTextPosition(0);
            this.lblCommonName.setBounds(80, 50, 540, 30);
        }
        return this.lblCommonName;
    }

    private JLabel getLblTitleNicName() {
        if (this.lblTitleNicName == null) {
            this.lblTitleNicName = new JLabel();
            this.lblTitleNicName.setName("lblTitleNicName");
            this.lblTitleNicName.setText("NicName: ");
            this.lblTitleNicName.setHorizontalTextPosition(2);
            this.lblTitleNicName.setVerticalTextPosition(0);
            this.lblTitleNicName.setBounds(15, 80, 100, 30);
        }
        return this.lblTitleNicName;
    }

    private JTextField getTxtNicName() {
        if (this.txtNicName == null) {
            this.txtNicName = new JTextField();
            this.txtNicName.setName("txtNicName");
            this.txtNicName.setText(this.nicName);
            this.txtNicName.setBounds(80, 85, 540, 20);
        }
        this.txtNicName.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent arg0) {
            }

            public void keyPressed(KeyEvent arg0) {
                CARegisterDialog.this.btnNicName.setEnabled(true);
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        return this.txtNicName;
    }

    private JScrollPane getPnlServices() {
        if (this.pnlServices == null) {
            this.pnlServices = new JScrollPane(this.getTblServices());
            this.pnlServices.setName("pnlServices");
            this.pnlServices.setBorder(new TitledBorder(new LineBorder(new Color(255, 255, 255)), "Services: "));
            this.pnlServices.setBounds(10, 110, 610, 290);
        }
        return this.pnlServices;
    }

    private JTable getTblServices() {
        if (this.tblServices == null) {
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.addItem("SMTP");
            comboBox.addItem("HTTP");
            comboBox.addItem("HTTPS");
            comboBox.addItem("LDAP");
            comboBox.addItem("LDAPS");
            CARegisterDialogDataModel dataModel = new CARegisterDialogDataModel(this.tableData);
            this.tblServices = new JTable(dataModel);
            this.tblServices.setName("tblServices");
            this.tblServices.setShowHorizontalLines(false);
            TableColumn column = this.tblServices.getColumnModel().getColumn(1);
            column.setCellEditor(new DefaultCellEditor(comboBox));
        }
        return this.tblServices;
    }

    private void initialize() {
        Container pane = this.getContentPane();
        pane.setLayout(null);
        this.setName("Certificate Authority (CA)");
        this.setFont(new Font("sansserif", 0, 10));
        this.setModal(true);
        this.setResizable(false);
        this.setSize(640, 480);
        pane.add((Component)this.getBtnDetail(), this.getBtnDetail().getName());
        pane.add((Component)this.getBtnCancel(), this.getBtnCancel().getName());
        pane.add((Component)this.getBtnHelp(), this.getBtnHelp().getName());
        pane.add((Component)this.getBtnNicName(), this.getBtnNicName().getName());
        pane.add((Component)this.getLblTitle(), this.getLblTitle().getName());
        pane.add((Component)this.getLblName(), this.getLblName().getName());
        pane.add((Component)this.getLblCommonName(), this.getLblCommonName().getName());
        pane.add((Component)this.getLblTitleNicName(), this.getLblTitleNicName().getName());
        pane.add((Component)this.getTxtNicName(), this.getTxtNicName().getName());
        pane.add((Component)this.getPnlServices(), this.getPnlServices().getName());
    }
}

