/*
 * Decompiled with CFR 0.152.
 */
package ui.ca;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import management.TrustedManager;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.HouseKeeping.ConfigFailException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import th.co.oga.security.pki.Trusted.Authority;
import th.co.oga.security.pki.Trusted.InvalidServiceNameException;
import th.co.oga.security.pki.Trusted.ServiceName;
import th.co.oga.security.pki.Trusted.TrustedPolicies;
import th.co.oga.security.pki.Trusted.TrustedService;
import th.co.oga.security.pki.X500.DName;
import ui.TCDSecureSuite;
import ui.ca.data.CATrustedPoliciesData;
import ui.ca.data.CATrustedPoliciesDataModel;

public class CATrustedPolicies
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton btnOk;
    private JButton btnHelp;
    private JLabel lblTitle;
    private JScrollPane pnlTable;
    private JTable tblServices;
    private JCheckBox chkActivePolicy;
    private TCDSecureSuite theSuite;
    private final CATrustedPolicies thePanel = this;
    private ArrayList tableData;
    private CertProfile[] trustedProfileList;
    private TrustedManager manager;

    public CATrustedPolicies(TCDSecureSuite theSuite) {
        this.theSuite = theSuite;
        this.setName("CA Trusted Policies");
        this.tableData = new ArrayList();
        this.manager = theSuite.getTrustedManager();
        try {
            this.trustedProfileList = this.manager.getTrustedCertProfileList();
            this.initialize();
            this.putData();
        }
        catch (SecureStoreException e) {
            theSuite.showErrorDialog(this.thePanel, "Unable to retrieve data of this agent.\nThe form will not open.");
            e.printStackTrace();
        }
    }

    public void putData() {
        Room room = this.theSuite.getRoom();
        ServiceName[] serviceNames = room.getAllServiceNames();
        TrustedPolicies trustedPolicies = room.getTrustedPolicies();
        System.out.println("serviceNames.length " + serviceNames.length);
        int i = 0;
        while (i < serviceNames.length) {
            ServiceName serviceName = serviceNames[i];
            TrustedService service = trustedPolicies.getService(serviceName);
            boolean enable = service.isEnable();
            String name = service.getServiceName();
            String authority = service.getAuthorityName();
            CATrustedPoliciesData data = new CATrustedPoliciesData(new Boolean(enable), name, authority);
            this.tableData.add(data);
            ++i;
        }
        this.chkActivePolicy.setSelected(trustedPolicies.isEnable());
    }

    public void initialize() {
        this.setBorder(new LineBorder(new Color(255, 255, 255)));
        this.setLayout(null);
        this.setFont(new Font("sansserif", 0, 10));
        this.add((Component)this.getBtnOk(), this.getBtnOk().getName());
        this.add((Component)this.getBtnHelp(), this.getBtnHelp().getName());
        this.add((Component)this.getChkActivePolicy(), this.getChkActivePolicy().getName());
        this.add((Component)this.getLblTitle(), this.getLblTitle().getName());
        this.add((Component)this.getPnlTable(), this.getPnlTable().getName());
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setName("btnOk");
            this.btnOk.setText("OK");
            this.btnOk.setBounds(280, 490, 100, 30);
            this.btnOk.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    System.out.println("OK . . . ");
                    try {
                        Room room = CATrustedPolicies.this.theSuite.getRoom();
                        TrustedPolicies trustedPolicies = room.getTrustedPolicies();
                        System.out.println("TrustedPolicies " + trustedPolicies);
                        Iterator iterator = CATrustedPolicies.this.tableData.iterator();
                        while (iterator.hasNext()) {
                            try {
                                CATrustedPoliciesData data = (CATrustedPoliciesData)iterator.next();
                                String name = data.getServiceName();
                                String authority = data.getAuthority();
                                boolean enable = data.isEnable();
                                ServiceName serviceName = ServiceName.getInstance((String)name);
                                TrustedService service = trustedPolicies.getService(serviceName);
                                service.setEnable(enable);
                                service.setAuthorityName(authority);
                                trustedPolicies.setService(service);
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                        }
                        trustedPolicies.setEnable(CATrustedPolicies.this.chkActivePolicy.isSelected());
                        room.setTrustedPolicies(trustedPolicies);
                        CATrustedPolicies.this.theSuite.showInformationDialog(CATrustedPolicies.this.thePanel, "Update Trusted Policies is successful.");
                    }
                    catch (InvalidServiceNameException e1) {
                        CATrustedPolicies.this.theSuite.showErrorDialog(CATrustedPolicies.this.thePanel, e1.getMessage());
                        e1.printStackTrace();
                    }
                    catch (ConfigFailException e1) {
                        CATrustedPolicies.this.theSuite.showErrorDialog(CATrustedPolicies.this.thePanel, e1.getMessage());
                        e1.printStackTrace();
                    }
                }
            });
        }
        return this.btnOk;
    }

    private JButton getBtnHelp() {
        if (this.btnHelp == null) {
            this.btnHelp = new JButton();
            this.btnHelp.setName("btnHelp");
            this.btnHelp.setText("Help");
            this.btnHelp.setBounds(400, 490, 100, 30);
            this.btnHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("HELP: catrustedpolicies.html");
                    CATrustedPolicies.this.theSuite.showHelp("Help", "catrustedpolicies.html");
                }
            });
        }
        return this.btnHelp;
    }

    private JCheckBox getChkActivePolicy() {
        if (this.chkActivePolicy == null) {
            this.chkActivePolicy = new JCheckBox("Active Policies");
            this.chkActivePolicy.setName("chkActivePolicy");
            this.chkActivePolicy.setBounds(340, 440, 110, 30);
        }
        return this.chkActivePolicy;
    }

    private JLabel getLblTitle() {
        if (this.lblTitle == null) {
            this.lblTitle = new JLabel();
            this.lblTitle.setName("lblTitle");
            this.lblTitle.setText("  Trusted Policies");
            this.lblTitle.setHorizontalTextPosition(2);
            this.lblTitle.setVerticalTextPosition(0);
            this.lblTitle.setBorder(new LineBorder(new Color(255, 255, 255)));
            this.lblTitle.setBounds(10, 10, 760, 30);
        }
        return this.lblTitle;
    }

    private JScrollPane getPnlTable() {
        if (this.pnlTable == null) {
            this.pnlTable = new JScrollPane(this.getTblServices());
            this.pnlTable.setName("pnlTable");
            this.pnlTable.setBorder(new LineBorder(new Color(255, 255, 255)));
            this.pnlTable.setBounds(50, 75, 690, 350);
        }
        return this.pnlTable;
    }

    private JTable getTblServices() {
        if (this.tblServices == null) {
            JComboBox<String> comboBox = new JComboBox<String>();
            try {
                final Room room = this.theSuite.getRoom();
                SecureStoreOperator operator = room.getSecureStoreOperator();
                List list = operator.getCertificates("CA Certificate");
                for (CertProfile certProfile : list) {
                    DName dName = certProfile.getSubjectDN();
                    String commonName = dName.getCommonName();
                    comboBox.addItem(commonName);
                }
                CATrustedPoliciesDataModel dataModel = new CATrustedPoliciesDataModel(this.tableData);
                this.tblServices = new JTable(dataModel){

                    public TableCellEditor getCellEditor(int row, int column) {
                        try {
                            if (column != 2) {
                                return super.getCellEditor(row, column);
                            }
                            System.out.println("getCellEditor " + row + " " + column);
                            String serviceName = (String)this.getValueAt(row, 1);
                            Authority[] authList = room.getAuthoritiesByService(ServiceName.getInstance((String)serviceName));
                            System.out.println("ServiceName " + serviceName);
                            System.out.println("Size " + authList.length);
                            JComboBox<String> cbx = new JComboBox<String>();
                            cbx.addItem("NA");
                            int i = 0;
                            while (i < authList.length) {
                                cbx.addItem(authList[i].getName());
                                ++i;
                            }
                            TableColumn column2 = CATrustedPolicies.this.tblServices.getColumnModel().getColumn(2);
                            column2.setCellEditor(new DefaultCellEditor(cbx));
                        }
                        catch (InvalidServiceNameException e) {
                            CATrustedPolicies.this.theSuite.showErrorDialog(CATrustedPolicies.this.thePanel, e.getMessage());
                            e.printStackTrace();
                        }
                        return super.getCellEditor(row, column);
                    }
                };
                this.tblServices.setName("tblServices");
                this.tblServices.setShowHorizontalLines(false);
                TableColumn column2 = this.tblServices.getColumnModel().getColumn(2);
                column2.setCellEditor(new DefaultCellEditor(comboBox));
            }
            catch (SecureStoreException e) {
                this.theSuite.showErrorDialog(this.thePanel, e.getMessage());
                e.printStackTrace();
            }
            catch (ASN1Exception e) {
                this.theSuite.showErrorDialog(this.thePanel, e.getMessage());
                e.printStackTrace();
            }
        }
        return this.tblServices;
    }
}

