/*
 * Decompiled with CFR 0.152.
 */
package ui.ca;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import th.co.oga.security.pki.Certification.CSRFileFilter;
import th.co.oga.security.pki.Certification.CSRProfile;
import ui.TCDSecureSuite;

public class CSRExport
extends JDialog {
    private final CSRExport theDialog = this;
    private static final long serialVersionUID = 1L;
    private JButton btnBrowse = null;
    private JButton btnSave = null;
    private JButton btnCancel = null;
    private JLabel lblCSRExport = null;
    private JLabel lblCSRFile = null;
    private JTextField txtCSRFile = null;
    private TCDSecureSuite theSuite = null;
    private JDialog self = this;
    private File selectedFile = null;
    private CSRProfile csrProfile = null;

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public CSRExport(TCDSecureSuite theSuite, CSRProfile csrProfile) {
        this.theSuite = theSuite;
        this.csrProfile = csrProfile;
        this.setName("CSR Export");
        this.initialise();
        this.setLocationRelativeTo(null);
        String filename = String.valueOf(theSuite.getCommonName()) + "_" + csrProfile.getSN() + ".csr";
        String agentHomeDir = theSuite.getAgentHomeDir();
        String crlFilename = String.valueOf(theSuite.getRoom().getOsHome()) + "/" + filename;
        this.selectedFile = new File(crlFilename);
        this.txtCSRFile.setText(crlFilename);
    }

    public JButton getBtnBrowse() {
        if (this.btnBrowse == null) {
            this.btnBrowse = new JButton();
            this.btnBrowse.setName("btnBrowse");
            this.btnBrowse.setText("Browse");
            this.btnBrowse.setBounds(280, 50, 90, 25);
            this.btnBrowse.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    JFileChooser fileChooser = CSRExport.this.theSuite.getFileChosser();
                    CSRFileFilter filter = new CSRFileFilter();
                    fileChooser.resetChoosableFileFilters();
                    fileChooser.setFileFilter((FileFilter)filter);
                    int returnVal = fileChooser.showSaveDialog(CSRExport.this.self);
                    if (returnVal == 0) {
                        CSRExport.this.selectedFile = fileChooser.getSelectedFile();
                        CSRExport.this.txtCSRFile.setText(CSRExport.this.selectedFile.getPath());
                        CSRExport.this.btnSave.setEnabled(true);
                    }
                }
            });
        }
        return this.btnBrowse;
    }

    public JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setName("btnSave");
            this.btnSave.setText("Save");
            this.btnSave.setBounds(100, 100, 90, 25);
            this.btnSave.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    try {
                        if (CSRExport.this.selectedFile == null) {
                            return;
                        }
                        CSRExport.this.csrProfile.exportCSR(CSRExport.this.selectedFile.getAbsolutePath(), CSRProfile.PEM);
                    }
                    catch (FileNotFoundException e1) {
                        CSRExport.this.theSuite.showErrorDialog(CSRExport.this.theDialog, e1.getMessage());
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        CSRExport.this.theSuite.showErrorDialog(CSRExport.this.theDialog, e1.getMessage());
                        e1.printStackTrace();
                    }
                    CSRExport.this.theSuite.showInformationDialog(CSRExport.this.theDialog, "CSR has been exported.");
                    CSRExport.this.setVisible(false);
                }
            });
        }
        return this.btnSave;
    }

    public JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setName("btnCancel");
            this.btnCancel.setText("Cancel");
            this.btnCancel.setBounds(200, 100, 90, 25);
            this.btnCancel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    CSRExport.this.setVisible(false);
                }
            });
        }
        return this.btnCancel;
    }

    private JLabel getLblCSRExport() {
        if (this.lblCSRExport == null) {
            this.lblCSRExport = new JLabel();
            this.lblCSRExport.setName("lblCSRExport");
            this.lblCSRExport.setText("CSR Export");
            this.lblCSRExport.setBounds(135, 5, 100, 25);
        }
        return this.lblCSRExport;
    }

    private JLabel getLblCSRFile() {
        if (this.lblCSRFile == null) {
            this.lblCSRFile = new JLabel();
            this.lblCSRFile.setName("lblCSRFile");
            this.lblCSRFile.setText("CSR File: ");
            this.lblCSRFile.setBounds(40, 50, 100, 25);
        }
        return this.lblCSRFile;
    }

    public JTextField getTxtCSRFile() {
        if (this.txtCSRFile == null) {
            this.txtCSRFile = new JTextField();
            this.txtCSRFile.setName("txtCSRFile");
            this.txtCSRFile.setBounds(110, 50, 160, 25);
        }
        return this.txtCSRFile;
    }

    public void initialise() {
        this.setTitle("CSR Export");
        this.setModal(true);
        this.setResizable(false);
        this.setSize(400, 200);
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(null);
        panel.add((Component)this.getBtnBrowse(), this.getBtnBrowse().getName());
        panel.add((Component)this.getBtnSave(), this.getBtnSave().getName());
        panel.add((Component)this.getBtnCancel(), this.getBtnCancel().getName());
        panel.add((Component)this.getLblCSRExport(), this.getLblCSRExport().getName());
        panel.add((Component)this.getLblCSRFile(), this.getLblCSRFile().getName());
        panel.add((Component)this.getTxtCSRFile(), this.getTxtCSRFile().getName());
    }
}

