/*
 * Decompiled with CFR 0.152.
 */
package ui.ca;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CSRGeneration;
import th.co.oga.security.pki.Certification.CSRProfile;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertificationRequestException;
import th.co.oga.security.pki.HouseKeeping.AgentProfileNotInitializedException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.HouseKeeping.RoomOperationException;
import th.co.oga.security.pki.Transport.MimeTypeNotSupportException;
import th.co.oga.security.pki.Transport.TransportPackageLoadingException;
import th.co.oga.security.pki.Transport.UnAccaptableDataPackageException;
import th.co.oga.security.pki.Transport.UnSupportProtocolException;
import th.co.oga.security.pki.Trusted.Authority;
import th.co.oga.security.pki.Trusted.AuthorityService;
import th.co.oga.security.pki.Trusted.ServiceName;
import th.co.oga.security.pki.x.CSR.CSRDataPackage;
import th.co.oga.security.pki.x.PKIDataPackage;
import th.co.oga.security.pki.x.PKITrnsOperator;
import th.co.oga.security.pki.x.PKITrnsPackage;
import ui.TCDSecureSuite;
import ui.ca.AuthorityItem;

public class CSROnlineSend
extends JDialog {
    private static final long serialVersionUID = -2831529120576466399L;
    private JLabel lblCa;
    private JComboBox cbxCa;
    private JButton btnSend;
    private JButton btnCancel;
    private TCDSecureSuite theSuite;
    private CSROnlineSend theDialog = this;
    private CSRProfile csrProfile;

    public CSROnlineSend(TCDSecureSuite theSuite, CSRProfile csrProfile) {
        this.theSuite = theSuite;
        this.csrProfile = csrProfile;
        this.initialise();
        this.putData();
        this.setName("CSR Online Send");
        this.setLocationRelativeTo(null);
    }

    private void putData() {
        Room room = this.theSuite.getRoom();
        Authority[] authList = room.getAuthoritiesByService(ServiceName.CSR);
        int i = 0;
        while (i < authList.length) {
            AuthorityItem authItem = new AuthorityItem(authList[i]);
            this.cbxCa.addItem(authItem);
            ++i;
        }
    }

    private JButton getBtnSend() {
        if (this.btnSend == null) {
            this.btnSend = new JButton();
            this.btnSend.setName("btnSend");
            this.btnSend.setText("Send");
            this.btnSend.setBounds(100, 100, 90, 25);
            this.btnSend.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        String dest = CSROnlineSend.this.doCSROnlineSend();
                        CSROnlineSend.this.theSuite.showInformationDialog(CSROnlineSend.this.theDialog, "CSR has been sent to " + dest + ".");
                        CSROnlineSend.this.setVisible(false);
                    }
                    catch (RoomOperationException e1) {
                        CSROnlineSend.this.theSuite.showErrorDialog(CSROnlineSend.this.theDialog, e1.getMessage());
                        e1.printStackTrace();
                    }
                    catch (CertificationRequestException e1) {
                        CSROnlineSend.this.theSuite.showErrorDialog(CSROnlineSend.this.theDialog, e1.getMessage());
                        e1.printStackTrace();
                    }
                    catch (MimeTypeNotSupportException e1) {
                        CSROnlineSend.this.theSuite.showErrorDialog(CSROnlineSend.this.theDialog, e1.getMessage());
                        e1.printStackTrace();
                    }
                    catch (UnAccaptableDataPackageException e1) {
                        CSROnlineSend.this.theSuite.showErrorDialog(CSROnlineSend.this.theDialog, e1.getMessage());
                        e1.printStackTrace();
                    }
                    catch (MalformedURLException e1) {
                        CSROnlineSend.this.theSuite.showErrorDialog(CSROnlineSend.this.theDialog, e1.getMessage());
                        e1.printStackTrace();
                    }
                    catch (UnSupportProtocolException e1) {
                        CSROnlineSend.this.theSuite.showErrorDialog(CSROnlineSend.this.theDialog, e1.getMessage());
                        e1.printStackTrace();
                    }
                    catch (ASN1Exception e1) {
                        CSROnlineSend.this.theSuite.showErrorDialog(CSROnlineSend.this.theDialog, e1.getMessage());
                        e1.printStackTrace();
                    }
                    catch (TransportPackageLoadingException e1) {
                        CSROnlineSend.this.theSuite.showErrorDialog(CSROnlineSend.this.theDialog, e1.getMessage());
                        e1.printStackTrace();
                    }
                    catch (AgentProfileNotInitializedException e1) {
                        CSROnlineSend.this.theSuite.showErrorDialog(CSROnlineSend.this.theDialog, e1.getMessage());
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        CSROnlineSend.this.theSuite.showErrorDialog(CSROnlineSend.this.theDialog, e1.getMessage());
                        e1.printStackTrace();
                    }
                }
            });
        }
        return this.btnSend;
    }

    protected String doCSROnlineSend() throws RoomOperationException, CertificationRequestException, AgentProfileNotInitializedException, MimeTypeNotSupportException, UnAccaptableDataPackageException, MalformedURLException, UnSupportProtocolException, ASN1Exception, TransportPackageLoadingException, IOException {
        Room room = this.theSuite.getRoom();
        CSRProfile csr = this.csrProfile;
        System.out.println("csrProfile " + this.csrProfile);
        CSRGeneration generator = room.getCSRGenerator();
        PKITrnsOperator operator = PKITrnsOperator.getInstance((Room)room);
        AuthorityItem item = (AuthorityItem)this.cbxCa.getSelectedItem();
        Authority auth = item.getAuthority();
        AuthorityService as = auth.getService(ServiceName.CSR);
        String rcpAddress = as.getRecipient();
        System.out.println("Instantiate transport operator... ");
        PKITrnsOperator trnsOper = PKITrnsOperator.getInstance((Room)room);
        System.out.println("Send CSR Profile ... ");
        trnsOper.setRequest((PKIDataPackage)new CSRDataPackage(csr));
        trnsOper.transfer(as);
        System.out.println("Unload result from connection ... ");
        PKITrnsPackage trnsPkg = trnsOper.getPKITrnsPkg();
        return rcpAddress;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setName("btnCancel");
            this.btnCancel.setText("Cancel");
            this.btnCancel.setBounds(200, 100, 90, 25);
            this.btnCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CSROnlineSend.this.setVisible(false);
                }
            });
        }
        return this.btnCancel;
    }

    private JLabel getLblCa() {
        if (this.lblCa == null) {
            this.lblCa = new JLabel();
            this.lblCa.setName("lblCa");
            this.lblCa.setText("CA :");
            this.lblCa.setBounds(40, 50, 100, 25);
        }
        return this.lblCa;
    }

    private JComboBox getCbxCa() {
        if (this.cbxCa == null) {
            this.cbxCa = new JComboBox();
            this.cbxCa.setName("cbxCa");
            this.cbxCa.setBounds(110, 50, 160, 25);
        }
        return this.cbxCa;
    }

    private void initialise() {
        this.setTitle("CSR Online Send");
        this.setModal(true);
        this.setResizable(false);
        this.setSize(400, 200);
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(null);
        panel.add((Component)this.getBtnSend(), this.getBtnSend().getName());
        panel.add((Component)this.getBtnCancel(), this.getBtnCancel().getName());
        panel.add((Component)this.getLblCa(), this.getLblCa().getName());
        panel.add((Component)this.getCbxCa(), this.getCbxCa().getName());
    }

    class CertProfileItem {
        CertProfile certProfile;

        public CertProfileItem(CertProfile profile) {
            this.certProfile = profile;
        }

        public String toString() {
            try {
                return this.certProfile.getSubjectDN().getCommonName();
            }
            catch (ASN1Exception e) {
                e.printStackTrace();
                return "Unnamed Certificate";
            }
        }

        public CertProfile getCertProfile() {
            return this.certProfile;
        }
    }
}

