/*
 * Decompiled with CFR 0.152.
 */
package ui.ca;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.Trusted.Authority;
import th.co.oga.security.pki.X500.DName;
import ui.TCDSecureSuite;
import ui.ca.VerifyDialog;

public class CSRView
extends JDialog {
    private static final long serialVersionUID = -3127847809481879024L;
    private JButton btnVerify = null;
    private JButton btnUsages = null;
    private JButton btnCATrusting = null;
    private JButton btnClose = null;
    private JLabel lblTitle = null;
    private JLabel lblUsage = null;
    private JLabel lblIssuedBy = null;
    private JLabel lblIssuedByCommonName = null;
    private JLabel lblIssuedByLocality = null;
    private JLabel lblIssuedByCountry = null;
    private JLabel lblValidity = null;
    private JLabel lblIssueDate = null;
    private JLabel lblExpiresDate = null;
    private JTextArea datUsage = null;
    private JLabel datIssuedByCommonName = null;
    private JLabel datIssuedByLocality = null;
    private JLabel datIssuedByCountry = null;
    private JLabel datIssueDate = null;
    private JLabel datExpireDate = null;
    private JPanel pnlIssuedTo = null;
    private TCDSecureSuite theSuite = null;
    private final CSRView theDialog = this;
    private CertProfile profile = null;
    private VerifyDialog verifyDialog;
    private JPanel pulSubj = null;

    public CSRView(TCDSecureSuite theSuite, CertProfile profile) {
        this.theSuite = theSuite;
        this.profile = profile;
        this.verifyDialog = new VerifyDialog(this);
        System.out.println("Profile : " + profile);
        this.initialise();
        this.putData();
        this.setModal(true);
        this.setLocationRelativeTo(null);
        this.setName("Certificate Viewer");
        this.btnUsages.setVisible(false);
    }

    private void putData() {
        String commonName = "";
        String usage = "";
        String issuerCommonName = "";
        String issuerCountry = "";
        String issuerLocality = "";
        Date issueDateObj = null;
        Date expireDateObj = null;
        try {
            DName dName = this.profile.getSubjectDN();
            commonName = dName.getCommonName();
            usage = this.profile.getUsages();
            issueDateObj = this.profile.getIssueDate();
            expireDateObj = this.profile.getExpireDate();
            DName issuerDName = this.profile.getIssuerDN();
            issuerCommonName = issuerDName.getCommonName();
            issuerCountry = issuerDName.getCountryName();
            issuerLocality = issuerDName.getLocalityName();
        }
        catch (ASN1Exception e) {
            this.theSuite.showErrorDialog(this.theDialog, e.getMessage());
            e.printStackTrace();
        }
        this.lblTitle.setText(String.valueOf(commonName) + "'s Certificate");
        this.datUsage.setText(usage);
        this.datExpireDate.setText(TCDSecureSuite.formatDate(expireDateObj));
        this.datIssueDate.setText(TCDSecureSuite.formatDate(issueDateObj));
        this.datIssuedByCommonName.setText(issuerCommonName);
        this.datIssuedByCountry.setText(issuerCountry);
        this.datIssuedByLocality.setText(issuerLocality);
    }

    private void initialise() {
        this.setTitle("Certificate Viewer");
        this.setSize(640, 600);
        this.getContentPane().setLayout(null);
        this.setFont(new Font("sansserif", 0, 10));
        this.getContentPane().add((Component)this.getLblTitle(), this.getLblTitle().getName());
        this.getContentPane().add((Component)this.getLblUsage(), this.getLblUsage().getName());
        this.getContentPane().add(this.getDatUsage());
        this.getContentPane().add((Component)this.getPnlIssuedTo(), this.getPnlIssuedTo().getName());
        this.getContentPane().add((Component)this.getLblIssuedBy(), this.getLblIssuedBy().getName());
        this.getContentPane().add((Component)this.getLblIssuedByCommonName(), this.getLblIssuedByCommonName().getName());
        this.getContentPane().add((Component)this.getLblIssuedByLocality(), this.getLblIssuedByLocality().getName());
        this.getContentPane().add((Component)this.getLblIssuedByCountry(), this.getLblIssuedByCountry().getName());
        this.getContentPane().add((Component)this.getLblValidity(), this.getLblValidity().getName());
        this.getContentPane().add((Component)this.getLblIssueDate(), this.getLblIssueDate().getName());
        this.getContentPane().add((Component)this.getLblExpiresDate(), this.getLblExpiresDate().getName());
        this.getContentPane().add((Component)this.getDatIssuedByCommonName(), this.getDatIssuedByCommonName().getName());
        this.getContentPane().add((Component)this.getDatIssuedByLocality(), this.getDatIssuedByLocality().getName());
        this.getContentPane().add((Component)this.getDatIssuedByCountry(), this.getDatIssuedByCountry().getName());
        this.getContentPane().add((Component)this.getDatIssueDate(), this.getDatIssueDate().getName());
        this.getContentPane().add((Component)this.getDatExpiresDate(), this.getDatExpiresDate().getName());
        this.getContentPane().add((Component)this.getBtnVerify(), this.getBtnVerify().getName());
        this.getContentPane().add((Component)this.getBtnUsages(), this.getBtnUsages().getName());
        this.getContentPane().add((Component)this.getBtnCATrusting(), this.getBtnCATrusting().getName());
        this.getContentPane().add((Component)this.getBtnClose(), this.getBtnClose().getName());
    }

    private JLabel getLblTitle() {
        if (this.lblTitle == null) {
            this.lblTitle = new JLabel("Passakorn Kerdpool's Certificate");
            this.lblTitle.setBounds(220, 20, 200, 20);
        }
        return this.lblTitle;
    }

    private JLabel getLblUsage() {
        if (this.lblUsage == null) {
            this.lblUsage = new JLabel("Usages :");
            this.lblUsage.setBounds(40, 40, 150, 25);
        }
        return this.lblUsage;
    }

    private JTextArea getDatUsage() {
        if (this.datUsage == null) {
            this.datUsage = new JTextArea("Sign, Encrypt");
            this.datUsage.setBackground(this.lblUsage.getBackground());
            this.datUsage.setEditable(false);
            this.datUsage.setBounds(100, 45, 500, 60);
        }
        return this.datUsage;
    }

    private JLabel getLblIssuedBy() {
        if (this.lblIssuedBy == null) {
            this.lblIssuedBy = new JLabel("Issued By :");
            this.lblIssuedBy.setBounds(40, 310, 200, 20);
        }
        return this.lblIssuedBy;
    }

    private JLabel getLblIssuedByCommonName() {
        if (this.lblIssuedByCommonName == null) {
            this.lblIssuedByCommonName = new JLabel("Common Name (CN):");
            this.lblIssuedByCommonName.setBounds(60, 330, 200, 20);
        }
        return this.lblIssuedByCommonName;
    }

    private JLabel getLblIssuedByLocality() {
        if (this.lblIssuedByLocality == null) {
            this.lblIssuedByLocality = new JLabel("Locality");
            this.lblIssuedByLocality.setBounds(60, 350, 200, 20);
        }
        return this.lblIssuedByLocality;
    }

    private JLabel getLblIssuedByCountry() {
        if (this.lblIssuedByCountry == null) {
            this.lblIssuedByCountry = new JLabel("Country");
            this.lblIssuedByCountry.setBounds(60, 370, 200, 20);
        }
        return this.lblIssuedByCountry;
    }

    private JLabel getLblValidity() {
        if (this.lblValidity == null) {
            this.lblValidity = new JLabel("Validity:");
            this.lblValidity.setBounds(40, 410, 200, 20);
        }
        return this.lblValidity;
    }

    private JLabel getLblIssueDate() {
        if (this.lblIssueDate == null) {
            this.lblIssueDate = new JLabel("Issue date:");
            this.lblIssueDate.setBounds(60, 430, 200, 20);
        }
        return this.lblIssueDate;
    }

    private JLabel getLblExpiresDate() {
        if (this.lblExpiresDate == null) {
            this.lblExpiresDate = new JLabel("Expires date:");
            this.lblExpiresDate.setBounds(60, 450, 200, 20);
        }
        return this.lblExpiresDate;
    }

    private JLabel getDatIssuedByCommonName() {
        if (this.datIssuedByCommonName == null) {
            this.datIssuedByCommonName = new JLabel("TOT CA");
            this.datIssuedByCommonName.setBounds(200, 330, 200, 20);
        }
        return this.datIssuedByCommonName;
    }

    private JLabel getDatIssuedByLocality() {
        if (this.datIssuedByLocality == null) {
            this.datIssuedByLocality = new JLabel("BKK");
            this.datIssuedByLocality.setBounds(200, 350, 200, 20);
        }
        return this.datIssuedByLocality;
    }

    private JLabel getDatIssuedByCountry() {
        if (this.datIssuedByCountry == null) {
            this.datIssuedByCountry = new JLabel("TH");
            this.datIssuedByCountry.setBounds(200, 370, 200, 20);
        }
        return this.datIssuedByCountry;
    }

    private JLabel getDatIssueDate() {
        if (this.datIssueDate == null) {
            this.datIssueDate = new JLabel("12/12/2004");
            this.datIssueDate.setBounds(200, 430, 200, 20);
        }
        return this.datIssueDate;
    }

    private JLabel getDatExpiresDate() {
        if (this.datExpireDate == null) {
            this.datExpireDate = new JLabel("12/12/2009");
            this.datExpireDate.setBounds(200, 450, 200, 20);
        }
        return this.datExpireDate;
    }

    private JPanel getPnlIssuedTo() {
        if (this.pnlIssuedTo == null) {
            this.pnlIssuedTo = new JPanel();
            this.pnlIssuedTo.setLayout(null);
            this.pnlIssuedTo.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 0)), " Issued To : "));
            this.pnlIssuedTo.setBounds(20, 100, 590, 200);
            this.pnlIssuedTo.add(this.getPulSubj());
        }
        return this.pnlIssuedTo;
    }

    private JPanel getPulSubj() {
        if (this.pulSubj == null) {
            String[] subj = this.profile.getSubjectNames();
            this.pulSubj = new JPanel(new GridLayout(0, 2, 10, 0));
            this.pulSubj.setBounds(20, 20, 350, 170);
            int i = 0;
            while (i < subj.length) {
                int charIn = subj[i].indexOf("=");
                if (charIn != -1) {
                    String[] vals = subj[i].split("=");
                    this.pulSubj.add(new JLabel(String.valueOf(vals[0]) + " : ", 4));
                    if (vals[1] != null) {
                        this.pulSubj.add(new JLabel(vals[1]));
                    } else {
                        this.pulSubj.add(new JLabel(""));
                    }
                } else {
                    this.pulSubj.add(new JLabel(""));
                    this.pulSubj.add(new JLabel(subj[i]));
                }
                ++i;
            }
            this.pulSubj.add(new JLabel("Serial Number : ", 4));
            this.pulSubj.add(new JLabel(this.profile.getSerialNumber().toString()));
        }
        return this.pulSubj;
    }

    private JButton getBtnVerify() {
        if (this.btnVerify == null) {
            this.btnVerify = new JButton("Verify");
            this.btnVerify.setBounds(120, 500, 100, 25);
            this.btnVerify.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    CSRView.this.verifyDialog.start(CSRView.this.theSuite.getRoom(), CSRView.this.profile);
                }
            });
        }
        return this.btnVerify;
    }

    private JButton getBtnCATrusting() {
        if (this.btnCATrusting == null) {
            this.btnCATrusting = new JButton("CA Trusting");
            this.btnCATrusting.setBounds(250, 500, 100, 25);
            this.btnCATrusting.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        Room room = CSRView.this.theSuite.getRoom();
                        Authority authority = room.getAuthority(CSRView.this.profile.getAuthorityName());
                        if (authority != null) {
                            System.out.println("CA Trusting for the profile issuer: " + authority.getName());
                            CSRView.this.theSuite.showCARegisterDialog(authority, false);
                        } else {
                            CSRView.this.theSuite.showWarningDialog(CSRView.this.theDialog, "Authority no configered.");
                        }
                    }
                    catch (ASN1Exception e) {
                        CSRView.this.theSuite.showErrorDialog(CSRView.this.theDialog, e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
        }
        return this.btnCATrusting;
    }

    private JButton getBtnClose() {
        if (this.btnClose == null) {
            this.btnClose = new JButton("Close");
            this.btnClose.setBounds(380, 500, 100, 25);
            this.btnClose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    System.out.println("Close from CSRView");
                    CSRView.this.theDialog.setModal(true);
                    CSRView.this.theDialog.setVisible(false);
                }
            });
        }
        return this.btnClose;
    }

    private JButton getBtnUsages() {
        if (this.btnUsages == null) {
            this.btnUsages = new JButton("Usages");
            this.btnUsages.setBounds(190, 500, 100, 25);
        }
        return this.btnUsages;
    }
}

